/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.KeyStroke;
import ptolemy.kernel.undo.UndoAction;
import ptolemy.kernel.undo.UndoStackAttribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.toolbox.FigureAction;

public class MoveAction
extends FigureAction {
    public static final MoveType DOWN = new MoveType();
    public static final MoveType TO_FIRST = new MoveType();
    public static final MoveType TO_LAST = new MoveType();
    public static final MoveType UP = new MoveType();
    private MoveType _type;

    public MoveAction(String description, MoveType type) {
        super(description);
        this._type = type;
        if (this._type == TO_FIRST) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
        } else if (this._type == TO_LAST) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
        }
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        final NamedObj target = this.getTarget();
        if (target == null) {
            return;
        }
        if (target.getDerivedLevel() < Integer.MAX_VALUE) {
            MessageHandler.error((String)("Cannot change the position of " + target.getFullName() + " because the position is set by the class."));
            return;
        }
        ChangeRequest request = new ChangeRequest(target, "Move towards last"){

            protected void _execute() throws IllegalActionException {
                LinkedList<NamedObj> targets = new LinkedList<NamedObj>();
                targets.add(target);
                MoveAction.move(targets, MoveAction.this._type, target);
            }
        };
        target.requestChange(request);
    }

    public static void move(final List targets, final MoveType type, final NamedObj context) {
        final int[] priorIndexes = new int[targets.size()];
        boolean movedOne = false;
        try {
            int i;
            Iterator targetIterator;
            if (type == TO_FIRST || type == UP) {
                targetIterator = targets.listIterator(targets.size());
                i = targets.size() - 1;
                while (i >= 0) {
                    NamedObj target = (NamedObj)targetIterator.previous();
                    priorIndexes[i] = type == DOWN ? target.moveDown() : (type == TO_FIRST ? target.moveToFirst() : (type == TO_LAST ? target.moveToLast() : target.moveUp()));
                    if (priorIndexes[i] >= 0) {
                        movedOne = true;
                    }
                    --i;
                }
            } else {
                targetIterator = targets.iterator();
                i = 0;
                while (i < targets.size()) {
                    NamedObj target = (NamedObj)targetIterator.next();
                    priorIndexes[i] = type == DOWN ? target.moveDown() : (type == TO_FIRST ? target.moveToFirst() : (type == TO_LAST ? target.moveToLast() : target.moveUp()));
                    if (priorIndexes[i] >= 0) {
                        movedOne = true;
                    }
                    ++i;
                }
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
        if (!movedOne) {
            return;
        }
        UndoAction undoAction = new UndoAction(){

            public void execute() {
                try {
                    int i;
                    Iterator targetIterator;
                    if (type == TO_FIRST || type == UP) {
                        targetIterator = targets.iterator();
                        i = 0;
                        while (i < targets.size()) {
                            NamedObj target = (NamedObj)targetIterator.next();
                            target.moveToIndex(priorIndexes[i]);
                            ++i;
                        }
                    } else {
                        targetIterator = targets.listIterator(targets.size());
                        i = targets.size() - 1;
                        while (i >= 0) {
                            NamedObj target = (NamedObj)targetIterator.previous();
                            target.moveToIndex(priorIndexes[i]);
                            --i;
                        }
                    }
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                UndoAction redoAction = new UndoAction(){

                    public void execute() {
                        MoveAction.move(targets, type, context);
                    }
                };
                UndoStackAttribute undoInfo = UndoStackAttribute.getUndoInfo((NamedObj)context);
                undoInfo.push(redoAction);
            }
        };
        UndoStackAttribute undoInfo = UndoStackAttribute.getUndoInfo((NamedObj)context);
        undoInfo.push(undoAction);
    }

    private static class MoveType {
        private MoveType() {
        }
    }
}

