/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import diva.gui.toolbox.JContextMenu;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.toolbox.MenuItemFactory;

public class MenuActionFactory
implements MenuItemFactory {
    private Action _action;
    private Action[] _actions;
    private String _label;

    public MenuActionFactory(Action action) {
        this._action = action;
    }

    public MenuActionFactory(Action[] actions, String label) {
        this._actions = actions;
        this._label = label;
    }

    public void addAction(Action action, String label) {
        if (this._action != null) {
            this._actions = new Action[2];
            this._actions[0] = this._action;
            this._actions[1] = action;
            this._action = null;
        } else {
            Action[] newActions = new Action[this._actions.length + 1];
            System.arraycopy(this._actions, 0, newActions, 0, this._actions.length);
            newActions[this._actions.length] = action;
            this._actions = newActions;
        }
        this._label = label;
    }

    public void addActions(Action[] actions, String label) {
        int start = 0;
        if (this._action != null) {
            this._actions = new Action[actions.length + 1];
            this._actions[0] = this._action;
            start = 1;
            this._action = null;
        } else {
            Action[] newActions = new Action[this._actions.length + actions.length];
            System.arraycopy(this._actions, 0, newActions, 0, this._actions.length);
            start = this._actions.length;
            this._actions = newActions;
        }
        System.arraycopy(actions, 0, this._actions, start, actions.length);
        this._label = label;
    }

    public JMenuItem create(JContextMenu menu, NamedObj object) {
        if (this._action != null) {
            return menu.add(this._action, (String)this._action.getValue("Name"));
        }
        JMenu submenu = new JMenu(this._label);
        menu.add((Component)submenu, (Object)this._label);
        int i = 0;
        while (i < this._actions.length) {
            submenu.add(this._actions[i]);
            ++i;
        }
        return submenu;
    }
}

