/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import java.awt.event.ActionEvent;
import java.util.List;
import ptolemy.actor.gui.Configuration;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.icon.XMLIcon;
import ptolemy.vergil.toolbox.FigureAction;

public class EditIconAction
extends FigureAction {
    private Configuration _configuration;

    public EditIconAction() {
        super("Edit Custom Icon");
    }

    public void actionPerformed(ActionEvent e) {
        if (this._configuration == null) {
            MessageHandler.error((String)"Cannot edit icon without a configuration.");
            return;
        }
        super.actionPerformed(e);
        final NamedObj object = this.getTarget();
        ChangeRequest request = new ChangeRequest(this, "Edit Custom Icon"){

            protected void _execute() throws Exception {
                EditorIcon icon = null;
                List iconList = object.attributeList(EditorIcon.class);
                if (iconList.size() > 0) {
                    icon = (EditorIcon)((Object)iconList.get(iconList.size() - 1));
                }
                if (icon == null) {
                    icon = new EditorIcon(object, "_icon");
                } else if (icon instanceof XMLIcon) {
                    icon.setContainer(null);
                    icon = new EditorIcon(object, "_icon");
                    for (NamedObj derived : object.getDerivedList()) {
                        EditorIcon derivedIcon = null;
                        List derivedIconList = derived.attributeList(EditorIcon.class);
                        if (derivedIconList.size() > 0) {
                            derivedIcon = (EditorIcon)((Object)derivedIconList.get(derivedIconList.size() - 1));
                        }
                        if (!(derivedIcon instanceof XMLIcon)) continue;
                        derivedIcon.setContainer(null);
                    }
                    icon.propagateExistence();
                }
                EditIconAction.this._configuration.openModel((NamedObj)icon);
            }
        };
        object.requestChange(request);
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }
}

