/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import ptolemy.actor.gui.EditParametersDialog;
import ptolemy.actor.gui.EditorFactory;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.toolbox.FigureAction;

public class ConfigureAction
extends FigureAction {
    public ConfigureAction(String description) {
        super(description);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    public void actionPerformed(ActionEvent e) {
        try {
            super.actionPerformed(e);
            NamedObj target = this.getTarget();
            if (target == null) {
                return;
            }
            Frame parent = this.getFrame();
            this._openDialog(parent, target, e);
        }
        catch (Throwable throwable) {
            MessageHandler.error((String)"Failed to open a dialog to edit the target.", (Throwable)throwable);
        }
    }

    public void openDialog(Frame parent, NamedObj target) {
        this._openDialog(parent, target, null);
    }

    private void _openDialog(Frame parent, NamedObj target, ActionEvent event) {
        List attributeList = target.attributeList(EditorFactory.class);
        boolean altKeyPressed = false;
        if (event != null) {
            boolean bl = altKeyPressed = (event.getModifiers() & 8) != 0;
        }
        if (attributeList.size() > 0 && !altKeyPressed) {
            EditorFactory factory = (EditorFactory)((Object)attributeList.get(0));
            factory.createEditor(target, parent);
        } else {
            new EditParametersDialog(parent, target);
        }
    }
}

