/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.BoundsGeometry;
import diva.canvas.interactor.BoundsManipulator;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.GrabHandle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.toolbox.SnapConstraint;

public class AttributeBoundsManipulator
extends BoundsManipulator {
    private FigureDecorator _instanceDecorator;
    private NamedObj _container;
    private Resizer _resizer;

    public AttributeBoundsManipulator(NamedObj container) {
        this._container = container;
        this._resizer = new Resizer();
        this.setHandleInteractor(this._resizer);
    }

    public void mouseReleased(LayerEvent e) {
        Figure child = this.getChild();
        if (child == null && this._instanceDecorator != null) {
            child = this._instanceDecorator.getChild();
        }
        if (child != null) {
            Rectangle2D bounds = child.getShape().getBounds2D();
            Rectangle2D childBounds = child.getBounds();
            Attribute widthParameter = this._container.getAttribute("width");
            Attribute heightParameter = this._container.getAttribute("height");
            Attribute locationParameter = this._container.getAttribute("_location");
            if (widthParameter != null && heightParameter != null) {
                StringBuffer command = new StringBuffer("<group><property name =\"width\" value=\"");
                command.append(Math.rint(bounds.getWidth()));
                command.append("\"/><property name =\"height\" value=\"");
                command.append(Math.rint(bounds.getHeight()));
                command.append("\"/>");
                if (locationParameter != null) {
                    double newX = childBounds.getX();
                    double newY = childBounds.getY();
                    try {
                        boolean isCentered;
                        Attribute centered = this._container.getAttribute("centered", Parameter.class);
                        if (centered != null && (isCentered = ((BooleanToken)((Parameter)centered).getToken()).booleanValue())) {
                            newX = childBounds.getCenterX();
                            newY = childBounds.getCenterY();
                        }
                    }
                    catch (IllegalActionException illegalActionException) {}
                    command.append("<property name = \"_location\" value=\"");
                    command.append(Math.rint(newX));
                    command.append(", ");
                    command.append(Math.rint(newY));
                    command.append("\"/>");
                }
                command.append("</group>");
                MoMLChangeRequest request = new MoMLChangeRequest((Object)this, this._container, command.toString());
                this._container.requestChange((ChangeRequest)request);
            }
        } else {
            throw new InternalErrorException("No child figure for the manipulator!");
        }
    }

    public FigureDecorator newInstance(Figure f) {
        AttributeBoundsManipulator m = new AttributeBoundsManipulator(this._container);
        m.setGrabHandleFactory(this.getGrabHandleFactory());
        m.setHandleInteractor(this.getHandleInteractor());
        m.setDragInteractor(this.getDragInteractor());
        this._instanceDecorator = m;
        return m;
    }

    public void setSnapResolution(double resolution) {
        this._resizer.setSnapResolution(resolution);
    }

    private class Resizer
    extends DragInteractor {
        private SnapConstraint _snapConstraint = new SnapConstraint();

        public Resizer() {
            this.appendConstraint(this._snapConstraint);
        }

        public void mouseReleased(LayerEvent e) {
            super.mouseReleased(e);
            AttributeBoundsManipulator.this.mouseReleased(e);
        }

        public void setSnapResolution(double resolution) {
            this._snapConstraint.setResolution(resolution);
        }

        public void translate(LayerEvent e, double x, double y) {
            double[] snapped = this._snapConstraint.constrain(x, y);
            GrabHandle g = (GrabHandle)e.getFigureSource();
            g.translate(snapped[0], snapped[1]);
            BoundsManipulator parent = (BoundsManipulator)g.getParent();
            BoundsGeometry geometry = parent.getGeometry();
            parent.getChild().transform(CanvasUtilities.computeTransform((RectangularShape)parent.getChild().getBounds(), (RectangularShape)geometry.getBounds()));
        }
    }
}

