/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel.attributes;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.ShapeIcon;
import ptolemy.vergil.kernel.attributes.VisibleAttribute;

public abstract class ShapeAttribute
extends VisibleAttribute {
    public Parameter dashArray;
    public ColorAttribute lineColor;
    public Parameter lineWidth;
    protected ShapeIcon _icon = new ShapeIcon((NamedObj)this, "_icon", this._getDefaultShape());
    protected Variable _none;

    public ShapeAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._icon.setPersistent(false);
        new Location((NamedObj)this, "_location");
        this._none = new Variable((NamedObj)this, "none");
        this._none.setExpression("{1.0, 1.0, 1.0, 0.0}");
        this.lineWidth = new Parameter((NamedObj)this, "lineWidth");
        this.lineWidth.setTypeEquals((Type)BaseType.DOUBLE);
        this.lineWidth.setExpression("1.0");
        this.lineColor = new ColorAttribute((NamedObj)this, "lineColor");
        this.lineColor.setExpression("{0.0, 0.0, 0.0, 1.0}");
        this.dashArray = new Parameter((NamedObj)this, "dashArray");
        this.dashArray.setTypeEquals((Type)new ArrayType((Type)BaseType.DOUBLE));
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.lineWidth) {
            double lineWidthValue = ((DoubleToken)this.lineWidth.getToken()).doubleValue();
            this._icon.setLineWidth((float)lineWidthValue);
        } else if (attribute == this.dashArray) {
            ArrayToken value = (ArrayToken)this.dashArray.getToken();
            if (value == null || value.length() == 0) {
                this._icon.setDashArray(null);
            } else {
                float[] floatValue = new float[value.length()];
                int i = 0;
                while (i < value.length()) {
                    floatValue[i] = (float)((DoubleToken)value.getElement(i)).doubleValue();
                    ++i;
                }
                this._icon.setDashArray(floatValue);
            }
        } else if (attribute == this.lineColor) {
            Color lineColorValue = this.lineColor.asColor();
            if ((float)lineColorValue.getAlpha() == 0.0f) {
                this._icon.setLineColor(null);
            } else {
                this._icon.setLineColor(lineColorValue);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ShapeAttribute newObject = (ShapeAttribute)((Object)super.clone(workspace));
        newObject._icon = (ShapeIcon)newObject.getAttribute("_icon");
        newObject._none = (Variable)newObject.getAttribute("_none");
        return newObject;
    }

    protected Shape _getDefaultShape() {
        return new Rectangle2D.Double(0.0, 0.0, 20.0, 20.0);
    }
}

