/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel.attributes;

import java.awt.Polygon;
import java.awt.Shape;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.kernel.attributes.FilledShapeAttribute;

public class ResizablePolygonAttribute
extends FilledShapeAttribute {
    public Parameter vertices = new Parameter((NamedObj)this, "vertices");

    public ResizablePolygonAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        ArrayType type = new ArrayType((Type)BaseType.DOUBLE);
        this.vertices.setTypeEquals((Type)type);
        this.vertices.setExpression("{0.0, 0.0, 50.0, 0.0, 25.0, 50.0, -25.0, 50.0}");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.vertices || attribute == this.width || attribute == this.height && !this._inAttributeChanged) {
            ArrayToken verticesValue = (ArrayToken)this.vertices.getToken();
            int length = verticesValue.length();
            if (length / 2 != (length + 1) / 2) {
                throw new IllegalActionException((Nameable)this, "Length of the vertices array is required to be even.");
            }
            try {
                this._inAttributeChanged = true;
                double widthValue = ((DoubleToken)this.width.getToken()).doubleValue();
                double heightValue = ((DoubleToken)this.height.getToken()).doubleValue();
                this._widthValue = widthValue;
                this._heightValue = heightValue;
                this._icon.setShape(this._newShape());
            }
            finally {
                this._inAttributeChanged = false;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    protected Shape _newShape() {
        try {
            ArrayToken verticesValue = (ArrayToken)this.vertices.getToken();
            int length = verticesValue.length();
            double[] xPoints = new double[length / 2];
            double[] yPoints = new double[length / 2];
            double xMax = Double.NEGATIVE_INFINITY;
            double xMin = Double.POSITIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            int j = 0;
            while (j < length / 2) {
                xPoints[j] = ((DoubleToken)verticesValue.getElement(2 * j)).doubleValue();
                yPoints[j] = ((DoubleToken)verticesValue.getElement(2 * j + 1)).doubleValue();
                if (xPoints[j] > xMax) {
                    xMax = xPoints[j];
                }
                if (xPoints[j] < xMin) {
                    xMin = xPoints[j];
                }
                if (yPoints[j] > yMax) {
                    yMax = yPoints[j];
                }
                if (yPoints[j] < yMin) {
                    yMin = yPoints[j];
                }
                ++j;
            }
            double scaleX = this._widthValue / (xMax - xMin);
            double scaleY = this._heightValue / (yMax - yMin);
            int j2 = 0;
            while (j2 < length / 2) {
                int n = j2;
                xPoints[n] = xPoints[n] * scaleX;
                int n2 = j2++;
                yPoints[n2] = yPoints[n2] * scaleY;
            }
            int[] xInt = new int[length / 2];
            int[] yInt = new int[length / 2];
            if (this._centeredValue) {
                double xOffset = (xMin - xMax) / 2.0;
                double yOffset = (yMin - yMax) / 2.0;
                int i = 0;
                while (i < length / 2) {
                    xInt[i] = (int)Math.rint(xPoints[i] + xOffset);
                    yInt[i] = (int)Math.rint(yPoints[i] + yOffset);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < length / 2) {
                    xInt[i] = (int)Math.rint(xPoints[i]);
                    yInt[i] = (int)Math.rint(yPoints[i]);
                    ++i;
                }
            }
            return new Polygon(xInt, yInt, length / 2);
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

