/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel.attributes;

import java.text.DateFormat;
import java.util.Date;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.kernel.Entity;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.SingletonAttribute;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.icon.BoxedValuesIcon;

public class IDAttribute
extends SingletonAttribute {
    public StringAttribute author;
    public StringAttribute contributors;
    public StringAttribute created;
    public StringAttribute baseClass;
    public StringAttribute isClass;
    public StringAttribute lastUpdated;
    public StringAttribute name = new StringAttribute((NamedObj)this, "name");

    public IDAttribute(Entity container, String name) throws IllegalActionException, NameDuplicationException {
        super((NamedObj)container, name);
        this.name.setExpression(container.getName());
        this.name.setPersistent(false);
        this.name.setVisibility(Settable.NOT_EDITABLE);
        container.isClassDefinition();
        String className = container.getClassName();
        this.baseClass = new StringAttribute((NamedObj)this, "baseClass");
        this.baseClass.setExpression(className);
        this.baseClass.setPersistent(false);
        this.baseClass.setVisibility(Settable.NOT_EDITABLE);
        URIAttribute modelURI = (URIAttribute)container.getAttribute("_uri", URIAttribute.class);
        if (modelURI != null) {
            StringAttribute definedIn = new StringAttribute((NamedObj)this, "definedIn");
            definedIn.setExpression(modelURI.getURI().toString());
            definedIn.setPersistent(false);
            definedIn.setVisibility(Settable.NOT_EDITABLE);
        }
        this.created = new StringAttribute((NamedObj)this, "created");
        this.created.setExpression(DateFormat.getDateTimeInstance().format(new Date()));
        this.created.setVisibility(Settable.NOT_EDITABLE);
        this.created.setPersistent(true);
        this.lastUpdated = new StringAttribute((NamedObj)this, "lastUpdated");
        this._updateDate();
        this.lastUpdated.setVisibility(Settable.NOT_EDITABLE);
        this.lastUpdated.setPersistent(true);
        this.author = new StringAttribute((NamedObj)this, "author");
        this.author.setVisibility(Settable.NOT_EDITABLE);
        String userName = null;
        try {
            userName = StringUtilities.getProperty((String)"user.name");
        }
        catch (Exception exception) {
            System.out.println("Warning, in IDAttribute, failed to read 'user.name' property (-sandbox or applets always cause this)");
        }
        if (userName != null) {
            this.author.setExpression(userName);
        }
        this.author.setPersistent(true);
        this.contributors = new StringAttribute((NamedObj)this, "contributors");
        String contributorsNames = "";
        this.contributors.setExpression(contributorsNames);
        this.author.setPersistent(true);
        SingletonParameter hide = new SingletonParameter((NamedObj)this, "_hideName");
        hide.setToken((Token)BooleanToken.TRUE);
        hide.setVisibility(Settable.EXPERT);
        BoxedValuesIcon icon = new BoxedValuesIcon((NamedObj)this, "_icon");
        icon.setPersistent(false);
        Parameter hideAllParameters = new Parameter((NamedObj)this, "_hideAllParameters");
        hideAllParameters.setVisibility(Settable.EXPERT);
        hideAllParameters.setExpression("true");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.name) {
            NamedObj container = this.getContainer();
            try {
                container.setName(this.name.getExpression());
            }
            catch (NameDuplicationException e) {
                throw new IllegalActionException((Nameable)this, (Throwable)e, "Cannot change the name of the container to match.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void updateContent() throws InternalErrorException {
        super.updateContent();
        this._updateDate();
    }

    private void _updateDate() {
        try {
            this.lastUpdated.setExpression(DateFormat.getDateTimeInstance().format(new Date()));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

