/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel;

import diva.graph.modular.CompositeModel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.Director;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Vertex;

public class CompositePtolemyModel
implements CompositeModel {
    private Object _composite;
    private Object _compositeBefore;
    private Object _compositeAfter;
    private List _nodeList;
    private List _nodeListBefore;
    private List _nodeListAfter;
    private long _version;
    private long _versionBefore;
    private long _versionAfter;

    public int getNodeCount(Object composite) {
        if (!(composite instanceof NamedObj)) {
            return 0;
        }
        long version = ((NamedObj)composite).workspace().getVersion();
        if (this._nodeList == null || composite != this._composite || version != this._version) {
            this._nodeList = this._nodeList((NamedObj)composite, true, true);
            this._composite = composite;
            this._version = version;
        }
        return this._nodeList.size();
    }

    public Iterator nodes(Object composite) {
        if (!(composite instanceof NamedObj)) {
            return new LinkedList().iterator();
        }
        long version = ((NamedObj)composite).workspace().getVersion();
        if (this._nodeList == null || composite != this._composite || version != this._version) {
            this._nodeList = this._nodeList((NamedObj)composite, true, true);
            this._composite = composite;
            this._version = version;
        }
        return this._nodeList.iterator();
    }

    public Iterator nodesBeforeEdges(Object composite) {
        if (!(composite instanceof NamedObj)) {
            return new LinkedList().iterator();
        }
        long version = ((NamedObj)composite).workspace().getVersion();
        if (this._nodeListBefore == null || composite != this._compositeBefore || version != this._versionBefore) {
            this._nodeListBefore = this._nodeList((NamedObj)composite, true, false);
            this._compositeBefore = composite;
            this._versionBefore = version;
        }
        return this._nodeListBefore.iterator();
    }

    public Iterator nodesAfterEdges(Object composite) {
        if (!(composite instanceof NamedObj)) {
            return new LinkedList().iterator();
        }
        long version = ((NamedObj)composite).workspace().getVersion();
        if (this._nodeListAfter == null || composite != this._compositeAfter || version != this._versionAfter) {
            this._nodeListAfter = this._nodeList((NamedObj)composite, false, true);
            this._compositeAfter = composite;
            this._versionAfter = version;
        }
        return this._nodeListAfter.iterator();
    }

    protected Locatable _getLocation(NamedObj object) {
        List locations = object.attributeList(Locatable.class);
        if (locations.size() > 0) {
            return (Locatable)locations.get(0);
        }
        try {
            Location location = new Location(object, "_location");
            location.propagateExistence();
            return location;
        }
        catch (Exception e) {
            throw new InternalErrorException((Nameable)object, (Throwable)e, "Failed to create location, even though one does not exist.");
        }
    }

    private List _nodeList(NamedObj composite, boolean before, boolean after) {
        LinkedList nodes = new LinkedList();
        try {
            List locations;
            composite.workspace().getReadAccess();
            if (before) {
                for (Attribute attribute : composite.attributeList()) {
                    locations = attribute.attributeList(Locatable.class);
                    if (locations.size() <= 0 || attribute.getAttribute("_renderFirst") == null) continue;
                    nodes.add(locations.get(0));
                }
                if (composite instanceof CompositeEntity) {
                    for (ComponentEntity entity : ((CompositeEntity)composite).classDefinitionList()) {
                        nodes.add(this._getLocation((NamedObj)entity));
                    }
                    for (ComponentEntity entity : ((CompositeEntity)composite).entityList()) {
                        nodes.add(this._getLocation((NamedObj)entity));
                    }
                }
                if (composite instanceof Entity) {
                    for (ComponentPort port : ((Entity)composite).portList()) {
                        nodes.add(this._getLocation((NamedObj)port));
                    }
                }
                if (composite instanceof CompositeEntity) {
                    for (ComponentRelation relation : ((CompositeEntity)composite).relationList()) {
                        List vertexList = relation.attributeList(Vertex.class);
                        if (vertexList.size() != 0) {
                            for (Vertex v : vertexList) {
                                nodes.add(v);
                            }
                            continue;
                        }
                        int count = relation.linkedPortList().size();
                        if (count == 2) continue;
                        try {
                            String name = relation.uniqueName("vertex");
                            Vertex vertex = new Vertex((Relation)relation, name);
                            nodes.add(vertex);
                            vertex.propagateExistence();
                        }
                        catch (Throwable throwable) {
                            throw new InternalErrorException(null, throwable, "Failed to create a vertex!");
                        }
                    }
                }
                for (Attribute attribute : composite.attributeList()) {
                    if (attribute.getAttribute("_renderFirst") != null || attribute.getAttribute("_renderLast") != null) continue;
                    if (attribute instanceof Director) {
                        nodes.add(this._getLocation((NamedObj)attribute));
                        continue;
                    }
                    locations = attribute.attributeList(Locatable.class);
                    if (locations.size() <= 0) continue;
                    nodes.add(locations.get(0));
                }
            }
            if (after) {
                for (Attribute attribute : composite.attributeList()) {
                    locations = attribute.attributeList(Locatable.class);
                    if (locations.size() <= 0 || attribute.getAttribute("_renderLast") == null) continue;
                    nodes.add(locations.get(0));
                }
            }
            LinkedList linkedList = nodes;
            return linkedList;
        }
        finally {
            composite.workspace().doneReading();
        }
    }
}

