/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel;

import diva.canvas.Figure;
import diva.canvas.FigureContainer;
import diva.canvas.FigureDecorator;
import diva.canvas.interactor.SelectionRenderer;
import diva.canvas.toolbox.BasicHighlighter;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Hashtable;
import javax.swing.SwingUtilities;

public class AnimationRenderer
implements SelectionRenderer {
    protected FigureDecorator _prototypeDecorator;
    private Hashtable _decorators = new Hashtable();

    public AnimationRenderer() {
        this(Color.red);
    }

    public AnimationRenderer(Color color) {
        this._prototypeDecorator = new BasicHighlighter((Paint)color, 6.0f);
    }

    public AnimationRenderer(Color color, Stroke stroke) {
        this._prototypeDecorator = new BasicHighlighter((Paint)color, 4.0f, null, stroke);
    }

    public AnimationRenderer(FigureDecorator decorator) {
        this._prototypeDecorator = decorator;
    }

    public FigureDecorator getDecorator() {
        return this._prototypeDecorator;
    }

    public synchronized boolean isRenderedSelected(Figure figure) {
        return this._decorators.containsKey(figure);
    }

    public void renderDeselected(final Figure figure) {
        Runnable doUndecorate = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AnimationRenderer animationRenderer = AnimationRenderer.this;
                synchronized (animationRenderer) {
                    if (!AnimationRenderer.this._decorators.containsKey(figure)) {
                        return;
                    }
                    FigureDecorator d = (FigureDecorator)AnimationRenderer.this._decorators.get(figure);
                    if (d.getParent() != null) {
                        figure.repaint();
                        ((FigureContainer)d.getParent()).undecorate(d);
                    }
                    AnimationRenderer.this._decorators.remove(figure);
                }
            }
        };
        SwingUtilities.invokeLater(doUndecorate);
        Thread.yield();
    }

    public void renderSelected(final Figure figure) {
        Runnable doDecorate = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AnimationRenderer animationRenderer = AnimationRenderer.this;
                synchronized (animationRenderer) {
                    if (AnimationRenderer.this._decorators.containsKey(figure)) {
                        ((Figure)AnimationRenderer.this._decorators.get(figure)).repaint();
                    } else {
                        FigureContainer parent = (FigureContainer)figure.getParent();
                        if (parent != null) {
                            FigureDecorator d = AnimationRenderer.this._prototypeDecorator.newInstance(figure);
                            parent.decorate(figure, d);
                            AnimationRenderer.this._decorators.put(figure, d);
                        }
                    }
                }
            }
        };
        SwingUtilities.invokeLater(doDecorate);
        Thread.yield();
    }

    public void setDecorator(FigureDecorator decorator) {
        this._prototypeDecorator = decorator;
    }
}

