/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.Figure;
import diva.canvas.toolbox.BasicFigure;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import ptolemy.gui.Top;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.DynamicEditorIcon;

public class ShapeIcon
extends DynamicEditorIcon {
    private boolean _centered = false;
    private float[] _dashArray;
    private Color _fillColor = Color.white;
    private Color _lineColor = Color.black;
    private float _lineWidth = 1.0f;
    private Shape _shape;

    public ShapeIcon(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public ShapeIcon(NamedObj container, String name, Shape defaultShape) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setShape(defaultShape);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ShapeIcon newObject = (ShapeIcon)((Object)super.clone(workspace));
        return newObject;
    }

    public Figure createBackgroundFigure() {
        BasicFigure newFigure = this._shape != null ? new BasicFigure(this._shape) : new BasicFigure((Shape)new Rectangle2D.Double(0.0, 0.0, 20.0, 20.0));
        newFigure.setCentered(this._centered);
        newFigure.setLineWidth(this._lineWidth);
        newFigure.setDashArray(this._dashArray);
        newFigure.setStrokePaint((Paint)this._lineColor);
        newFigure.setFillPaint((Paint)this._fillColor);
        this._addLiveFigure((Figure)newFigure);
        return newFigure;
    }

    public boolean isCentered() {
        return this._centered;
    }

    public void setCentered(boolean centered) {
        if (this._centered == centered) {
            return;
        }
        this._centered = centered;
        Runnable doSet = new Runnable(){

            public void run() {
                Iterator figures = ShapeIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    Object figure = figures.next();
                    ((BasicFigure)figure).setCentered(ShapeIcon.this._centered);
                }
            }
        };
        SwingUtilities.invokeLater(doSet);
    }

    public void setDashArray(float[] dashArray) {
        if (this._dashArray != null && Arrays.equals(this._dashArray, dashArray)) {
            return;
        }
        this._dashArray = dashArray;
        Runnable doSet = new Runnable(){

            public void run() {
                Iterator figures = ShapeIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    Object figure = figures.next();
                    ((BasicFigure)figure).setDashArray(ShapeIcon.this._dashArray);
                }
            }
        };
        SwingUtilities.invokeLater(doSet);
    }

    public void setFillColor(Color fillColor) {
        if (this._fillColor != null && this._fillColor.equals(fillColor)) {
            return;
        }
        this._fillColor = fillColor;
        Runnable doSet = new Runnable(){

            public void run() {
                Iterator figures = ShapeIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    Object figure = figures.next();
                    ((BasicFigure)figure).setFillPaint((Paint)ShapeIcon.this._fillColor);
                }
            }
        };
        SwingUtilities.invokeLater(doSet);
    }

    public void setLineColor(Color lineColor) {
        if (this._lineColor != null && this._lineColor.equals(lineColor)) {
            return;
        }
        this._lineColor = lineColor;
        Runnable doSet = new Runnable(){

            public void run() {
                Iterator figures = ShapeIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    Object figure = figures.next();
                    ((BasicFigure)figure).setStrokePaint((Paint)ShapeIcon.this._lineColor);
                }
            }
        };
        SwingUtilities.invokeLater(doSet);
    }

    public void setLineWidth(float lineWidth) {
        if (this._lineWidth == lineWidth) {
            return;
        }
        this._lineWidth = lineWidth;
        Runnable doSet = new Runnable(){

            public void run() {
                Iterator figures = ShapeIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    Object figure = figures.next();
                    ((BasicFigure)figure).setLineWidth(ShapeIcon.this._lineWidth);
                }
            }
        };
        SwingUtilities.invokeLater(doSet);
    }

    public void setShape(Shape path) {
        this._shape = path;
        Runnable doSet = new Runnable(){

            public void run() {
                Iterator figures = ShapeIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    Object figure = figures.next();
                    ((BasicFigure)figure).setPrototypeShape(ShapeIcon.this._shape);
                }
            }
        };
        Top.deferIfNecessary(doSet);
    }
}

