/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.Figure;
import diva.canvas.toolbox.ImageFigure;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.FileUtilities;
import ptolemy.vergil.icon.DynamicEditorIcon;

public class ImageIcon
extends DynamicEditorIcon
implements ImageObserver {
    private int _height = -1;
    private Image _image;
    private Image _scaledImage;
    private double _scalePercentage = 100.0;
    private int _width = -1;

    public ImageIcon(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ImageIcon newObject = (ImageIcon)super.clone(workspace);
        newObject._image = null;
        newObject._scaledImage = null;
        return newObject;
    }

    public Figure createBackgroundFigure() {
        if (this._scaledImage == null) {
            try {
                URL url = FileUtilities.nameToURL((String)"/doc/img/PtolemyIISmall.gif", null, null);
                Toolkit tk = Toolkit.getDefaultToolkit();
                this.setImage(tk.getImage(url));
            }
            catch (IOException iOException) {}
        }
        ImageFigure newFigure = new ImageFigure(this._scaledImage);
        this._addLiveFigure((Figure)newFigure);
        return newFigure;
    }

    public boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 3) != 0) {
            this._height = height;
            this._width = width;
            this._image.getWidth(this);
            this._image.getHeight(this);
            return true;
        }
        if ((infoflags & 0x20) != 0) {
            this.scaleImage(this._scalePercentage);
            Runnable doRepaint = new Runnable(){

                public void run() {
                    Iterator figures = ImageIcon.this._liveFigureIterator();
                    while (figures.hasNext()) {
                        Object figure = figures.next();
                        ((ImageFigure)figure).repaint();
                    }
                }
            };
            SwingUtilities.invokeLater(doRepaint);
            return false;
        }
        if ((infoflags & 0xC0) != 0) {
            return false;
        }
        this._image.getWidth(this);
        this._image.getHeight(this);
        return true;
    }

    public void scaleImage(double percentage) {
        if (percentage == this._scalePercentage) {
            return;
        }
        this._scalePercentage = percentage;
        Runnable doScale = new Runnable(){

            public void run() {
                if (ImageIcon.this._image == null) {
                    return;
                }
                int width = ImageIcon.this._image.getWidth(ImageIcon.this);
                int height = ImageIcon.this._image.getHeight(ImageIcon.this);
                if (width < 0 || height < 0) {
                    width = ImageIcon.this._width;
                    height = ImageIcon.this._height;
                }
                if (width > 0 && height > 0) {
                    int newWidth = (int)Math.round((double)width * ImageIcon.this._scalePercentage / 100.0);
                    int newHeight = (int)Math.round((double)height * ImageIcon.this._scalePercentage / 100.0);
                    ImageIcon.this._scaledImage = ImageIcon.this._image.getScaledInstance(newWidth, newHeight, 4);
                    ImageIcon.this._scaledImage.getWidth(ImageIcon.this);
                    ImageIcon.this._scaledImage.getHeight(ImageIcon.this);
                    Iterator figures = ImageIcon.this._liveFigureIterator();
                    while (figures.hasNext()) {
                        Object figure = figures.next();
                        ((ImageFigure)figure).setCentered(false);
                        ((ImageFigure)figure).setImage(ImageIcon.this._scaledImage);
                    }
                }
            }
        };
        SwingUtilities.invokeLater(doScale);
    }

    public void setImage(Image image) {
        this._image = image;
        this._scaledImage = image;
        this._image.getWidth(this);
        this._image.getHeight(this);
        Runnable doSet = new Runnable(){

            public void run() {
                Iterator figures = ImageIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    Object figure = figures.next();
                    ((ImageFigure)figure).setImage(ImageIcon.this._scaledImage);
                    if (ImageIcon.this._scalePercentage == 100.0) continue;
                    ImageIcon.this.scaleImage(ImageIcon.this._scalePercentage);
                }
            }
        };
        SwingUtilities.invokeLater(doSet);
    }
}

