/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.CanvasUtilities;
import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.toolbox.BasicFigure;
import diva.canvas.toolbox.BasicRectangle;
import diva.canvas.toolbox.LabelFigure;
import diva.gui.toolbox.FigureIcon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.Icon;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.EditIconTableau;
import ptolemy.vergil.kernel.attributes.FilledShapeAttribute;

public class EditorIcon
extends Attribute {
    protected NamedObj _containerToBe;
    protected Icon _iconCache = null;
    private static Font _labelFont = new Font("SansSerif", 0, 12);
    private static Font _parameterFont = new Font("SansSerif", 0, 9);

    public EditorIcon(Workspace workspace, String name) throws IllegalActionException {
        super(workspace);
        try {
            this.setName(name);
            EditIconTableau.Factory tableauFactory = new EditIconTableau.Factory((NamedObj)this, "_tableauFactory");
            tableauFactory.setPersistent(false);
        }
        catch (NameDuplicationException ex) {
            throw new InternalErrorException((Throwable)ex);
        }
    }

    public EditorIcon(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        EditIconTableau.Factory tableauFactory = new EditIconTableau.Factory((NamedObj)this, "_tableauFactory");
        tableauFactory.setPersistent(false);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        EditorIcon newObject = (EditorIcon)((Object)super.clone(workspace));
        newObject._containerToBe = null;
        newObject._iconCache = null;
        return newObject;
    }

    public Figure createBackgroundFigure() {
        CompositeFigure figure = null;
        for (Attribute attribute : this.attributeList()) {
            for (EditorIcon subIcon : attribute.attributeList(EditorIcon.class)) {
                if (figure == null) {
                    figure = new CompositeFigure();
                }
                Figure subFigure = subIcon.createBackgroundFigure();
                try {
                    Locatable location;
                    boolean centeredValue;
                    if (attribute instanceof FilledShapeAttribute && subFigure instanceof BasicFigure && (centeredValue = ((BooleanToken)((FilledShapeAttribute)attribute).centered.getToken()).booleanValue())) {
                        ((BasicFigure)subFigure).setCentered(true);
                    }
                    if ((location = (Locatable)attribute.getAttribute("_location", Locatable.class)) != null) {
                        double[] locationValue = location.getLocation();
                        CanvasUtilities.translateTo((Figure)subFigure, (double)locationValue[0], (double)locationValue[1]);
                    }
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                figure.add(subFigure);
            }
        }
        if (figure == null) {
            return this._createDefaultBackgroundFigure();
        }
        return figure;
    }

    public Figure createFigure() {
        Token show;
        String name;
        Figure background = this.createBackgroundFigure();
        Rectangle2D backBounds = background.getBounds();
        CompositeFigure figure = new CompositeFigure(background);
        NamedObj container = (NamedObj)this.getContainerOrContainerToBe();
        if (!this._isPropertySet(container, "_hideName") && (name = container.getDisplayName()) != null && !name.equals("")) {
            LabelFigure label;
            if (!this._isPropertySet(container, "_centerName")) {
                label = new LabelFigure(name, _labelFont, 1.0, 6);
                label.translateTo(backBounds.getX() + 5.0, backBounds.getY());
                figure.add((Figure)label);
            } else {
                label = new LabelFigure(name, _labelFont, 1.0, 0);
                label.translateTo(backBounds.getCenterX(), backBounds.getCenterY());
                figure.add((Figure)label);
            }
        }
        if ((show = PtolemyPreferences.preferenceValueLocal(container, "_showParameters")) instanceof StringToken) {
            String value = ((StringToken)show).stringValue();
            boolean showOverriddenParameters = value.equals("Overridden parameters only");
            boolean showAllParameters = value.equals("All");
            if (showOverriddenParameters && !this._isPropertySet(container, "_hideAllParameters") || showAllParameters) {
                StringBuffer parameters = new StringBuffer();
                Iterator settables = container.attributeList(Settable.class).iterator();
                while (settables.hasNext()) {
                    Settable settable = (Settable)settables.next();
                    if (settable.getVisibility() != Settable.FULL || !showAllParameters && !((NamedObj)settable).isOverridden() || !showAllParameters && this._isPropertySet((NamedObj)settable, "_hide")) continue;
                    String name2 = settable.getName();
                    String displayName = settable.getDisplayName();
                    parameters.append(displayName);
                    if (showAllParameters && !name2.equals(displayName)) {
                        parameters.append(" (" + name2 + ")");
                    }
                    parameters.append(": ");
                    parameters.append(settable.getExpression());
                    if (!settables.hasNext()) continue;
                    parameters.append("\n");
                }
                LabelFigure label = new LabelFigure(parameters.toString(), _parameterFont, 1.0, 8);
                label.translateTo(backBounds.getX() + 5.0, backBounds.getY() + backBounds.getHeight());
                figure.add((Figure)label);
            }
        }
        return figure;
    }

    public Icon createIcon() {
        if (this._iconCache != null) {
            return this._iconCache;
        }
        Figure figure = this.createBackgroundFigure();
        this._iconCache = new FigureIcon(figure, 20, 15);
        return this._iconCache;
    }

    public Nameable getContainerOrContainerToBe() {
        NamedObj container = this.getContainer();
        if (container != null) {
            return container;
        }
        return this._containerToBe;
    }

    public void setContainerToBe(NamedObj container) {
        this._containerToBe = container;
    }

    protected Figure _createDefaultBackgroundFigure() {
        return new BasicRectangle(-30.0, -20.0, 60.0, 40.0, (Paint)Color.white, 1.0f);
    }

    protected boolean _isPropertySet(NamedObj object, String name) {
        Attribute attribute = object.getAttribute(name);
        if (attribute == null) {
            return false;
        }
        if (attribute instanceof Parameter) {
            try {
                Token token = ((Parameter)attribute).getToken();
                if (token instanceof BooleanToken && !((BooleanToken)token).booleanValue()) {
                    return false;
                }
            }
            catch (IllegalActionException illegalActionException) {}
        }
        return true;
    }

    protected void _recreateFigure() {
        this._iconCache = null;
    }
}

