/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.GraphicsPane;
import diva.canvas.interactor.SelectionDragger;
import diva.graph.EdgeController;
import diva.graph.GraphController;
import diva.graph.GraphPane;
import diva.graph.NodeController;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import ptolemy.actor.gui.Configuration;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Locatable;
import ptolemy.vergil.basic.BasicGraphController;
import ptolemy.vergil.basic.NamedObjController;
import ptolemy.vergil.kernel.AttributeController;

public class EditIconGraphController
extends BasicGraphController {
    protected NamedObjController _attributeController;
    private SelectionDragger _selectionDragger;
    private static double _SNAP_RESOLUTION = 1.0;

    public EditIconGraphController() {
        this._createControllers();
    }

    public void addToMenuAndToolbar(JMenu menu, JToolBar toolbar) {
        super.addToMenuAndToolbar(menu, toolbar);
    }

    public EdgeController getEdgeController(Object edge) {
        throw new InternalErrorException("An icon edit has no edges.");
    }

    public NodeController getNodeController(Object object) {
        NodeController result = super.getNodeController(object);
        if (result != null) {
            ((NamedObjController)result).setSnapResolution(_SNAP_RESOLUTION);
            return result;
        }
        if (object instanceof Locatable) {
            Object semanticObject = this.getGraphModel().getSemanticObject(object);
            if (semanticObject instanceof Attribute) {
                return this._attributeController;
            }
            throw new RuntimeException("Unrecognized object: " + semanticObject);
        }
        throw new RuntimeException("Node with unknown semantic object: " + object);
    }

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._attributeController.setConfiguration(configuration);
    }

    protected void _createControllers() {
        super._createControllers();
        this._attributeController = new AttributeController((GraphController)this, AttributeController.FULL);
        this._attributeController.setSnapResolution(_SNAP_RESOLUTION);
    }

    protected void initializeInteraction() {
        GraphPane pane = this.getGraphPane();
        this._selectionDragger = new SelectionDragger((GraphicsPane)pane);
        this._selectionDragger.addSelectionModel(this.getSelectionModel());
        super.initializeInteraction();
    }
}

