/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.Figure;
import diva.canvas.FigureLayer;
import diva.canvas.JCanvas;
import diva.canvas.toolbox.BasicRectangle;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.net.URL;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Tableau;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.LibraryAttribute;
import ptolemy.moml.MoMLParser;
import ptolemy.vergil.actor.ActorGraphModel;
import ptolemy.vergil.basic.BasicGraphFrame;
import ptolemy.vergil.icon.EditIconGraphController;
import ptolemy.vergil.icon.EditorIcon;

public class EditIconFrame
extends BasicGraphFrame {
    private EditIconGraphController _controller;
    private double _ZOOM_SCALE = 4.0;

    public EditIconFrame(EditorIcon icon, Tableau tableau) {
        this(icon, tableau, null);
    }

    public EditIconFrame(EditorIcon entity, Tableau tableau, LibraryAttribute defaultLibrary) {
        super((NamedObj)entity, tableau, defaultLibrary);
        this._setDropIntoEnabled(false);
        this.helpFile = "ptolemy/configs/doc/vergilGraphEditorHelp.htm";
        this.zoomReset();
        this._drawReferenceBox();
    }

    public void zoomReset() {
        JCanvas canvas = this.getJGraph().getGraphPane().getCanvas();
        AffineTransform current = canvas.getCanvasPane().getTransformContext().getTransform();
        current.setToScale(this._ZOOM_SCALE, this._ZOOM_SCALE);
        canvas.getCanvasPane().setTransform(current);
        this.setCenter(new Point2D.Double(0.0, 0.0));
        if (this._graphPanner != null) {
            this._graphPanner.repaint();
        }
    }

    protected void _addMenus() {
        super._addMenus();
    }

    protected CompositeEntity _createDefaultLibrary(Workspace workspace) {
        Configuration configuration = this.getConfiguration();
        if (configuration != null) {
            CompositeEntity result = (CompositeEntity)configuration.getEntity("icon editor library");
            if (result == null) {
                URL source = this.getClass().getClassLoader().getResource("ptolemy/vergil/kernel/attributes/iconEditorLibrary.xml");
                MoMLParser parser = new MoMLParser(workspace);
                try {
                    result = (CompositeEntity)parser.parse(null, source);
                }
                catch (Exception e) {
                    throw new InternalErrorException("Unable to open default icon editor library: " + e);
                }
            }
            return result;
        }
        return null;
    }

    protected GraphPane _createGraphPane(NamedObj entity) {
        this._controller = new EditIconGraphController();
        this._controller.setConfiguration(this.getConfiguration());
        this._controller.setFrame(this);
        ActorGraphModel graphModel = new ActorGraphModel(entity);
        return new GraphPane((GraphController)this._controller, (GraphModel)graphModel);
    }

    protected void _drawReferenceBox() {
        FigureLayer layer = (FigureLayer)this.getJGraph().getGraphPane().getBackgroundLayer();
        layer.setVisible(true);
        BasicRectangle reference = new BasicRectangle(-30.0, -20.0, 60.0, 40.0, 0.1f);
        reference.setStrokePaint((Paint)Color.BLUE);
        layer.add((Figure)reference);
    }
}

