/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm;

import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.Site;
import diva.canvas.connector.ArcConnector;
import diva.canvas.connector.ArcManipulator;
import diva.canvas.connector.Arrowhead;
import diva.canvas.connector.Blob;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorAdapter;
import diva.canvas.connector.ConnectorEnd;
import diva.canvas.connector.ConnectorEvent;
import diva.canvas.connector.ConnectorListener;
import diva.canvas.connector.ConnectorTarget;
import diva.canvas.connector.PerimeterTarget;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.ActionInteractor;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.toolbox.LabelFigure;
import diva.graph.BasicEdgeController;
import diva.graph.EdgeRenderer;
import diva.graph.GraphController;
import diva.gui.toolbox.MenuCreator;
import diva.gui.toolbox.MenuFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;
import ptolemy.actor.TypedActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.basic.PopupMouseFilter;
import ptolemy.vergil.fsm.Arc;
import ptolemy.vergil.fsm.FSMGraphModel;
import ptolemy.vergil.toolbox.ConfigureAction;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;
import ptolemy.vergil.toolbox.PtolemyMenuFactory;

public class TransitionController
extends BasicEdgeController {
    protected Configuration _configuration;
    protected static ConfigureAction _configureAction = new ConfigureAction("Configure");
    protected LookInsideAction _lookInsideAction = new LookInsideAction();
    protected MenuCreator _menuCreator;
    protected PtolemyMenuFactory _menuFactory;
    private static Font _labelFont = new Font("SansSerif", 0, 10);

    public TransitionController(GraphController controller) {
        super(controller);
        SelectionModel sm = controller.getSelectionModel();
        SelectionInteractor interactor = (SelectionInteractor)this.getEdgeInteractor();
        interactor.setSelectionModel(sm);
        ArcManipulator manipulator = new ArcManipulator();
        manipulator.setSnapHalo(4.0);
        manipulator.addConnectorListener((ConnectorListener)new LinkDropper());
        interactor.setPrototypeDecorator((FigureDecorator)manipulator);
        MouseFilter handleFilter = new MouseFilter(1, 0, 0);
        manipulator.setHandleFilter(handleFilter);
        LinkTarget ct = new LinkTarget();
        this.setConnectorTarget((ConnectorTarget)ct);
        this.setEdgeRenderer(new LinkRenderer());
        this._menuCreator = new MenuCreator(null);
        this._menuCreator.setMouseFilter((MouseFilter)new PopupMouseFilter());
        interactor.addInteractor((Interactor)this._menuCreator);
        this._menuFactory = new PtolemyMenuFactory(controller);
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(_configureAction));
        this._menuCreator.setMenuFactory((MenuFactory)this._menuFactory);
        ActionInteractor doubleClickInteractor = new ActionInteractor((Action)_configureAction);
        doubleClickInteractor.setConsuming(false);
        doubleClickInteractor.setMouseFilter(new MouseFilter(1, 0, 0, 2));
        interactor.addInteractor((Interactor)doubleClickInteractor);
        if (this._configuration != null) {
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._lookInsideAction));
        }
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
        if (this._configuration != null) {
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._lookInsideAction));
        }
    }

    protected class LinkDropper
    extends ConnectorAdapter {
        protected LinkDropper() {
        }

        public void connectorDropped(ConnectorEvent evt) {
            Connector c = evt.getConnector();
            Figure f = evt.getTarget();
            Object edge = c.getUserObject();
            Object node = f == null ? null : f.getUserObject();
            FSMGraphModel model = (FSMGraphModel)TransitionController.this.getController().getGraphModel();
            switch (evt.getEnd()) {
                case 21: {
                    model.getArcModel().setHead(edge, node);
                    break;
                }
                case 22: {
                    model.getArcModel().setTail(edge, node);
                    break;
                }
                case 24: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot handle both ends of an edge being dragged.");
                }
            }
            Arc arc = (Arc)edge;
            Transition transition = (Transition)arc.getRelation();
            if (transition != null && c instanceof ArcConnector) {
                double angle = ((ArcConnector)c).getAngle();
                double gamma = ((ArcConnector)c).getGamma();
                String moml = "<group><property name=\"exitAngle\" value=\"" + angle + "\"/>" + "<property name=\"gamma\" value=\"" + gamma + "\"/></group>";
                MoMLChangeRequest request = new MoMLChangeRequest((Object)this, (NamedObj)transition, moml);
                transition.requestChange((ChangeRequest)request);
            }
            TransitionController.this.getController().rerenderEdge(edge);
        }
    }

    public class LinkRenderer
    implements EdgeRenderer {
        public Connector render(Object edge, Site tailSite, Site headSite) {
            ArcConnector c = new ArcConnector(tailSite, headSite);
            Arrowhead arrowhead = new Arrowhead();
            c.setHeadEnd((ConnectorEnd)arrowhead);
            c.setLineWidth(2.0f);
            c.setUserObject(edge);
            Arc arc = (Arc)edge;
            Transition transition = (Transition)arc.getRelation();
            if (transition != null) {
                try {
                    if (((BooleanToken)transition.reset.getToken()).booleanValue()) {
                        arrowhead.setFilled(false);
                    }
                }
                catch (IllegalActionException illegalActionException) {}
                if (transition.isPreemptive()) {
                    Blob blob = new Blob(0.0, 0.0, 0.0, 47, 4.0, (Paint)Color.red);
                    blob.setFilled(true);
                    c.setTailEnd((ConnectorEnd)blob);
                }
                if (transition.isNondeterministic()) {
                    c.setStrokePaint((Paint)Color.RED);
                }
                c.setToolTipText(transition.getName());
                String labelStr = transition.getLabel();
                try {
                    double exitAngle = ((DoubleToken)transition.exitAngle.getToken()).doubleValue();
                    double maximum = 311.01767270538954;
                    if (exitAngle > maximum) {
                        exitAngle = maximum;
                    } else if (exitAngle < -maximum) {
                        exitAngle = -maximum;
                    }
                    double minimum = 0.0031447373909807737;
                    if (exitAngle < minimum && exitAngle > -minimum) {
                        exitAngle = exitAngle > 0.0 ? minimum : -minimum;
                    }
                    c.setAngle(exitAngle);
                    double gamma = ((DoubleToken)transition.gamma.getToken()).doubleValue();
                    c.setGamma(gamma);
                }
                catch (IllegalActionException illegalActionException) {}
                if (!labelStr.equals("")) {
                    LabelFigure label = new LabelFigure(labelStr, _labelFont);
                    label.setFillPaint((Paint)Color.black);
                    c.setLabelFigure(label);
                }
            }
            return c;
        }
    }

    public class LinkTarget
    extends PerimeterTarget {
        public boolean acceptHead(Connector c, Figure f) {
            Object object = f.getUserObject();
            if (object instanceof Locatable) {
                Locatable location = (Locatable)object;
                return location.getContainer() instanceof Entity;
            }
            return false;
        }

        public boolean acceptTail(Connector c, Figure f) {
            return this.acceptHead(c, f);
        }
    }

    private class LookInsideAction
    extends FigureAction {
        public LookInsideAction() {
            super("Look Inside");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e) {
            if (TransitionController.this._configuration == null) {
                MessageHandler.error((String)"Cannot look inside without a configuration.");
                return;
            }
            super.actionPerformed(e);
            NamedObj target = this.getTarget();
            try {
                TypedActor[] refinements = null;
                if (target instanceof Transition) {
                    refinements = ((Transition)target).getRefinement();
                } else if (target instanceof State) {
                    refinements = ((State)target).getRefinement();
                }
                if (refinements != null && refinements.length > 0) {
                    int i = 0;
                    while (i < refinements.length) {
                        TransitionController.this._configuration.openModel((NamedObj)refinements[i]);
                        ++i;
                    }
                } else {
                    MessageHandler.error((String)"No refinement.");
                }
            }
            catch (Exception ex) {
                MessageHandler.error((String)"Look inside failed: ", (Throwable)ex);
            }
        }
    }
}

