/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm;

import diva.canvas.Figure;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.NodeRenderer;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import ptolemy.actor.TypedActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.icon.XMLIcon;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;

public class StateController
extends AttributeController {
    protected LookInsideAction _lookInsideAction = new LookInsideAction();
    private static Map _iconsPendingContainer = new HashMap();

    public StateController(GraphController controller) {
        this(controller, FULL);
    }

    public StateController(GraphController controller, AttributeController.Access access) {
        super(controller, access);
        this.setNodeRenderer(new StateRenderer(controller.getGraphModel()));
        if (this._configuration != null) {
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._lookInsideAction));
        }
    }

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        if (this._configuration != null) {
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._lookInsideAction));
        }
    }

    private class LookInsideAction
    extends FigureAction {
        public LookInsideAction() {
            super("Look Inside");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e) {
            if (StateController.this._configuration == null) {
                MessageHandler.error((String)"Cannot look inside without a configuration.");
                return;
            }
            super.actionPerformed(e);
            NamedObj target = this.getTarget();
            if (target instanceof State) {
                try {
                    TypedActor[] refinements = ((State)target).getRefinement();
                    if (refinements != null && refinements.length > 0) {
                        int i = 0;
                        while (i < refinements.length) {
                            StateController.this._configuration.openModel((NamedObj)refinements[i]);
                            ++i;
                        }
                    } else {
                        MessageHandler.error((String)"State has no refinement.");
                    }
                }
                catch (Exception ex) {
                    MessageHandler.error((String)"Look inside failed: ", (Throwable)ex);
                }
            }
        }
    }

    public static class StateRenderer
    implements NodeRenderer {
        private GraphModel _model;

        public StateRenderer(GraphModel model) {
            this._model = model;
        }

        public Figure render(Object n) {
            EditorIcon icon;
            Locatable location = (Locatable)n;
            final NamedObj object = location.getContainer();
            try {
                XMLIcon alreadyCreated;
                List icons = object.attributeList(EditorIcon.class);
                if (icons.size() == 0 && (alreadyCreated = (XMLIcon)((Object)_iconsPendingContainer.get(object))) != null) {
                    icons.add(alreadyCreated);
                }
                if (icons.size() > 0) {
                    icon = (EditorIcon)((Object)icons.get(icons.size() - 1));
                } else {
                    icon = new XMLIcon(object.workspace(), "_icon");
                    icon.setContainerToBe(object);
                    icon.setPersistent(false);
                    _iconsPendingContainer.put(object, icon);
                    final EditorIcon finalIcon = icon;
                    ChangeRequest request = new ChangeRequest(this._model, "Set the container of a new XMLIcon."){

                        protected void _execute() throws KernelException {
                            _iconsPendingContainer.remove(object);
                            if (finalIcon.getContainer() != null) {
                                return;
                            }
                            if (object.getAttribute("_icon") != null) {
                                return;
                            }
                            finalIcon.setContainer(object);
                        }
                    };
                    request.setPersistent(false);
                    object.requestChange(request);
                }
            }
            catch (KernelException kernelException) {
                throw new InternalErrorException("could not create icon in " + object + " even " + "though one did not exist");
            }
            Figure figure = icon.createFigure();
            figure.setToolTipText(object.getName());
            return figure;
        }
    }
}

