/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm;

import java.awt.Color;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.actor.lib.hoc.Case;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.LibraryAttribute;
import ptolemy.vergil.fsm.CaseGraphFrame;

public class CaseGraphTableau
extends Tableau {
    private static Color BACKGROUND_COLOR = new Color(0xE5E5E5);

    public CaseGraphTableau(PtolemyEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        this(container, name, null);
    }

    public CaseGraphTableau(PtolemyEffigy container, String name, LibraryAttribute defaultLibrary) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        NamedObj model = container.getModel();
        if (!(model instanceof Case)) {
            throw new IllegalActionException((Nameable)this, "Cannot edit a model that is not an Case.");
        }
        this.createGraphFrame((CompositeEntity)((Case)model), defaultLibrary);
    }

    public void createGraphFrame(CompositeEntity model) {
        this.createGraphFrame(model, null);
    }

    public void createGraphFrame(CompositeEntity model, LibraryAttribute defaultLibrary) {
        if (!(model instanceof Case)) {
            throw new InternalErrorException((Nameable)this, null, "Composite Entity \"" + model.getFullName() + "\" is not an instance of Case.");
        }
        CaseGraphFrame frame = new CaseGraphFrame((Case)model, (Tableau)this, defaultLibrary);
        try {
            this.setFrame(frame);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException((Throwable)ex);
        }
        frame.setBackground(BACKGROUND_COLOR);
        frame.pack();
        frame.centerOnScreen();
        frame.setVisible(true);
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (!(effigy instanceof PtolemyEffigy)) {
                return null;
            }
            NamedObj model = ((PtolemyEffigy)effigy).getModel();
            if (model instanceof Case) {
                LibraryAttribute library = (LibraryAttribute)this.getAttribute("_library", LibraryAttribute.class);
                CaseGraphTableau tableau = new CaseGraphTableau((PtolemyEffigy)effigy, effigy.uniqueName("tableau"), library);
                return tableau;
            }
            return null;
        }
    }
}

