/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.debugger;

import javax.swing.BoxLayout;
import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.Executable;
import ptolemy.actor.FiringEvent;
import ptolemy.gui.Query;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.basic.BasicGraphController;
import ptolemy.vergil.debugger.DebugController;
import ptolemy.vergil.debugger.DebugProfile;

public class BreakpointConfigurer
extends Query
implements ChangeListener {
    protected static String[] _firingEventTypeLabels = new String[]{"before iterate", "after iterate"};
    protected static FiringEvent.FiringEventType[] _firingEventTypes = new FiringEvent.FiringEventType[]{FiringEvent.BEFORE_ITERATE, FiringEvent.AFTER_ITERATE};
    private static String _DEBUGCONTROLLER = "_DebugController";
    private Actor _actor;
    private DebugProfile _actorProfile;
    private BasicGraphController _graphController;
    private static Class _sdfDirectorClass = null;

    public BreakpointConfigurer(Entity object, BasicGraphController graphController) {
        this.setLayout(new BoxLayout(this, 1));
        this.setTextWidth(15);
        if (!(object instanceof Actor)) {
            throw new InternalErrorException("Object selected is not an actor.");
        }
        this._actor = (Actor)object;
        this._graphController = graphController;
        Director director = this._actor.getExecutiveDirector();
        if (director == null) {
            throw new InternalErrorException("No director associated with this actor.");
        }
        if (_sdfDirectorClass == null) {
            try {
                _sdfDirectorClass = Class.forName("ptolemy.domains.sdf.kernel.SDFDirector");
            }
            catch (Throwable throwable) {
                throw new InternalErrorException((Nameable)object, throwable, "The breakpoint facility only works with that are instances of SDFDirector.  The SDFDirector was not found.");
            }
        }
        if (!_sdfDirectorClass.isInstance(director)) {
            throw new InternalErrorException((Nameable)director, null, "The breakpoint facility only works with directors that are instances of SDFDirector.  The director of this model is a '" + director + "'.");
        }
        DebugController debugController = (DebugController)director.getAttribute(_DEBUGCONTROLLER);
        this._actorProfile = null;
        if (debugController != null) {
            this._actorProfile = debugController.getDebugProfile((Executable)this._actor);
        }
        if (this._actorProfile == null) {
            this._actorProfile = new DebugProfile(this._graphController);
        }
        int i = 0;
        while (i < _firingEventTypes.length) {
            if (this._actorProfile.isListening(_firingEventTypes[i])) {
                this.addCheckBox(_firingEventTypeLabels[i], _firingEventTypeLabels[i], true);
            } else {
                this.addCheckBox(_firingEventTypeLabels[i], _firingEventTypeLabels[i], false);
            }
            ++i;
        }
    }

    public void apply() {
        boolean breakpointsSelected = false;
        this._actorProfile = new DebugProfile(this._graphController);
        int i = 0;
        while (i < _firingEventTypes.length) {
            if (this.getBooleanValue(_firingEventTypeLabels[i])) {
                this._actorProfile.listenForEvent(_firingEventTypes[i]);
                breakpointsSelected = true;
            } else {
                this._actorProfile.unlistenForEvent(_firingEventTypes[i]);
            }
            ++i;
        }
        Director director = this._actor.getExecutiveDirector();
        DebugController debugController = (DebugController)director.getAttribute(_DEBUGCONTROLLER);
        if (breakpointsSelected) {
            if (debugController != null) {
                debugController.putDebugProfile((Executable)this._actor, this._actorProfile);
            } else {
                String moml = "<property name=\"" + _DEBUGCONTROLLER + "\" class=\"ptolemy.vergil.debugger.DebugController\"/>";
                MoMLChangeRequest request = new MoMLChangeRequest((Object)this, (NamedObj)director, moml);
                request.addChangeListener((ChangeListener)this);
                director.requestChange((ChangeRequest)request);
            }
        } else if (debugController != null) {
            debugController.removeDebugProfile((Executable)this._actor);
        }
    }

    public void changeExecuted(ChangeRequest change) {
        Director director = this._actor.getExecutiveDirector();
        DebugController debugController = (DebugController)director.getAttribute(_DEBUGCONTROLLER);
        director.addDebugListener((DebugListener)debugController);
        debugController.putDebugProfile((Executable)this._actor, this._actorProfile);
        director.removeChangeListener((ChangeListener)this);
    }

    public void changeFailed(ChangeRequest change, Exception exception) {
        throw new InternalErrorException("Could not add DebugController to the director");
    }
}

