/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import diva.gui.GUIUtilities;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;
import ptolemy.actor.TypeConflictException;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.graph.Inequality;
import ptolemy.graph.InequalityTerm;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.KernelRuntimeException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.WithIconGraphController;
import ptolemy.vergil.toolbox.FigureAction;

public abstract class RunnableGraphController
extends WithIconGraphController
implements ExecutionListener {
    private List<Attribute> _errorHighlights = new LinkedList<Attribute>();
    private Manager _manager = null;
    private Action _pauseModelAction = new PauseModelAction("Pause the model");
    private Manager.State _previousState;
    private Action _runModelAction = new RunModelAction("Run or Resume the model");
    private Action _stopModelAction = new StopModelAction("Stop the model");

    public void addToMenuAndToolbar(JMenu menu, JToolBar toolbar) {
        super.addToMenuAndToolbar(menu, toolbar);
        GUIUtilities.addHotKey((JComponent)this.getFrame().getJGraph(), (Action)this._runModelAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._runModelAction);
        GUIUtilities.addHotKey((JComponent)this.getFrame().getJGraph(), (Action)this._pauseModelAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._pauseModelAction);
        GUIUtilities.addHotKey((JComponent)this.getFrame().getJGraph(), (Action)this._stopModelAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._stopModelAction);
        ((ButtonFigureAction)this._stopModelAction).setSelected(true);
    }

    public void executionError(Manager manager, Throwable throwable) {
        block5: {
            block4: {
                this.getFrame().report(throwable);
                if (!(throwable instanceof KernelException)) break block4;
                this._highlightError(((KernelException)throwable).getNameable1());
                this._highlightError(((KernelException)throwable).getNameable2());
                if (!(throwable instanceof TypeConflictException)) break block5;
                for (Inequality inequality : ((TypeConflictException)throwable).inequalityList()) {
                    Object object;
                    if (inequality == null) continue;
                    InequalityTerm term = inequality.getGreaterTerm();
                    if (term != null && (object = term.getAssociatedObject()) instanceof Nameable) {
                        this._highlightError((Nameable)object);
                    }
                    if ((term = inequality.getLesserTerm()) == null || !((object = term.getAssociatedObject()) instanceof Nameable)) continue;
                    this._highlightError((Nameable)object);
                }
                break block5;
            }
            if (throwable instanceof KernelRuntimeException) {
                Iterator causes = ((KernelRuntimeException)throwable).getNameables().iterator();
                while (causes.hasNext()) {
                    this._highlightError((Nameable)causes.next());
                }
            }
        }
    }

    public synchronized void executionFinished(Manager manager) {
        this.getFrame().report("execution finished.");
    }

    public void managerStateChanged(Manager manager) {
        Manager.State newState = manager.getState();
        if (newState != this._previousState) {
            ChangeRequest request = new ChangeRequest((Object)this, "Error Highlight Clearer"){

                protected void _execute() throws Exception {
                    for (Attribute highlight : RunnableGraphController.this._errorHighlights) {
                        highlight.setContainer(null);
                    }
                }
            };
            request.setPersistent(false);
            manager.requestChange(request);
            this.getFrame().report(manager.getState().getDescription());
            this._previousState = newState;
            if (newState == Manager.INITIALIZING || newState == Manager.ITERATING || newState == Manager.PREINITIALIZING || newState == Manager.RESOLVING_TYPES || newState == Manager.WRAPPING_UP || newState == Manager.EXITING) {
                ((ButtonFigureAction)this._runModelAction).setSelected(true);
                ((ButtonFigureAction)this._pauseModelAction).setSelected(false);
                ((ButtonFigureAction)this._stopModelAction).setSelected(false);
            } else if (newState == Manager.PAUSED) {
                ((ButtonFigureAction)this._runModelAction).setSelected(false);
                ((ButtonFigureAction)this._pauseModelAction).setSelected(true);
                ((ButtonFigureAction)this._stopModelAction).setSelected(false);
            } else {
                ((ButtonFigureAction)this._runModelAction).setSelected(false);
                ((ButtonFigureAction)this._pauseModelAction).setSelected(false);
                ((ButtonFigureAction)this._stopModelAction).setSelected(true);
            }
        }
    }

    protected Manager _getManager() throws IllegalActionException {
        AbstractBasicGraphModel graphModel = (AbstractBasicGraphModel)this.getGraphModel();
        NamedObj toplevel = graphModel.getPtolemyModel().toplevel();
        if (!(toplevel instanceof CompositeActor)) {
            throw new IllegalActionException((Nameable)toplevel, "Cannot get a manager because the model is not a CompositeActor.");
        }
        Manager manager = ((CompositeActor)toplevel).getManager();
        if (manager == null) {
            try {
                manager = new Manager(toplevel.workspace(), "manager");
                ((CompositeActor)toplevel).setManager(manager);
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException((Throwable)ex);
            }
        }
        if (manager != this._manager) {
            if (this._manager != null) {
                this._manager.removeExecutionListener((ExecutionListener)this);
            }
            manager.addExecutionListener((ExecutionListener)this);
            this._manager = manager;
        }
        return manager;
    }

    private void _addErrorHighlightIfNeeded(Nameable culprit) throws IllegalActionException, NameDuplicationException {
        Object highlightColor = ((NamedObj)culprit).getAttribute("_highlightColor");
        if (highlightColor == null) {
            highlightColor = new ColorAttribute((NamedObj)culprit, "_highlightColor");
            ((ColorAttribute)((Object)highlightColor)).setExpression("{1.0, 0.0, 0.0, 1.0}");
            highlightColor.setPersistent(false);
            ((ColorAttribute)((Object)highlightColor)).setVisibility(Settable.EXPERT);
            this._errorHighlights.add((Attribute)highlightColor);
        }
    }

    private void _highlightError(final Nameable culprit) {
        if (culprit instanceof NamedObj) {
            ChangeRequest request = new ChangeRequest((Object)this, "Error Highlighter"){

                protected void _execute() throws Exception {
                    RunnableGraphController.this._addErrorHighlightIfNeeded(culprit);
                    NamedObj container = culprit.getContainer();
                    while (container != null) {
                        RunnableGraphController.this._addErrorHighlightIfNeeded((Nameable)container);
                        container = container.getContainer();
                    }
                }
            };
            ((NamedObj)culprit).requestChange(request);
        }
    }

    private class ButtonFigureAction
    extends FigureAction {
        public ButtonFigureAction(String description) {
            super(description);
        }

        public void setSelected(boolean state) {
            JButton button = (JButton)this.getValue("toolBarButton");
            button.setSelected(state);
        }
    }

    private class PauseModelAction
    extends ButtonFigureAction {
        public PauseModelAction(String description) {
            super(description);
            GUIUtilities.addIcons((Action)this, (String[][])new String[][]{{"/ptolemy/vergil/basic/img/pause.gif", "LargeIcon"}, {"/ptolemy/vergil/basic/img/pause_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/basic/img/pause_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/basic/img/pause_on.gif", "selectedIcon"}});
            this.putValue("tooltip", String.valueOf(description) + " (Ctrl+U)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            try {
                RunnableGraphController.this._getManager().pause();
            }
            catch (IllegalActionException ex) {
                MessageHandler.error((String)"failed to pause.", (Throwable)ex);
            }
        }
    }

    private class RunModelAction
    extends ButtonFigureAction {
        public RunModelAction(String description) {
            super(description);
            GUIUtilities.addIcons((Action)this, (String[][])new String[][]{{"/ptolemy/vergil/basic/img/run.gif", "LargeIcon"}, {"/ptolemy/vergil/basic/img/run_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/basic/img/run_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/basic/img/run_on.gif", "selectedIcon"}});
            this.putValue("tooltip", String.valueOf(description) + " (Ctrl+R)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            try {
                GraphicalMessageHandler.setContext(this.getFrame());
                RunnableGraphController.this._getManager().startRun();
            }
            catch (IllegalActionException ex) {
                try {
                    RunnableGraphController.this._getManager().resume();
                }
                catch (IllegalActionException illegalActionException) {
                    MessageHandler.error((String)"Failed to run/resume.", (Throwable)ex);
                }
            }
        }
    }

    private class StopModelAction
    extends ButtonFigureAction {
        public StopModelAction(String description) {
            super(description);
            GUIUtilities.addIcons((Action)this, (String[][])new String[][]{{"/ptolemy/vergil/basic/img/stop.gif", "LargeIcon"}, {"/ptolemy/vergil/basic/img/stop_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/basic/img/stop_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/basic/img/stop_on.gif", "selectedIcon"}});
            this.putValue("tooltip", String.valueOf(description) + " (Ctrl+H)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            try {
                RunnableGraphController.this._getManager().stop();
            }
            catch (IllegalActionException ex) {
                MessageHandler.error((String)"failed to stop.", (Throwable)ex);
            }
        }
    }
}

