/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import diva.canvas.CanvasUtilities;
import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.connector.TerminalFigure;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.toolbox.BasicFigure;
import diva.graph.BasicNodeController;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.NodeInteractor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.basic.LocatableNodeDragInteractor;

public class LocatableNodeController
extends BasicNodeController {
    public static Color CLASS_ELEMENT_HIGHLIGHT_COLOR = new Color(255, 128, 128);
    protected boolean _decoratable = true;
    private LocatableNodeDragInteractor _dragInteractor;

    public LocatableNodeController(GraphController controller) {
        super(controller);
        NodeInteractor nodeInteractor = (NodeInteractor)this.getNodeInteractor();
        this._dragInteractor = new LocatableNodeDragInteractor(this);
        nodeInteractor.setDragInteractor((DragInteractor)this._dragInteractor);
    }

    public void addNode(Object node, double x, double y) {
        throw new UnsupportedOperationException("Cannot add node.");
    }

    public Figure drawNode(Object node) {
        Figure nf = super.drawNode(node);
        this.locateFigure(node);
        return nf;
    }

    public double[] getLocation(Object node) {
        if (this.hasLocation(node)) {
            return ((Locatable)node).getLocation();
        }
        throw new RuntimeException("The node " + node + "does not have a desired location");
    }

    public boolean hasLocation(Object node) {
        Locatable object;
        double[] location;
        return node instanceof Locatable && (location = (object = (Locatable)node).getLocation()) != null && location.length == 2;
    }

    public void locateFigure(Object node) {
        Figure nf = this.getController().getFigure(node);
        try {
            if (this.hasLocation(node)) {
                double[] location = this.getLocation(node);
                CanvasUtilities.translateTo((Figure)nf, (double)location[0], (double)location[1]);
            }
        }
        catch (Exception exception) {}
    }

    public void setLocation(Object node, double[] location) throws IllegalActionException {
        if (location == null) {
            throw new RuntimeException("The location is not valid, it should not be null.");
        }
        if (location.length != 2) {
            throw new RuntimeException("The location is not valid, the length should be 2, but it is " + location.length);
        }
        if (!(node instanceof Locatable)) {
            throw new RuntimeException("The node " + node + "cannot have a desired location");
        }
        ((Locatable)node).setLocation(location);
    }

    public void setSnapResolution(double resolution) {
        this._dragInteractor.setSnapResolution(resolution);
    }

    protected void _drawChildren(Object node) {
        if (!this._hide(node)) {
            super._drawChildren(node);
        }
    }

    protected static CompositeFigure _getCompositeFigure(Figure nf) {
        Figure f;
        Object cf = nf instanceof CompositeFigure ? (CompositeFigure)nf : (nf instanceof TerminalFigure ? ((f = ((TerminalFigure)nf).getFigure()) instanceof CompositeFigure ? (CompositeFigure)f : null) : null);
        return cf;
    }

    protected boolean _hide(Object node) {
        if (node instanceof Locatable && this._isPropertySet(((Locatable)node).getContainer(), "_hide")) {
            return true;
        }
        return node instanceof NamedObj && this._isPropertySet((NamedObj)node, "_hide");
    }

    protected boolean _isPropertySet(NamedObj object, String name) {
        Attribute attribute = object.getAttribute(name);
        if (attribute == null) {
            return false;
        }
        if (attribute instanceof Parameter) {
            try {
                Token token = ((Parameter)attribute).getToken();
                if (token instanceof BooleanToken && !((BooleanToken)token).booleanValue()) {
                    return false;
                }
            }
            catch (IllegalActionException illegalActionException) {}
        }
        return true;
    }

    protected Figure _renderNode(Object node) {
        if (node == null || this._hide(node)) {
            CompositeFigure newFigure = new CompositeFigure();
            newFigure.setVisible(false);
            newFigure.setInteractor(this.getNodeInteractor());
            newFigure.setUserObject(node);
            this.getController().setFigure(node, (Figure)newFigure);
            return newFigure;
        }
        Figure nf = super._renderNode(node);
        GraphModel model = this.getController().getGraphModel();
        Object object = model.getSemanticObject(node);
        CompositeFigure cf = LocatableNodeController._getCompositeFigure(nf);
        if (this._decoratable && object instanceof NamedObj && ((NamedObj)object).getDerivedLevel() < Integer.MAX_VALUE && cf != null) {
            BasicStroke stroke = new BasicStroke(2.0f, 2, 0, 10.0f);
            Rectangle2D bounds = cf.getBackgroundFigure().getBounds();
            double padding = 3.0;
            bounds = new Rectangle2D.Double(bounds.getX() - padding, bounds.getY() - padding, bounds.getWidth() + padding * 2.0, bounds.getHeight() + padding * 2.0);
            BasicFigure bf = new BasicFigure((Shape)bounds);
            bf.setStroke((Stroke)stroke);
            bf.setStrokePaint((Paint)CLASS_ELEMENT_HIGHLIGHT_COLOR);
            int index = cf.getFigureCount();
            if (index < 0) {
                index = 0;
            }
            cf.add(index, (Figure)bf);
        }
        return nf;
    }
}

