/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import diva.canvas.Figure;
import diva.canvas.toolbox.SVGUtilities;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.NodeRenderer;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.vergil.basic.ParameterizedNodeController;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.icon.XMLIcon;
import ptolemy.vergil.kernel.AnimationRenderer;

public class IconController
extends ParameterizedNodeController {
    private static Map _iconsPendingContainer = new HashMap();

    public IconController(GraphController controller) {
        super(controller);
        this.setNodeRenderer(new IconRenderer());
    }

    public class IconRenderer
    implements NodeRenderer {
        public Figure render(Object n) {
            AnimationRenderer animationRenderer;
            Object color;
            Locatable location = (Locatable)n;
            final NamedObj object = location.getContainer();
            Figure result = null;
            try {
                EditorIcon icon;
                XMLIcon alreadyCreated;
                List iconList = object.attributeList(EditorIcon.class);
                if (iconList.size() == 0 && (alreadyCreated = (XMLIcon)((Object)_iconsPendingContainer.get(object))) != null) {
                    iconList.add(alreadyCreated);
                }
                if (iconList.size() == 0) {
                    icon = new XMLIcon(object.workspace(), "_icon");
                    icon.setContainerToBe(object);
                    icon.setPersistent(false);
                    result = icon.createFigure();
                    _iconsPendingContainer.put(object, icon);
                    GraphController controller = IconController.this.getController();
                    GraphModel graphModel = controller.getGraphModel();
                    ChangeRequest request = new ChangeRequest(graphModel, "Set the container of a new XMLIcon."){

                        protected void _execute() throws KernelException {
                            _iconsPendingContainer.remove(object);
                            if (icon.getContainer() != null) {
                                return;
                            }
                            if (object.getAttribute("_icon") != null) {
                                return;
                            }
                            icon.setContainer(object);
                        }
                    };
                    request.setPersistent(false);
                    object.requestChange(request);
                } else if (iconList.size() >= 1) {
                    icon = (EditorIcon)((Object)iconList.get(iconList.size() - 1));
                    result = icon.createFigure();
                }
            }
            catch (KernelException ex) {
                throw new InternalErrorException(null, (Throwable)ex, "Could not create icon in " + object + " even " + "though one did not previously exist.");
            }
            result.setToolTipText(object.getClassName());
            try {
                StringAttribute colorAttr = (StringAttribute)object.getAttribute("_color", StringAttribute.class);
                if (colorAttr != null) {
                    color = colorAttr.getExpression();
                    animationRenderer = new AnimationRenderer(SVGUtilities.getColor((String)color));
                    animationRenderer.renderSelected(result);
                }
            }
            catch (IllegalActionException illegalActionException) {}
            try {
                ColorAttribute highlightAttribute = (ColorAttribute)object.getAttribute("_highlightColor", ColorAttribute.class);
                if (highlightAttribute != null && !highlightAttribute.getExpression().trim().equals("")) {
                    color = highlightAttribute.asColor();
                    animationRenderer = new AnimationRenderer((Color)color);
                    animationRenderer.renderSelected(result);
                }
            }
            catch (IllegalActionException illegalActionException) {}
            try {
                StringAttribute explanationAttribute = (StringAttribute)object.getAttribute("_explanation", StringAttribute.class);
                if (explanationAttribute != null) {
                    result.setToolTipText(explanationAttribute.getExpression());
                }
            }
            catch (IllegalActionException illegalActionException) {}
            return result;
        }
    }
}

