/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.List;
import javax.swing.JOptionPane;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.attributes.VersionAttribute;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.KernelRuntimeException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.DocApplicationSpecializer;
import ptolemy.vergil.actor.DocBuilderEffigy;
import ptolemy.vergil.actor.DocBuilderTableau;
import ptolemy.vergil.actor.DocEffigy;
import ptolemy.vergil.actor.DocManager;
import ptolemy.vergil.actor.DocTableau;
import ptolemy.vergil.basic.DocAttribute;
import ptolemy.vergil.basic.KeplerDocumentationAttribute;
import ptolemy.vergil.toolbox.FigureAction;

public class GetDocumentationAction
extends FigureAction {
    protected Configuration _configuration;
    private static String _lastClassName = null;
    private int docPreference = 0;
    private Effigy _effigy = null;

    public GetDocumentationAction(int docPreference) {
        super("Get Documentation");
        this.docPreference = docPreference;
    }

    public GetDocumentationAction() {
        super("Get Documentation");
    }

    public void actionPerformed(ActionEvent e) {
        NamedObj target;
        super.actionPerformed(e);
        if (this._configuration == null) {
            MessageHandler.error((String)"Cannot get documentation without a configuration.");
        }
        if ((target = this.getTarget()) == null) {
            return;
        }
        this.showDocumentation(target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showDocumentation(NamedObj target) {
        if (this._configuration == null) {
            MessageHandler.error((String)"Cannot get documentation without a configuration.");
        }
        List docAttributes = target.attributeList(DocAttribute.class);
        KeplerDocumentationAttribute keplerDocumentationAttribute = (KeplerDocumentationAttribute)target.getAttribute("KeplerDocumentation");
        int docAttributeSize = docAttributes.size();
        if (docAttributes.size() != 0 && keplerDocumentationAttribute != null) {
            if (this.docPreference == 0) {
                keplerDocumentationAttribute = null;
            } else if (this.docPreference == 1) {
                docAttributeSize = 0;
            }
        }
        if (keplerDocumentationAttribute != null) {
            DocAttribute docAttribute = keplerDocumentationAttribute.getDocAttribute(target);
            if (docAttribute == null) throw new InternalErrorException("Error building Kepler documentation");
            this.showDocAttributeTableau(docAttribute, target);
            return;
        } else if (docAttributeSize != 0) {
            DocAttribute docAttribute = (DocAttribute)((Object)docAttributes.get(docAttributes.size() - 1));
            this.showDocAttributeTableau(docAttribute, target);
            return;
        } else {
            String className = target.getClass().getName();
            Effigy context = Configuration.findEffigy(target);
            NamedObj container = target.getContainer();
            while (context == null && container != null) {
                context = Configuration.findEffigy(container);
                container = container.getContainer();
            }
            if (context == null) {
                MessageHandler.error((String)("Cannot find an effigy for " + target.getFullName()));
            }
            GetDocumentationAction.getDocumentation(this._configuration, className, context);
        }
    }

    public static void getDocumentation(Configuration configuration, String className, Effigy context) {
        block19: {
            try {
                URL toRead = DocManager.docClassNameToURL(configuration, className, true, true, false, false);
                if (toRead != null) {
                    _lastClassName = null;
                    configuration.openModel(null, toRead, toRead.toExternalForm());
                    break block19;
                }
                Parameter docApplicationSpecializerParameter = (Parameter)configuration.getAttribute("_docApplicationSpecializer", Parameter.class);
                if (docApplicationSpecializerParameter != null) {
                    String docApplicationSpecializerClassName = docApplicationSpecializerParameter.getExpression();
                    Class<?> docApplicationSpecializerClass = Class.forName(docApplicationSpecializerClassName);
                    DocApplicationSpecializer docApplicationSpecializer = (DocApplicationSpecializer)docApplicationSpecializerClass.newInstance();
                    docApplicationSpecializer.handleDocumentationNotFound(className, context);
                    break block19;
                }
                throw new Exception("Could not get find documentation for " + className + "." + (DocManager.getRemoteDocumentationURLBase() != null ? " Also tried looking on \"" + DocManager.getRemoteDocumentationURLBase() + "\"." : ""));
            }
            catch (Exception exception) {
                try {
                    Parameter remoteDocumentationURLBaseParameter = (Parameter)configuration.getAttribute("_remoteDocumentationURLBase", Parameter.class);
                    String tentativeRemoteDocumentationURLBase = null;
                    tentativeRemoteDocumentationURLBase = remoteDocumentationURLBaseParameter != null ? remoteDocumentationURLBaseParameter.getExpression() : "http://ptolemy.eecs.berkeley.edu/ptolemyII/ptII" + VersionAttribute.majorCurrentVersion() + "/ptII/";
                    String message = "The documentation was not found.\n" + (_lastClassName != null && DocManager.getRemoteDocumentationURLBase() != null ? " We looked in \"" + DocManager.getRemoteDocumentationURLBase() + "\" but did not find anything.\n" : "") + "You may\n" + "1) Build the documentation, which requires " + "configure and make, or\n" + "2) Use the documentation from the website at \"" + tentativeRemoteDocumentationURLBase + "\" or\n" + "3) Cancel";
                    Object[] options = new Object[]{"Build", "Use Website", "Cancel"};
                    int selected = JOptionPane.showOptionDialog(null, message, "Choose Documentation Source", 0, 2, null, options, options[0]);
                    switch (selected) {
                        case 2: {
                            return;
                        }
                        case 1: {
                            DocManager.setRemoteDocumentationURLBase(tentativeRemoteDocumentationURLBase);
                            _lastClassName = className;
                            GetDocumentationAction.getDocumentation(configuration, className, context);
                        }
                        case 0: {
                            Object tableau;
                            Object effigy = context.getEntity("DocBuilderEffigy");
                            if (effigy == null) {
                                try {
                                    effigy = new DocBuilderEffigy(context, "DocBuilderEffigy");
                                }
                                catch (KernelException exception2) {
                                    throw new InternalErrorException((Throwable)exception2);
                                }
                            }
                            if (!(effigy instanceof DocBuilderEffigy)) {
                                MessageHandler.error((String)"Found an effigy named DocBuilderEffigy that is not an instance of DocBuilderEffigy!");
                            }
                            if ((tableau = ((Effigy)((Object)effigy)).getEntity("DocBuilderTableau")) == null) {
                                try {
                                    tableau = new DocBuilderTableau((DocBuilderEffigy)((Object)effigy), "DocBuilderTableau");
                                    ((DocBuilderTableau)((Object)tableau)).setTitle("Documentation for " + className);
                                }
                                catch (KernelException exception3) {
                                    throw new InternalErrorException((Throwable)exception3);
                                }
                            }
                            if (!(tableau instanceof DocBuilderTableau)) {
                                MessageHandler.error((String)"Found a tableau named DocBuilderTableau that is not an instance of DocBuilderTableau!");
                            }
                            ((DocBuilderTableau)((Object)tableau)).show();
                        }
                        default: {
                            throw new InternalErrorException("Unknown return value \"" + selected + "\" from Choose Documentation Source window.");
                        }
                    }
                }
                catch (Throwable throwable) {
                    MessageHandler.error((String)("Cannot find documentation for " + className + "\nTry Running \"make\" in ptII/doc." + "\nor installing the documentation component."), (Throwable)throwable);
                }
            }
        }
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    public void setEffigy(Effigy effigy) {
        this._effigy = effigy;
    }

    private static boolean isMultipleDocumentationAllowed() {
        boolean retVal = false;
        List configsList = Configuration.configurations();
        Configuration config2 = null;
        for (Configuration config2 : configsList) {
            if (config2 != null) break;
        }
        if (config2 == null) {
            throw new KernelRuntimeException("Could not find configuration, list of configurations was " + configsList.size() + " elements, all were null.");
        }
        StringAttribute multipleDocumentationAllowed = (StringAttribute)config2.getAttribute("_multipleDocumentationAllowed");
        if (multipleDocumentationAllowed != null) {
            retVal = Boolean.parseBoolean(multipleDocumentationAllowed.getExpression());
        }
        return retVal;
    }

    private void showDocAttributeTableau(DocAttribute docAttribute, NamedObj target) {
        Effigy effigy = null;
        Effigy context = Configuration.findEffigy(target);
        if (this._effigy == null) {
            if (context == null) {
                context = Configuration.findEffigy(target.getContainer());
                if (context == null) {
                    MessageHandler.error((String)("Cannot find an effigy for " + target.getFullName()));
                }
                effigy = context.getEntity("DocEffigy");
            }
        } else {
            effigy = this._effigy;
        }
        if (effigy == null) {
            try {
                effigy = new DocEffigy(context, "DocEffigy");
            }
            catch (KernelException exception) {
                throw new InternalErrorException((Throwable)exception);
            }
        }
        if (!(effigy instanceof DocEffigy)) {
            MessageHandler.error((String)"Found an effigy named DocEffigy that is not an instance of DocEffigy!");
        }
        ((DocEffigy)effigy).setDocAttribute(docAttribute);
        Object tableau = effigy.getEntity("DocTableau");
        if (tableau == null) {
            try {
                tableau = new DocTableau((DocEffigy)effigy, "DocTableau");
                ((DocTableau)((Object)tableau)).setTitle("Documentation for " + target.getFullName());
            }
            catch (KernelException exception) {
                throw new InternalErrorException((Throwable)exception);
            }
        }
        if (GetDocumentationAction.isMultipleDocumentationAllowed()) {
            try {
                tableau = new DocTableau((DocEffigy)effigy, effigy.uniqueName("DocTableau"));
                ((DocTableau)((Object)tableau)).setTitle("Documentation for " + target.getFullName());
            }
            catch (KernelException exception) {
                MessageHandler.error((String)("Failed to display documentation for \" " + target.getFullName() + "\"."), (Throwable)exception);
            }
        }
        if (!(tableau instanceof DocTableau)) {
            MessageHandler.error((String)"Found a tableau named DocTableau that is not an instance of DocTableau!");
        }
        ((DocTableau)((Object)tableau)).show();
    }
}

