/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import diva.canvas.Figure;
import diva.canvas.FigureLayer;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.JGraph;
import diva.util.UserObjectContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import ptolemy.actor.gui.Configuration;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Singleton;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.kernel.AnimationRenderer;
import ptolemy.vergil.toolbox.PtolemyTransferable;
import ptolemy.vergil.toolbox.SnapConstraint;

public class EditorDropTarget
extends DropTarget {
    private boolean _dropIntoEnabled = true;
    private Vector _additionalListeners = new Vector();

    public EditorDropTarget(JGraph graph) {
        this.setComponent((Component)graph);
        try {
            this.addDropTargetListener(new DTListener());
        }
        catch (TooManyListenersException tooManyListenersException) {}
    }

    public boolean isDropIntoEnabled() {
        return this._dropIntoEnabled;
    }

    public void registerAdditionalListener(DropTargetListener listener) {
        this._additionalListeners.addElement(listener);
    }

    public void deRegisterAdditionalListener(DropTargetListener listener) {
        this._additionalListeners.remove(listener);
    }

    public void setDropIntoEnabled(boolean enabled) {
        this._dropIntoEnabled = enabled;
    }

    private class DTListener
    implements DropTargetListener {
        private NamedObj _highlighted = null;
        private Figure _highlightedFigure = null;
        private AnimationRenderer _highlighter = null;

        private DTListener() {
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            int i = 0;
            while (i < EditorDropTarget.this._additionalListeners.size()) {
                DropTargetListener l = (DropTargetListener)EditorDropTarget.this._additionalListeners.elementAt(i);
                l.dragEnter(dtde);
                ++i;
            }
            if (dtde.isDataFlavorSupported(PtolemyTransferable.namedObjFlavor)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dtde) {
            int i = 0;
            while (i < EditorDropTarget.this._additionalListeners.size()) {
                DropTargetListener l = (DropTargetListener)EditorDropTarget.this._additionalListeners.elementAt(i);
                l.dragExit(dtde);
                ++i;
            }
            if (this._highlighted != null) {
                this._highlighter.renderDeselected(this._highlightedFigure);
                this._highlighted = null;
                this._highlightedFigure = null;
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            int i = 0;
            while (i < EditorDropTarget.this._additionalListeners.size()) {
                DropTargetListener l = (DropTargetListener)EditorDropTarget.this._additionalListeners.elementAt(i);
                l.dragOver(dtde);
                ++i;
            }
            Point2D originalPoint = SnapConstraint.constrainPoint(dtde.getLocation());
            NamedObj over = this._getObjectUnder(originalPoint);
            if (over != this._highlighted) {
                if (this._highlighted != null) {
                    this._highlighter.renderDeselected(this._highlightedFigure);
                    this._highlighted = null;
                    this._highlightedFigure = null;
                }
                if (over != null && EditorDropTarget.this._dropIntoEnabled) {
                    if (this._highlighter == null) {
                        this._highlighter = new AnimationRenderer(Color.white);
                    }
                    this._highlighted = over;
                    this._highlightedFigure = this._getFigureUnder(originalPoint);
                    this._highlighter.renderSelected(this._highlightedFigure);
                }
            }
        }

        public void drop(DropTargetDropEvent dtde) {
            int i = 0;
            while (i < EditorDropTarget.this._additionalListeners.size()) {
                DropTargetListener l = (DropTargetListener)EditorDropTarget.this._additionalListeners.elementAt(i);
                l.drop(dtde);
                ++i;
            }
            if (this._highlighted != null) {
                this._highlighter.renderDeselected(this._highlightedFigure);
                this._highlighted = null;
                this._highlightedFigure = null;
            }
            Point2D originalPoint = SnapConstraint.constrainPoint(dtde.getLocation());
            NamedObj container = this._getObjectUnder(originalPoint);
            GraphPane pane = ((JGraph)EditorDropTarget.this.getComponent()).getGraphPane();
            if (container == null || !EditorDropTarget.this._dropIntoEnabled) {
                GraphController controller = pane.getGraphController();
                GraphModel model = controller.getGraphModel();
                container = (NamedObj)model.getRoot();
            }
            Point2D.Double transformedPoint = new Point2D.Double();
            pane.getTransformContext().getInverseTransform().transform(originalPoint, transformedPoint);
            Iterator iterator = null;
            if (dtde.isDataFlavorSupported(PtolemyTransferable.namedObjFlavor)) {
                try {
                    dtde.acceptDrop(3);
                    iterator = (Iterator)dtde.getTransferable().getTransferData(PtolemyTransferable.namedObjFlavor);
                }
                catch (Exception e) {
                    MessageHandler.error((String)("Can't find a supported data flavor for drop in " + dtde), (Throwable)e);
                    return;
                }
            } else {
                dtde.rejectDrop();
            }
            if (iterator == null) {
                return;
            }
            StringBuffer moml = new StringBuffer();
            moml.append("<group>");
            while (iterator.hasNext()) {
                StringAttribute alternateGetMomlActionAttribute;
                NamedObj dropObj = (NamedObj)iterator.next();
                String name = dropObj instanceof Singleton ? dropObj.getName() : container.uniqueName(dropObj.getName());
                Point2D newPoint = SnapConstraint.constrainPoint(transformedPoint);
                boolean lsidFlag = true;
                try {
                    String lsidString = ((StringAttribute)dropObj.getAttribute("entityId")).getExpression();
                    if (lsidString == null || lsidString.equals("")) {
                        lsidFlag = false;
                    }
                }
                catch (Exception exception) {
                    lsidFlag = false;
                }
                String result = "";
                String rootNodeName = dropObj.getElementName();
                List configsList = Configuration.configurations();
                Configuration config2 = null;
                Object object = null;
                for (Configuration config2 : configsList) {
                    if (config2 != null) break;
                }
                if ((alternateGetMomlActionAttribute = (StringAttribute)config2.getAttribute("_alternateGetMomlAction")) != null && lsidFlag) {
                    String alternateGetMomlClassName = alternateGetMomlActionAttribute.getExpression();
                    try {
                        Class<?> getMomlClass = Class.forName(alternateGetMomlClassName);
                        object = getMomlClass.newInstance();
                        Class[] parameterTypes = new Class[]{NamedObj.class};
                        Method getMomlMethod = getMomlClass.getMethod("getMoml", parameterTypes);
                        Object[] arguments = new Object[]{dropObj};
                        result = (String)getMomlMethod.invoke(object, arguments);
                        int int1 = 1;
                        int int2 = result.indexOf(" ");
                        rootNodeName = result.substring(int1, int2);
                        int1 = result.indexOf("\"", 1);
                        int2 = result.indexOf("\"", int1 + 1);
                        result = String.valueOf(result.substring(0, int1 + 1)) + name + result.substring(int2, result.length());
                    }
                    catch (Exception exception) {
                        System.out.println("Error creating alternateGetMoml!");
                    }
                } else {
                    result = dropObj.exportMoML(name);
                }
                moml.append(result);
                moml.append("<" + rootNodeName + " name=\"" + name + "\">\n");
                moml.append("<property name=\"_location\" class=\"ptolemy.kernel.util.Location\" value=\"{");
                moml.append((int)newPoint.getX());
                moml.append(", ");
                moml.append((int)newPoint.getY());
                moml.append("}\"/>\n</" + rootNodeName + ">\n");
            }
            moml.append("</group>");
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, container, moml.toString());
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
            dtde.dropComplete(true);
            JComponent comp = (JComponent)EditorDropTarget.this.getComponent();
            if (comp != null) {
                ToolTipManager.sharedInstance().registerComponent(comp);
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            int i = 0;
            while (i < EditorDropTarget.this._additionalListeners.size()) {
                DropTargetListener l = (DropTargetListener)EditorDropTarget.this._additionalListeners.elementAt(i);
                l.dropActionChanged(dtde);
                ++i;
            }
        }

        private Figure _getFigureUnder(Point2D point) {
            GraphPane pane = ((JGraph)EditorDropTarget.this.getComponent()).getGraphPane();
            Point2D.Double transformedPoint = new Point2D.Double();
            pane.getTransformContext().getInverseTransform().transform(point, transformedPoint);
            FigureLayer layer = pane.getForegroundLayer();
            double halo = layer.getPickHalo();
            double width = halo * 2.0;
            Rectangle2D.Double region = new Rectangle2D.Double(((Point2D)transformedPoint).getX() - halo, ((Point2D)transformedPoint).getY() - halo, width, width);
            Figure figureUnderMouse = layer.pick((Rectangle2D)region);
            Object objectUnderMouse = null;
            while (figureUnderMouse instanceof UserObjectContainer && objectUnderMouse == null) {
                objectUnderMouse = ((UserObjectContainer)figureUnderMouse).getUserObject();
                if (objectUnderMouse instanceof NamedObj && figureUnderMouse instanceof Figure) {
                    return figureUnderMouse;
                }
                figureUnderMouse = figureUnderMouse.getParent();
            }
            return null;
        }

        private NamedObj _getObjectUnder(Point2D point) {
            Figure figureUnderMouse = this._getFigureUnder(point);
            if (figureUnderMouse == null) {
                return null;
            }
            Object objectUnderMouse = figureUnderMouse.getUserObject();
            if (objectUnderMouse instanceof Location) {
                return ((NamedObj)objectUnderMouse).getContainer();
            }
            if (objectUnderMouse instanceof NamedObj) {
                return (NamedObj)objectUnderMouse;
            }
            return null;
        }
    }
}

