/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import java.util.LinkedList;
import ptolemy.actor.gui.style.TextStyle;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.SingletonAttribute;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class DocAttribute
extends SingletonAttribute {
    public StringAttribute author;
    public StringParameter description;
    public StringAttribute since;
    public StringAttribute version;

    public DocAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.description = new StringParameter((NamedObj)this, "description");
        TextStyle style = new TextStyle((NamedObj)this.description, "_style");
        style.height.setExpression("10");
        style.width.setExpression("70");
        this.author = new StringAttribute((NamedObj)this, "author");
        this.version = new StringAttribute((NamedObj)this, "version");
        this.since = new StringAttribute((NamedObj)this, "since");
        this.refreshParametersAndPorts();
        SingletonParameter hide = new SingletonParameter((NamedObj)this, "_hideName");
        hide.setToken((Token)BooleanToken.TRUE);
        hide.setVisibility(Settable.EXPERT);
    }

    public DocAttribute() {
    }

    public DocAttribute(Workspace workspace) {
        super(workspace);
    }

    public String getParameterDoc(String name) {
        StringParameter parameterAttribute = (StringParameter)this.getAttribute(String.valueOf(name) + " (parameter)");
        if (parameterAttribute != null) {
            return parameterAttribute.getExpression();
        }
        parameterAttribute = (StringParameter)this.getAttribute(String.valueOf(name) + " (port-parameter)");
        if (parameterAttribute != null) {
            return parameterAttribute.getExpression();
        }
        return null;
    }

    public String getPortDoc(String name) {
        StringAttribute portAttribute = (StringAttribute)this.getAttribute(String.valueOf(name) + " (port)");
        if (portAttribute != null) {
            return portAttribute.getExpression();
        }
        return null;
    }

    public void refreshParametersAndPorts() {
        NamedObj container = this.getContainer();
        LinkedList copy = new LinkedList(this.attributeList());
        for (Attribute attribute : copy) {
            String name = attribute.getName();
            int n = name.indexOf(" (parameter)");
            if (n >= 0) {
                if (container.getAttribute(name = name.substring(0, n)) != null) continue;
                try {
                    attribute.setContainer(null);
                    continue;
                }
                catch (KernelException ex) {
                    throw new InternalErrorException((Throwable)ex);
                }
            }
            n = name.indexOf(" (port-parameter)");
            if (n >= 0) {
                name = name.substring(0, n);
                if (container instanceof Entity && ((Entity)container).getPort(name) != null) continue;
                try {
                    attribute.setContainer(null);
                    continue;
                }
                catch (KernelException ex) {
                    throw new InternalErrorException((Throwable)ex);
                }
            }
            n = name.indexOf(" (port)");
            if (n < 0) continue;
            name = name.substring(0, n);
            if (container instanceof Entity && ((Entity)container).getPort(name) != null) continue;
            try {
                attribute.setContainer(null);
            }
            catch (KernelException ex) {
                throw new InternalErrorException((Throwable)ex);
            }
        }
        for (Attribute attribute : container.attributeList(Settable.class)) {
            String name;
            if (((Settable)attribute).getVisibility() != Settable.FULL) continue;
            String modifier = " (parameter)";
            if (attribute instanceof PortParameter) {
                modifier = " (port-parameter)";
            }
            if (this.getAttribute(name = String.valueOf(attribute.getName()) + modifier) != null) continue;
            try {
                new StringParameter((NamedObj)this, name);
            }
            catch (KernelException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        if (container instanceof Entity) {
            for (Port port : ((Entity)container).portList()) {
                String name;
                if (port instanceof ParameterPort || this.getAttribute(name = String.valueOf(port.getName()) + " (port)") != null) continue;
                try {
                    new StringAttribute((NamedObj)this, name);
                }
                catch (KernelException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
        }
    }
}

