/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.JCanvas;
import diva.canvas.Site;
import diva.canvas.connector.FixedNormalSite;
import diva.canvas.connector.Terminal;
import diva.canvas.event.LayerAdapter;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerListener;
import diva.canvas.interactor.SelectionModel;
import diva.graph.GraphController;
import diva.graph.GraphEvent;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.GraphUtilities;
import diva.graph.JGraph;
import diva.graph.basic.BasicGraphModel;
import diva.graph.basic.BasicLayoutTarget;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.LevelLayout;
import diva.graph.modular.CompositeNode;
import diva.graph.modular.Edge;
import diva.graph.modular.Node;
import diva.gui.GUIUtilities;
import diva.gui.toolbox.JCanvasPanner;
import diva.gui.toolbox.JContextMenu;
import diva.util.java2d.ShapeUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.EditParametersDialog;
import ptolemy.actor.gui.PtolemyFrame;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.actor.gui.SizeAttribute;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.UserActorLibrary;
import ptolemy.actor.gui.WindowPropertiesAttribute;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ExpertParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.undo.RedoChangeRequest;
import ptolemy.kernel.undo.UndoChangeRequest;
import ptolemy.kernel.undo.UndoStackAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.IconLoader;
import ptolemy.moml.LibraryAttribute;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.MoMLUndoEntry;
import ptolemy.moml.MoMLVariableChecker;
import ptolemy.util.CancelException;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.BasicGraphController;
import ptolemy.vergil.basic.EditorDropTarget;
import ptolemy.vergil.basic.GetDocumentationAction;
import ptolemy.vergil.basic.NamedObjNodeModel;
import ptolemy.vergil.basic.OffsetMoMLChangeRequest;
import ptolemy.vergil.kernel.AttributeNodeModel;
import ptolemy.vergil.toolbox.MenuItemFactory;
import ptolemy.vergil.toolbox.MoveAction;
import ptolemy.vergil.tree.EntityTreeModel;
import ptolemy.vergil.tree.PTree;
import ptolemy.vergil.tree.PTreeMenuCreator;
import ptolemy.vergil.tree.VisibleTreeModel;

public abstract class BasicGraphFrame
extends PtolemyFrame
implements Printable,
ClipboardOwner,
ChangeListener {
    public static Color BACKGROUND_COLOR = new Color(0xE5E5E5);
    public static String VERGIL_USER_LIBRARY_NAME = UserActorLibrary.USER_LIBRARY_NAME;
    protected Action _cutAction;
    protected Action _copyAction;
    protected JMenu _editMenu;
    protected EditPreferencesAction _editPreferencesAction;
    protected JCanvasPanner _graphPanner;
    protected JTree _library;
    protected PTreeMenuCreator _libraryContextMenuCreator;
    protected EntityTreeModel _libraryModel;
    protected JScrollPane _libraryScrollPane;
    protected MoveToBackAction _moveToBackAction;
    protected MoveToFrontAction _moveToFrontAction;
    protected JPanel _palettePane;
    protected Action _pasteAction;
    protected JSplitPane _splitPane;
    protected JToolBar _toolbar;
    protected CompositeEntity _topLibrary;
    private EditorDropTarget _dropTarget;
    private JGraph _jgraph;
    private static LinkedList _openGraphFrames = new LinkedList();
    private Action _redoAction = new RedoAction();
    private JComponent _rightComponent;
    private Action _undoAction = new UndoAction();
    private Action _zoomInAction = new ZoomInAction("Zoom In");
    private Action _zoomResetAction = new ZoomResetAction("Zoom Reset");
    private Action _zoomFitAction = new ZoomFitAction("Zoom Fit");
    private Action _zoomOutAction = new ZoomOutAction("Zoom Out");

    public BasicGraphFrame(NamedObj entity, Tableau tableau) {
        this(entity, tableau, null);
    }

    public BasicGraphFrame(NamedObj entity, Tableau tableau, LibraryAttribute defaultLibrary) {
        super(entity, tableau);
        entity.addChangeListener((ChangeListener)this);
        this.getContentPane().setLayout(new BorderLayout());
        this._rightComponent = this._createRightComponent(entity);
        ActionListener deletionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicGraphFrame.this.delete();
            }
        };
        this._rightComponent.registerKeyboardAction(deletionListener, "Delete", KeyStroke.getKeyStroke(127, 0), 2);
        this._rightComponent.registerKeyboardAction(deletionListener, "BackSpace", KeyStroke.getKeyStroke(8, 0), 2);
        this._rightComponent.setRequestFocusEnabled(true);
        this._rightComponent.setAlignmentX(1.0f);
        this._rightComponent.setAlignmentY(1.0f);
        Configuration configuration = this.getConfiguration();
        this._rightComponent.setBackground(BACKGROUND_COLOR);
        if (configuration != null) {
            try {
                PtolemyPreferences preferences = PtolemyPreferences.getPtolemyPreferencesWithinConfiguration(configuration);
                if (preferences != null) {
                    this._rightComponent.setBackground(preferences.backgroundColor.asColor());
                }
            }
            catch (IllegalActionException illegalActionException) {}
        }
        try {
            Parameter pan;
            SizeAttribute size = (SizeAttribute)this.getModel().getAttribute("_vergilSize", SizeAttribute.class);
            if (size != null) {
                size.setSize(this._rightComponent);
            } else {
                this._rightComponent.setMinimumSize(new Dimension(200, 200));
                this._rightComponent.setPreferredSize(new Dimension(600, 400));
                this._rightComponent.setSize(600, 400);
            }
            Parameter zoom = (Parameter)this.getModel().getAttribute("_vergilZoomFactor", Parameter.class);
            if (zoom != null) {
                this.zoom(((DoubleToken)zoom.getToken()).doubleValue());
                zoom.setVisibility(Settable.EXPERT);
            }
            if ((pan = (Parameter)this.getModel().getAttribute("_vergilCenter", Parameter.class)) != null) {
                ArrayToken panToken = (ArrayToken)pan.getToken();
                Point2D.Double center = new Point2D.Double(((DoubleToken)panToken.getElement(0)).doubleValue(), ((DoubleToken)panToken.getElement(1)).doubleValue());
                this.setCenter(center);
                pan.setVisibility(Settable.EXPERT);
            }
        }
        catch (Throwable throwable) {}
        this._graphPanner = new JCanvasPanner((JCanvas)this.getJGraph());
        this._graphPanner.setPreferredSize(new Dimension(200, 150));
        this._graphPanner.setMaximumSize(new Dimension(200, 150));
        this._graphPanner.setSize(200, 150);
        boolean gotLibrary = false;
        try {
            LibraryAttribute libraryAttribute = (LibraryAttribute)entity.getAttribute("_library", LibraryAttribute.class);
            if (libraryAttribute != null) {
                try {
                    this._topLibrary = libraryAttribute.getLibrary();
                    gotLibrary = true;
                }
                catch (SecurityException securityException) {
                    System.out.println("Warning: failed to parse _library attribute (running in an applet or sandbox always causes this)");
                }
            }
        }
        catch (Exception ex) {
            try {
                MessageHandler.warning((String)"Invalid library in the model.", (Throwable)ex);
            }
            catch (CancelException cancelException) {}
        }
        if (!gotLibrary) {
            try {
                if (defaultLibrary != null) {
                    this._topLibrary = defaultLibrary.getLibrary();
                    gotLibrary = true;
                }
            }
            catch (SecurityException securityException) {
            }
            catch (Exception ex) {
                try {
                    MessageHandler.warning((String)"Invalid default library for the frame.", (Throwable)ex);
                }
                catch (CancelException cancelException) {}
            }
        }
        if (!gotLibrary) {
            this._topLibrary = this._createDefaultLibrary(entity.workspace());
        }
        this._libraryModel = new VisibleTreeModel(this._topLibrary);
        this._library = new PTree(this._libraryModel);
        this._library.setRootVisible(false);
        this._library.setBackground(BACKGROUND_COLOR);
        this._libraryContextMenuCreator = new PTreeMenuCreator();
        this._libraryContextMenuCreator.addMenuItemFactory(new OpenLibraryMenuItemFactory());
        this._libraryContextMenuCreator.addMenuItemFactory(new DocumentationMenuItemFactory());
        this._library.addMouseListener(this._libraryContextMenuCreator);
        this._libraryScrollPane = new JScrollPane(this._library);
        this._libraryScrollPane.setMinimumSize(new Dimension(200, 200));
        this._libraryScrollPane.setPreferredSize(new Dimension(200, 200));
        this._palettePane = new JPanel();
        this._palettePane.setBorder(null);
        this._palettePane.setLayout(new BoxLayout(this._palettePane, 1));
        this._palettePane.add((Component)this._libraryScrollPane, "Center");
        this._palettePane.add((Component)this._graphPanner, "South");
        this._splitPane = new JSplitPane(1, true);
        this._splitPane.setLeftComponent(this._palettePane);
        this._splitPane.setRightComponent(this._rightComponent);
        this.getContentPane().add((Component)this._splitPane, "Center");
        this._toolbar = new JToolBar();
        this.getContentPane().add((Component)this._toolbar, "North");
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._zoomInAction);
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._zoomResetAction);
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._zoomFitAction);
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._zoomOutAction);
        this._cutAction = new CutAction();
        this._copyAction = new CopyAction();
        this._pasteAction = new PasteAction();
        this._moveToFrontAction = new MoveToFrontAction();
        this._moveToBackAction = new MoveToBackAction();
        this._editPreferencesAction = new EditPreferencesAction();
        _openGraphFrames.add(this);
    }

    public void changeExecuted(ChangeRequest change) {
        boolean persistent = true;
        if (change != null && (persistent = change.isPersistent())) {
            this.setModified(persistent);
        }
        if (this._graphPanner != null) {
            this._graphPanner.repaint();
        }
    }

    public void changeFailed(ChangeRequest change, Exception exception) {
        if (change == null) {
            MessageHandler.error((String)"Change failed", (Throwable)exception);
        } else if (!change.isErrorReported()) {
            change.setErrorReported(true);
            MessageHandler.error((String)"Change failed", (Throwable)exception);
        }
    }

    public void copy() {
        HashSet namedObjSet = this._getSelectionSet();
        StringWriter buffer = new StringWriter();
        try {
            NamedObj container = (NamedObj)this._getGraphModel().getRoot();
            for (NamedObj element : container.sortContainedObjects((Collection)namedObjSet)) {
                element.exportMoML((Writer)buffer, 0);
            }
            if (container instanceof CompositeEntity) {
                buffer.write(((CompositeEntity)container).exportLinks(1, (Collection)namedObjSet));
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String momlToBeCopied = buffer.toString();
            String variablesToBePrepended = "";
            try {
                MoMLVariableChecker variableChecker = new MoMLVariableChecker();
                variablesToBePrepended = variableChecker.checkCopy(momlToBeCopied, container);
            }
            catch (IllegalActionException illegalActionException) {}
            clipboard.setContents(new StringSelection(String.valueOf(variablesToBePrepended) + momlToBeCopied), this);
        }
        catch (IOException ex) {
            MessageHandler.error((String)"Copy failed", (Throwable)ex);
        }
    }

    public void createHierarchy() {
        GraphController controller = this._getGraphController();
        SelectionModel model = controller.getSelectionModel();
        AbstractBasicGraphModel graphModel = (AbstractBasicGraphModel)controller.getGraphModel();
        Object[] selection = model.getSelectionAsArray();
        HashSet<NamedObj> namedObjSet = new HashSet<NamedObj>();
        HashSet<Object> nodeSet = new HashSet<Object>();
        StringBuffer newPorts = new StringBuffer();
        StringBuffer extRelations = new StringBuffer();
        StringBuffer extConnections = new StringBuffer();
        StringBuffer intRelations = new StringBuffer();
        StringBuffer intConnections = new StringBuffer();
        try {
            String selectionMoML;
            Object userObject;
            NamedObj container = (NamedObj)graphModel.getRoot();
            if (!(container instanceof CompositeEntity)) {
                throw new InternalErrorException("Cannot create hierarchy if the container is not a CompositeEntity.");
            }
            String compositeActorName = container.uniqueName("CompositeActor");
            double[] location = new double[2];
            boolean gotLocation = false;
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof Figure) {
                    if (!gotLocation) {
                        location[0] = ((Figure)selection[i]).getBounds().getCenterX();
                        location[1] = ((Figure)selection[i]).getBounds().getCenterY();
                        gotLocation = true;
                    }
                    if (graphModel.isNode(userObject = ((Figure)selection[i]).getUserObject())) {
                        nodeSet.add(userObject);
                        NamedObj actual = (NamedObj)graphModel.getSemanticObject(userObject);
                        namedObjSet.add(actual);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof Figure && graphModel.isEdge(userObject = ((Figure)selection[i]).getUserObject())) {
                    Object head = graphModel.getHead(userObject);
                    Object tail = graphModel.getTail(userObject);
                    boolean headOK = nodeSet.contains(head);
                    boolean tailOK = nodeSet.contains(tail);
                    Iterator objects = nodeSet.iterator();
                    while (!(headOK && tailOK || !objects.hasNext())) {
                        Object object = objects.next();
                        if (!headOK && GraphUtilities.isContainedNode((Object)head, object, (GraphModel)graphModel)) {
                            headOK = true;
                        }
                        if (tailOK || !GraphUtilities.isContainedNode((Object)tail, object, (GraphModel)graphModel)) continue;
                        tailOK = true;
                    }
                    if (!headOK && tailOK || headOK && !tailOK) {
                        IOPort port = null;
                        IORelation relation = null;
                        boolean duplicateRelation = false;
                        if (head instanceof IOPort) {
                            port = (IOPort)head;
                            if (tail instanceof IOPort) {
                                relation = (IORelation)graphModel.getSemanticObject(userObject);
                                duplicateRelation = true;
                            } else {
                                relation = (IORelation)graphModel.getSemanticObject(tail);
                            }
                        } else if (tail instanceof IOPort) {
                            port = (IOPort)tail;
                            relation = (IORelation)graphModel.getSemanticObject(head);
                        }
                        if (port != null) {
                            ComponentEntity otherEntity;
                            IOPort otherPort;
                            String relationName;
                            ComponentEntity entity = (ComponentEntity)port.getContainer();
                            String portName = "port_" + i;
                            boolean isInput = port.isInput();
                            boolean isOutput = port.isOutput();
                            newPorts.append("<port name=\"" + portName + "\" class=\"ptolemy.actor.TypedIOPort" + "\">\n");
                            if (namedObjSet.contains(entity)) {
                                if (isInput) {
                                    newPorts.append("<property name=\"input\"/>");
                                }
                                if (isOutput) {
                                    newPorts.append("<property name=\"output\"/>");
                                }
                                newPorts.append("\n</port>\n");
                                relationName = String.valueOf(relation.getName()) + "_" + i;
                                intRelations.append("<relation name=\"" + relationName + "\" class=\"" + "ptolemy.actor.TypedIORelation\"/>\n");
                                intConnections.append("<link port=\"" + entity.getName() + "." + port.getName() + "\" relation=\"" + relationName + "\"/>\n");
                                intConnections.append("<link port=\"" + portName + "\" relation=\"" + relationName + "\"/>\n");
                                if (duplicateRelation) {
                                    extRelations.append("<relation name=\"" + relation.getName() + "\" class=\"" + "ptolemy.actor.TypedIORelation\"/>\n");
                                    otherPort = (IOPort)tail;
                                    otherEntity = (ComponentEntity)otherPort.getContainer();
                                    if (otherEntity == container) {
                                        extConnections.append("<link port=\"" + otherPort.getName() + "\" relation=\"" + relation.getName() + "\"/>\n");
                                    } else {
                                        extConnections.append("<link port=\"" + otherEntity.getName() + "." + otherPort.getName() + "\" relation=\"" + relation.getName() + "\"/>\n");
                                    }
                                }
                                extConnections.append("<link port=\"" + compositeActorName + "." + portName + "\" relation=\"" + relation.getName() + "\"/>\n");
                            } else {
                                if (isInput) {
                                    newPorts.append("<property name=\"output\"/>");
                                }
                                if (isOutput) {
                                    newPorts.append("<property name=\"input\"/>");
                                }
                                newPorts.append("\n</port>\n");
                                relationName = String.valueOf(relation.getName()) + "_" + i;
                                extRelations.append("<relation name=\"" + relationName + "\" class=\"" + "ptolemy.actor.TypedIORelation\"/>\n");
                                extConnections.append("<link port=\"" + entity.getName() + "." + port.getName() + "\" relation=\"" + relationName + "\"/>\n");
                                extConnections.append("<link port=\"" + compositeActorName + "." + portName + "\" relation=\"" + relationName + "\"/>\n");
                                if (duplicateRelation) {
                                    intRelations.append("<relation name=\"" + relation.getName() + "\" class=\"" + "ptolemy.actor.TypedIORelation\"/>\n");
                                    otherPort = (IOPort)tail;
                                    otherEntity = (ComponentEntity)otherPort.getContainer();
                                    intConnections.append("<link port=\"" + otherEntity.getName() + "." + otherPort.getName() + "\" relation=\"" + relation.getName() + "\"/>\n");
                                }
                                intConnections.append("<link port=\"" + portName + "\" relation=\"" + relation.getName() + "\"/>\n");
                            }
                        }
                    }
                }
                ++i;
            }
            StringBuffer moml = new StringBuffer();
            moml.append("<group>\n");
            this.copy();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            try {
                selectionMoML = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception ex) {
                throw new InternalErrorException(null, (Throwable)ex, "Getting data from clipboard failed.");
            }
            moml.append(this._deleteMoML(graphModel, selection, model));
            moml.append("<entity name=\"" + compositeActorName + "\" class=\"ptolemy.actor.TypedCompositeActor\">\n");
            moml.append("\t<property name=\"_location\" class=\"ptolemy.moml.Location\" value=\"" + location[0] + ", " + location[1] + "\">\n");
            moml.append("\t</property>\n");
            moml.append(newPorts);
            moml.append(selectionMoML);
            moml.append(intRelations);
            moml.append(intConnections);
            moml.append("</entity>\n");
            moml.append(extRelations);
            moml.append(extConnections);
            moml.append("</group>\n");
            MoMLChangeRequest request = null;
            request = new MoMLChangeRequest((Object)this, container, moml.toString());
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
            ComponentEntity newObject = ((CompositeEntity)container).getEntity(compositeActorName);
            IconLoader _iconLoader = MoMLParser.getIconLoader();
            if (_iconLoader != null) {
                _iconLoader.loadIconForClass("ptolemy.actor.TypedCompositeActor", (NamedObj)newObject);
            }
        }
        catch (Throwable throwable) {
            MessageHandler.error((String)"Creating hierarchy failed", (Throwable)throwable);
        }
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void delete() {
        GraphController controller = this._getGraphController();
        SelectionModel model = controller.getSelectionModel();
        AbstractBasicGraphModel graphModel = (AbstractBasicGraphModel)controller.getGraphModel();
        Object[] selection = model.getSelectionAsArray();
        StringBuffer moml = this._deleteMoML(graphModel, selection, model);
        try {
            NamedObj container = graphModel.getPtolemyModel();
            MoMLChangeRequest change = new MoMLChangeRequest((Object)this, container, moml.toString());
            change.setUndoable(true);
            container.requestChange((ChangeRequest)change);
        }
        catch (Exception ex) {
            MessageHandler.error((String)("Delete failed, changeRequest was:" + moml), (Throwable)ex);
        }
        graphModel.dispatchGraphEvent(new GraphEvent((Object)this, 30, graphModel.getRoot()));
    }

    public void dispose() {
        this._libraryModel.setRoot(null);
        _openGraphFrames.remove(this);
        super.dispose();
    }

    public void expandAllLibraryRows() {
        int i = 0;
        while (i < this._library.getRowCount()) {
            this._library.expandRow(i);
            ++i;
        }
    }

    public Point2D getCenter() {
        Rectangle2D rect = this.getVisibleCanvasRectangle();
        return new Point2D.Double(rect.getCenterX(), rect.getCenterY());
    }

    public JGraph getJGraph() {
        return this._jgraph;
    }

    public Rectangle2D getVisibleCanvasRectangle() {
        AffineTransform inverse;
        AffineTransform current = this.getJGraph().getCanvasPane().getTransformContext().getTransform();
        try {
            inverse = current.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e.toString());
        }
        Rectangle2D visibleRect = this.getVisibleRectangle();
        return ShapeUtilities.transformBounds((Rectangle2D)visibleRect, (AffineTransform)inverse);
    }

    public Rectangle2D getVisibleRectangle() {
        Dimension size = this.getJGraph().getSize();
        return new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight());
    }

    public void layoutGraph() {
        GraphController controller = this._getGraphController();
        AbstractBasicGraphModel model = this._getGraphModel();
        PtolemyLayoutTarget target = new PtolemyLayoutTarget(controller);
        PtolemyLayout layout = new PtolemyLayout((LayoutTarget)target);
        layout.setOrientation(1);
        layout.setRandomizedPlacement(false);
        try {
            NamedObj composite = model.getPtolemyModel();
            StringBuffer moml = new StringBuffer();
            moml.append("<group>\n");
            Iterator nodes = model.nodes(composite);
            while (nodes.hasNext()) {
                Location location = (Location)nodes.next();
                NamedObj element = location.getContainer();
                String expression = location.getExpression();
                if (expression == null) {
                    expression = "0, 0";
                }
                String containingElementName = element.getElementName();
                moml.append("<" + containingElementName + " name=\"" + element.getName() + "\" >\n");
                moml.append("<" + location.getElementName() + " name=\"" + location.getName() + "\" value=\"" + expression + "\" />\n");
                moml.append("</" + containingElementName + ">\n");
            }
            moml.append("</group>\n");
            MoMLUndoEntry undoEntry = new MoMLUndoEntry(composite, moml.toString());
            UndoStackAttribute undoInfo = UndoStackAttribute.getUndoInfo((NamedObj)composite);
            undoInfo.push((ptolemy.kernel.undo.UndoAction)undoEntry);
        }
        catch (Throwable throwable) {}
        layout.layout(model.getRoot());
        this.getJGraph().repaint();
        this._graphPanner.repaint();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        AbstractBasicGraphModel model = this._getGraphModel();
        if (transferable == null) {
            return;
        }
        try {
            NamedObj container = (NamedObj)model.getRoot();
            StringBuffer moml = new StringBuffer();
            moml.append("<group name=\"auto\">\n");
            moml.append((String)transferable.getTransferData(DataFlavor.stringFlavor));
            moml.append("</group>\n");
            OffsetMoMLChangeRequest change = new OffsetMoMLChangeRequest(this, container, moml.toString());
            change.setUndoable(true);
            container.requestChange((ChangeRequest)change);
        }
        catch (Exception ex) {
            MessageHandler.error((String)"Paste failed", (Throwable)ex);
        }
    }

    public int print(Graphics graphics, PageFormat format, int index) throws PrinterException {
        if (this.getJGraph() != null) {
            Rectangle2D view = this.getVisibleRectangle();
            return this.getJGraph().print(graphics, format, index, view);
        }
        return 1;
    }

    public void redo() {
        AbstractBasicGraphModel model = this._getGraphModel();
        try {
            NamedObj toplevel = (NamedObj)model.getRoot();
            RedoChangeRequest change = new RedoChangeRequest((Object)this, toplevel);
            toplevel.requestChange((ChangeRequest)change);
        }
        catch (Exception ex) {
            MessageHandler.error((String)"Redo failed", (Throwable)ex);
        }
    }

    public void saveComponentInFile(Entity entity) throws Exception {
        JFileChooser fileDialog = new JFileChooser();
        fileDialog.setDialogTitle("Save actor as...");
        if (_directory != null) {
            fileDialog.setCurrentDirectory(_directory);
        } else {
            String currentWorkingDirectory = StringUtilities.getProperty((String)"user.dir");
            if (currentWorkingDirectory != null) {
                fileDialog.setCurrentDirectory(new File(currentWorkingDirectory));
            }
        }
        fileDialog.setSelectedFile(new File(fileDialog.getCurrentDirectory(), String.valueOf(entity.getName()) + ".xml"));
        int returnVal = fileDialog.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fileDialog.getSelectedFile();
            if (!this._confirmFile(entity, file)) {
                return;
            }
            _directory = fileDialog.getCurrentDirectory();
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(file);
                String name = entity.getName();
                String filename = file.getName();
                int period = filename.indexOf(".");
                name = period > 0 ? filename.substring(0, period) : filename;
                fileWriter.write("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE " + entity.getElementName() + " PUBLIC " + "\"-//UC Berkeley//DTD MoML 1//EN\"\n" + "    \"http://ptolemy.eecs.berkeley.edu" + "/xml/dtd/MoML_1.dtd\">\n");
                entity.exportMoML((Writer)fileWriter, 0, name);
            }
            finally {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
        }
    }

    public static void saveComponentInLibrary(Configuration configuration, Entity entity) {
        try {
            UserActorLibrary.saveComponentInLibrary(configuration, entity);
        }
        catch (Exception exception) {
            MessageHandler.error((String)("Failed to save \"" + entity.getName() + "\"."));
        }
    }

    public void setCenter(Point2D center) {
        Rectangle2D visibleRect = this.getVisibleCanvasRectangle();
        AffineTransform newTransform = this.getJGraph().getCanvasPane().getTransformContext().getTransform();
        newTransform.translate(visibleRect.getCenterX() - center.getX(), visibleRect.getCenterY() - center.getY());
        this.getJGraph().getCanvasPane().setTransform(newTransform);
    }

    public void setJGraph(JGraph jgraph) {
        this._jgraph = jgraph;
    }

    public void undo() {
        AbstractBasicGraphModel model = this._getGraphModel();
        try {
            NamedObj toplevel = (NamedObj)model.getRoot();
            UndoChangeRequest change = new UndoChangeRequest((Object)this, toplevel);
            toplevel.requestChange((ChangeRequest)change);
        }
        catch (Exception ex) {
            MessageHandler.error((String)"Undo failed", (Throwable)ex);
        }
    }

    public void zoom(double factor) {
        JCanvas canvas = this.getJGraph().getGraphPane().getCanvas();
        AffineTransform current = canvas.getCanvasPane().getTransformContext().getTransform();
        Point2D center = this.getCenter();
        current.scale(factor, factor);
        canvas.getCanvasPane().setTransform(current);
        this.setCenter(center);
        if (this._graphPanner != null) {
            this._graphPanner.repaint();
        }
    }

    public void zoomFit() {
        GraphPane pane = this.getJGraph().getGraphPane();
        Rectangle2D bounds = pane.getForegroundLayer().getLayerBounds();
        if (bounds.isEmpty()) {
            return;
        }
        Rectangle2D viewSize = this.getVisibleRectangle();
        AffineTransform newTransform = CanvasUtilities.computeFitTransform((RectangularShape)bounds, (RectangularShape)viewSize);
        JCanvas canvas = pane.getCanvas();
        canvas.getCanvasPane().setTransform(newTransform);
        if (this._graphPanner != null) {
            this._graphPanner.repaint();
        }
    }

    public void zoomReset() {
        JCanvas canvas = this.getJGraph().getGraphPane().getCanvas();
        AffineTransform current = canvas.getCanvasPane().getTransformContext().getTransform();
        current.setToIdentity();
        canvas.getCanvasPane().setTransform(current);
        if (this._graphPanner != null) {
            this._graphPanner.repaint();
        }
    }

    protected void _addMenus() {
        super._addMenus();
        this._editMenu = new JMenu("Edit");
        this._editMenu.setMnemonic(69);
        this._menubar.add(this._editMenu);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._undoAction);
        GUIUtilities.addMenuItem((JMenu)this._editMenu, (Action)this._undoAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._redoAction);
        GUIUtilities.addMenuItem((JMenu)this._editMenu, (Action)this._redoAction);
        this._editMenu.addSeparator();
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._cutAction);
        GUIUtilities.addMenuItem((JMenu)this._editMenu, (Action)this._cutAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._copyAction);
        GUIUtilities.addMenuItem((JMenu)this._editMenu, (Action)this._copyAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._pasteAction);
        GUIUtilities.addMenuItem((JMenu)this._editMenu, (Action)this._pasteAction);
        this._editMenu.addSeparator();
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._moveToBackAction);
        GUIUtilities.addMenuItem((JMenu)this._editMenu, (Action)this._moveToBackAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._moveToFrontAction);
        GUIUtilities.addMenuItem((JMenu)this._editMenu, (Action)this._moveToFrontAction);
        this._editMenu.addSeparator();
        GUIUtilities.addMenuItem((JMenu)this._editMenu, (Action)this._editPreferencesAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)BasicGraphController._configureAction);
        if (this._viewMenu == null) {
            this._viewMenu = new JMenu("View");
            this._viewMenu.setMnemonic(86);
            this._menubar.add(this._viewMenu);
        } else {
            this._viewMenu.addSeparator();
        }
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._zoomInAction);
        GUIUtilities.addMenuItem((JMenu)this._viewMenu, (Action)this._zoomInAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._zoomResetAction);
        GUIUtilities.addMenuItem((JMenu)this._viewMenu, (Action)this._zoomResetAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._zoomFitAction);
        GUIUtilities.addMenuItem((JMenu)this._viewMenu, (Action)this._zoomFitAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._zoomOutAction);
        GUIUtilities.addMenuItem((JMenu)this._viewMenu, (Action)this._zoomOutAction);
    }

    protected boolean _checkForImplied(List elements) {
        for (NamedObj element : elements) {
            if (element.getDerivedLevel() >= Integer.MAX_VALUE) continue;
            MessageHandler.error((String)("Cannot change the position of " + element.getFullName() + " because the position is set by the class."));
            return true;
        }
        return false;
    }

    protected boolean _close() {
        boolean result = super._close();
        if (result) {
            this.getModel().removeChangeListener((ChangeListener)this);
            AbstractBasicGraphModel graphModel = this._getGraphModel();
            graphModel.removeListeners();
        }
        return result;
    }

    protected CompositeEntity _createDefaultLibrary(Workspace workspace) {
        Configuration configuration = this.getConfiguration();
        if (configuration != null) {
            CompositeEntity result = (CompositeEntity)configuration.getEntity("actor library");
            if (result == null) {
                result = new CompositeEntity(workspace);
                try {
                    result.setName("topLibrary");
                    new Attribute((NamedObj)result, "_libraryMarker");
                }
                catch (Exception ex) {
                    throw new InternalErrorException("Library configuration failed: " + ex);
                }
            }
            return result;
        }
        return null;
    }

    protected abstract GraphPane _createGraphPane(NamedObj var1);

    protected JComponent _createRightComponent(NamedObj entity) {
        GraphPane pane = this._createGraphPane(entity);
        pane.getForegroundLayer().setPickHalo(2.0);
        pane.getForegroundEventLayer().setConsuming(false);
        pane.getForegroundEventLayer().setEnabled(true);
        pane.getForegroundEventLayer().addLayerListener((LayerListener)new LayerAdapter(){

            public void mousePressed(LayerEvent event) {
                Component component = event.getComponent();
                if (!component.hasFocus()) {
                    component.requestFocus();
                }
            }
        });
        this.setJGraph(new JGraph(pane));
        this._dropTarget = new EditorDropTarget(this._jgraph);
        return this._jgraph;
    }

    protected File _getDirectory() {
        return _directory;
    }

    protected GraphController _getGraphController() {
        GraphPane graphPane = this.getJGraph().getGraphPane();
        return graphPane.getGraphController();
    }

    protected AbstractBasicGraphModel _getGraphModel() {
        GraphController controller = this._getGraphController();
        return (AbstractBasicGraphModel)controller.getGraphModel();
    }

    protected HashSet _getSelectionSet() {
        Object userObject;
        GraphController controller = this._getGraphController();
        GraphModel graphModel = controller.getGraphModel();
        SelectionModel model = controller.getSelectionModel();
        Object[] selection = model.getSelectionAsArray();
        HashSet<NamedObj> namedObjSet = new HashSet<NamedObj>();
        HashSet<Object> nodeSet = new HashSet<Object>();
        int i = 0;
        while (i < selection.length) {
            if (selection[i] instanceof Figure && graphModel.isNode(userObject = ((Figure)selection[i]).getUserObject())) {
                nodeSet.add(userObject);
                NamedObj actual = (NamedObj)graphModel.getSemanticObject(userObject);
                namedObjSet.add(actual);
            }
            ++i;
        }
        i = 0;
        while (i < selection.length) {
            if (selection[i] instanceof Figure && graphModel.isEdge(userObject = ((Figure)selection[i]).getUserObject())) {
                Object head = graphModel.getHead(userObject);
                Object tail = graphModel.getTail(userObject);
                boolean headOK = nodeSet.contains(head);
                boolean tailOK = nodeSet.contains(tail);
                Iterator objects = nodeSet.iterator();
                while (!(headOK && tailOK || !objects.hasNext())) {
                    Object object = objects.next();
                    if (!headOK && GraphUtilities.isContainedNode((Object)head, object, (GraphModel)graphModel)) {
                        headOK = true;
                    }
                    if (tailOK || !GraphUtilities.isContainedNode((Object)tail, object, (GraphModel)graphModel)) continue;
                    tailOK = true;
                }
                if (headOK && tailOK) {
                    NamedObj actual = (NamedObj)graphModel.getSemanticObject(userObject);
                    namedObjSet.add(actual);
                }
            }
            ++i;
        }
        return namedObjSet;
    }

    protected JComponent _getRightComponent() {
        return this._rightComponent;
    }

    protected void _setDirectory(File directory) {
        _directory = directory;
    }

    protected void _setDropIntoEnabled(boolean enable) {
        this._dropTarget.setDropIntoEnabled(enable);
    }

    protected void _writeFile(File file) throws IOException {
        try {
            SizeAttribute size;
            Container component = this._getRightComponent().getParent();
            Container parent = component.getParent();
            while (parent != null && !(parent instanceof Frame)) {
                component = parent;
                parent = component.getParent();
            }
            if (parent instanceof Frame) {
                WindowPropertiesAttribute properties = (WindowPropertiesAttribute)this.getModel().getAttribute("_windowProperties", WindowPropertiesAttribute.class);
                if (properties == null) {
                    properties = new WindowPropertiesAttribute(this.getModel(), "_windowProperties");
                }
                properties.recordProperties((Frame)parent);
            }
            if ((size = (SizeAttribute)this.getModel().getAttribute("_vergilSize", SizeAttribute.class)) == null) {
                size = new SizeAttribute(this.getModel(), "_vergilSize");
            }
            size.recordSize(this._getRightComponent());
            JCanvas canvas = this.getJGraph().getGraphPane().getCanvas();
            AffineTransform current = canvas.getCanvasPane().getTransformContext().getTransform();
            double scale = current.getScaleX();
            Parameter zoom = (Parameter)this.getModel().getAttribute("_vergilZoomFactor", Parameter.class);
            if (zoom == null) {
                zoom = new ExpertParameter(this.getModel(), "_vergilZoomFactor");
            }
            zoom.setToken((Token)new DoubleToken(scale));
            zoom.setVisibility(Settable.EXPERT);
            Point2D center = this.getCenter();
            Parameter pan = (Parameter)this.getModel().getAttribute("_vergilCenter", Parameter.class);
            if (pan == null) {
                pan = new ExpertParameter(this.getModel(), "_vergilCenter");
            }
            Token[] centerArray = new Token[]{new DoubleToken(center.getX()), new DoubleToken(center.getY())};
            pan.setToken((Token)new ArrayToken(centerArray));
            pan.setVisibility(Settable.EXPERT);
        }
        catch (Throwable throwable) {}
        super._writeFile(file);
    }

    private StringBuffer _deleteMoML(AbstractBasicGraphModel graphModel, Object[] selection, SelectionModel model) {
        NamedObjNodeModel namedObjNodeModel;
        Object[] userObjects = new Object[selection.length];
        int i = 0;
        while (i < selection.length) {
            userObjects[i] = ((Figure)selection[i]).getUserObject();
            model.removeSelection(selection[i]);
            ++i;
        }
        HashSet<Object> edgeSet = new HashSet<Object>();
        StringBuffer moml = new StringBuffer("<group>\n");
        int i2 = 0;
        while (i2 < selection.length) {
            Object object = userObjects[i2];
            if (graphModel.isEdge(object)) {
                NamedObj actual = (NamedObj)graphModel.getSemanticObject(object);
                if (actual == null) {
                    edgeSet.add(object);
                } else {
                    moml.append(graphModel.getDeleteEdgeMoML(object));
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < selection.length) {
            Object object = userObjects[i3];
            namedObjNodeModel = (NamedObjNodeModel)graphModel.getNodeModel(object);
            if (graphModel.isNode(object) && !(namedObjNodeModel instanceof AttributeNodeModel)) {
                moml.append(graphModel.getDeleteNodeMoML(object));
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < selection.length) {
            Object object = userObjects[i3];
            namedObjNodeModel = (NamedObjNodeModel)graphModel.getNodeModel(object);
            if (graphModel.isNode(object) && namedObjNodeModel instanceof AttributeNodeModel) {
                moml.append(graphModel.getDeleteNodeMoML(object));
            }
            ++i3;
        }
        moml.append("</group>\n");
        try {
            graphModel.setDispatchEnabled(false);
            for (Object e : edgeSet) {
                if (!graphModel.isEdge(e)) continue;
                graphModel.disconnectEdge(this, e);
            }
        }
        finally {
            graphModel.setDispatchEnabled(true);
        }
        return moml;
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
            this.putValue("tooltip", "Copy the current selection onto the clipboard.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 67);
        }

        public void actionPerformed(ActionEvent e) {
            BasicGraphFrame.this.copy();
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            super("Cut");
            this.putValue("tooltip", "Cut the current selection onto the clipboard.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 84);
        }

        public void actionPerformed(ActionEvent e) {
            BasicGraphFrame.this.cut();
        }
    }

    private class DocumentationMenuItemFactory
    implements MenuItemFactory {
        private DocumentationMenuItemFactory() {
        }

        public JMenuItem create(JContextMenu menu, NamedObj object) {
            GetDocumentationAction action = new GetDocumentationAction(){

                public void actionPerformed(ActionEvent e) {
                    Configuration configuration = BasicGraphFrame.this.getConfiguration();
                    this.setConfiguration(configuration);
                    super.actionPerformed(e);
                }
            };
            action.putValue("tooltip", "Get Documentation.");
            action.putValue("MnemonicKey", 68);
            return menu.add((Action)action, (String)action.getValue("Name"));
        }
    }

    private class EditPreferencesAction
    extends AbstractAction {
        public EditPreferencesAction() {
            super("Edit Preferences");
            this.putValue("tooltip", "Change the Vergil preferences");
            this.putValue("MnemonicKey", 69);
        }

        public void actionPerformed(ActionEvent e) {
            Configuration configuration = BasicGraphFrame.this.getConfiguration();
            PtolemyPreferences preferences = null;
            try {
                preferences = (PtolemyPreferences)configuration.getAttribute(PtolemyPreferences.PREFERENCES_WITHIN_CONFIGURATION, PtolemyPreferences.class);
            }
            catch (IllegalActionException ex) {
                MessageHandler.error((String)"Preferences attribute found, but not of the right class.", (Throwable)ex);
            }
            if (preferences == null) {
                MessageHandler.message((String)"No preferences given in the configuration.");
            } else {
                new EditParametersDialog((Frame)BasicGraphFrame.this, (NamedObj)preferences, "Edit Ptolemy Preferences");
                try {
                    preferences.setAsDefault();
                }
                catch (IllegalActionException ex) {
                    MessageHandler.error((String)"Invalid expression.", (Throwable)ex);
                    this.actionPerformed(e);
                }
                for (BasicGraphFrame frame : _openGraphFrames) {
                    GraphModel graphModel = frame._getGraphController().getGraphModel();
                    graphModel.dispatchGraphEvent(new GraphEvent((Object)this, 30, graphModel.getRoot()));
                    if (frame._graphPanner == null) continue;
                    frame._graphPanner.repaint();
                }
                try {
                    preferences.save();
                }
                catch (IOException ex) {
                    try {
                        MessageHandler.warning((String)"Failed to save preferences.", (Throwable)ex);
                    }
                    catch (CancelException cancelException) {}
                }
            }
        }
    }

    private class MoveToBackAction
    extends AbstractAction {
        public MoveToBackAction() {
            super("Send to Back");
            this.putValue("tooltip", "Send to back of like objects");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 66);
        }

        public void actionPerformed(ActionEvent e) {
            HashSet namedObjSet;
            final NamedObj container = (NamedObj)BasicGraphFrame.this._getGraphModel().getRoot();
            final List elements = container.sortContainedObjects((Collection)(namedObjSet = BasicGraphFrame.this._getSelectionSet()));
            if (BasicGraphFrame.this._checkForImplied(elements)) {
                return;
            }
            ChangeRequest request = new ChangeRequest(container, "Send to back"){

                protected void _execute() throws IllegalActionException {
                    MoveAction.move(elements, MoveAction.TO_FIRST, container);
                }
            };
            container.requestChange(request);
        }
    }

    private class MoveToFrontAction
    extends AbstractAction {
        public MoveToFrontAction() {
            super("Bring to Front");
            this.putValue("tooltip", "Bring to front of like objects");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 70);
        }

        public void actionPerformed(ActionEvent e) {
            HashSet namedObjSet;
            final NamedObj container = (NamedObj)BasicGraphFrame.this._getGraphModel().getRoot();
            final List elements = container.sortContainedObjects((Collection)(namedObjSet = BasicGraphFrame.this._getSelectionSet()));
            if (BasicGraphFrame.this._checkForImplied(elements)) {
                return;
            }
            ChangeRequest request = new ChangeRequest(container, "Bring to front"){

                protected void _execute() throws IllegalActionException {
                    MoveAction.move(elements, MoveAction.TO_LAST, container);
                }
            };
            container.requestChange(request);
        }
    }

    private class OpenLibraryMenuItemFactory
    implements MenuItemFactory {
        private OpenLibraryMenuItemFactory() {
        }

        public JMenuItem create(JContextMenu menu, final NamedObj object) {
            AbstractAction action = new AbstractAction("Open for Editing"){

                public void actionPerformed(ActionEvent e) {
                    try {
                        BasicGraphFrame.this.getConfiguration().openModel(object);
                    }
                    catch (KernelException ex) {
                        MessageHandler.error((String)"Open failed.", (Throwable)ex);
                    }
                }
            };
            action.putValue("tooltip", "Open library for editing.");
            action.putValue("MnemonicKey", 79);
            return menu.add((Action)action, (String)action.getValue("Name"));
        }
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super("Paste");
            this.putValue("tooltip", "Paste the contents of the clipboard.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 80);
        }

        public void actionPerformed(ActionEvent e) {
            BasicGraphFrame.this.paste();
        }
    }

    private class PtolemyLayout
    extends LevelLayout {
        public PtolemyLayout(LayoutTarget target) {
            super(target);
        }

        protected Object copyComposite(Object origComposite) {
            LayoutTarget target = this.getLayoutTarget();
            GraphModel model = target.getGraphModel();
            BasicGraphModel local = this.getLocalGraphModel();
            CompositeNode copyComposite = local.createComposite(null);
            HashMap map = new HashMap();
            Iterator i = model.nodes(origComposite);
            while (i.hasNext()) {
                Object origNode = i.next();
                if (!target.isNodeVisible(origNode)) continue;
                Rectangle2D r = target.getBounds(origNode);
                LevelLayout.LevelInfo inf = new LevelLayout.LevelInfo();
                inf.origNode = origNode;
                inf.x = r.getX();
                inf.y = r.getY();
                inf.width = r.getWidth();
                inf.height = r.getHeight();
                Node copyNode = local.createNode((Object)inf);
                local.addNode((Object)this, (Object)copyNode, (Object)copyComposite);
                map.put(origNode, copyNode);
            }
            i = GraphUtilities.partiallyContainedEdges((Object)origComposite, (GraphModel)model);
            while (i.hasNext()) {
                double normal;
                Object temp;
                int direction;
                Site site;
                Terminal terminal;
                Object origEdge = i.next();
                Object origTail = model.getTail(origEdge);
                Object origHead = model.getHead(origEdge);
                if (origHead == null || origTail == null) continue;
                Figure tailFigure = (Figure)target.getVisualObject(origTail);
                Figure headFigure = (Figure)target.getVisualObject(origHead);
                if (tailFigure instanceof Terminal) {
                    double normal2;
                    terminal = (Terminal)tailFigure;
                    site = terminal.getConnectSite();
                    if (site instanceof FixedNormalSite && (direction = CanvasUtilities.getDirection((double)(normal2 = site.getNormal()))) == 7) {
                        temp = origTail;
                        origTail = origHead;
                        origHead = temp;
                    }
                } else if (headFigure instanceof Terminal && (site = (terminal = (Terminal)headFigure).getConnectSite()) instanceof FixedNormalSite && (direction = CanvasUtilities.getDirection((double)(normal = site.getNormal()))) == 3) {
                    temp = origTail;
                    origTail = origHead;
                    origHead = temp;
                }
                origTail = this._getParentInGraph(model, origComposite, origTail);
                origHead = this._getParentInGraph(model, origComposite, origHead);
                Object copyTail = map.get(origTail);
                Object copyHead = map.get(origHead);
                if (copyHead == null || copyTail == null) continue;
                Edge copyEdge = local.createEdge(origEdge);
                local.setEdgeTail((Object)this, (Object)copyEdge, copyTail);
                local.setEdgeHead((Object)this, (Object)copyEdge, copyHead);
            }
            return copyComposite;
        }

        private Object _getParentInGraph(GraphModel model, Object graph, Object node) {
            while (node != null && !model.containsNode(graph, node)) {
                Object parent = model.getParent(node);
                node = model.isNode(parent) ? parent : null;
            }
            return node;
        }
    }

    private class PtolemyLayoutTarget
    extends BasicLayoutTarget {
        public PtolemyLayoutTarget(GraphController controller) {
            super(controller);
        }

        public Rectangle2D getViewport(Object composite) {
            if (composite == this.getRootGraph()) {
                Rectangle2D bounds = BasicGraphFrame.this.getVisibleCanvasRectangle();
                double width = bounds.getWidth();
                double height = bounds.getHeight();
                double borderPercentage = (1.0 - this.getLayoutPercentage()) / 2.0;
                double x = borderPercentage * width + bounds.getX();
                double y = borderPercentage * height + bounds.getY();
                double w = this.getLayoutPercentage() * width;
                double h = this.getLayoutPercentage() * height;
                return new Rectangle2D.Double(x, y, w, h);
            }
            return super.getViewport(composite);
        }

        public void translate(Object node, double dx, double dy) {
            super.translate(node, dx, dy);
            if (node instanceof Locatable) {
                double[] location = ((Locatable)node).getLocation();
                if (location == null) {
                    location = new double[2];
                    Figure figure = this.getController().getFigure(node);
                    location[0] = figure.getBounds().getCenterX();
                    location[1] = figure.getBounds().getCenterY();
                } else {
                    location[0] = location[0] + dx;
                    location[1] = location[1] + dy;
                }
                try {
                    ((Locatable)node).setLocation(location);
                }
                catch (IllegalActionException ex) {
                    throw new InternalErrorException(ex.getMessage());
                }
            }
        }
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.putValue("tooltip", "Redo the last change undone.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 82);
        }

        public void actionPerformed(ActionEvent e) {
            BasicGraphFrame.this.redo();
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.putValue("tooltip", "Undo the last change.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 85);
        }

        public void actionPerformed(ActionEvent e) {
            BasicGraphFrame.this.undo();
        }
    }

    public class ZoomFitAction
    extends AbstractAction {
        public ZoomFitAction(String description) {
            super(description);
            GUIUtilities.addIcons((Action)this, (String[][])new String[][]{{"/ptolemy/vergil/basic/img/zoomfit.gif", "LargeIcon"}, {"/ptolemy/vergil/basic/img/zoomfit_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/basic/img/zoomfit_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/basic/img/zoomfit_on.gif", "selectedIcon"}});
            this.putValue("tooltip", String.valueOf(description) + " (Ctrl+Shift+-)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
            this.putValue("MnemonicKey", 70);
        }

        public void actionPerformed(ActionEvent e) {
            BasicGraphFrame.this.zoomFit();
        }
    }

    public class ZoomInAction
    extends AbstractAction {
        public ZoomInAction(String description) {
            super(description);
            GUIUtilities.addIcons((Action)this, (String[][])new String[][]{{"/ptolemy/vergil/basic/img/zoomin.gif", "LargeIcon"}, {"/ptolemy/vergil/basic/img/zoomin_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/basic/img/zoomin_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/basic/img/zoomin_on.gif", "selectedIcon"}});
            this.putValue("tooltip", String.valueOf(description) + " (Ctrl+Shift+=)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
            this.putValue("MnemonicKey", 90);
        }

        public void actionPerformed(ActionEvent e) {
            BasicGraphFrame.this.zoom(1.25);
        }
    }

    public class ZoomOutAction
    extends AbstractAction {
        public ZoomOutAction(String description) {
            super(description);
            GUIUtilities.addIcons((Action)this, (String[][])new String[][]{{"/ptolemy/vergil/basic/img/zoomout.gif", "LargeIcon"}, {"/ptolemy/vergil/basic/img/zoomout_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/basic/img/zoomout_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/basic/img/zoomout_on.gif", "selectedIcon"}});
            this.putValue("tooltip", String.valueOf(description) + " (Ctrl+-)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 85);
        }

        public void actionPerformed(ActionEvent e) {
            BasicGraphFrame.this.zoom(0.8);
        }
    }

    public class ZoomResetAction
    extends AbstractAction {
        public ZoomResetAction(String description) {
            super(description);
            GUIUtilities.addIcons((Action)this, (String[][])new String[][]{{"/ptolemy/vergil/basic/img/zoomreset.gif", "LargeIcon"}, {"/ptolemy/vergil/basic/img/zoomreset_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/basic/img/zoomreset_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/basic/img/zoomreset_on.gif", "selectedIcon"}});
            this.putValue("tooltip", String.valueOf(description) + " (Ctrl+M)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 77);
        }

        public void actionPerformed(ActionEvent e) {
            BasicGraphFrame.this.zoomReset();
        }
    }
}

