/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor.lib;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.lib.hoc.ModelReference;
import ptolemy.data.expr.StringParameter;
import ptolemy.gui.Top;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.basic.ExtendedGraphFrame;

public class VisualModelReference
extends ModelReference {
    public StringParameter openOnFiring;
    public StringParameter closeOnPostfire;
    private static int _DO_NOT_OPEN = 0;
    private static int _OPEN_IN_VERGIL = 1;
    private static int _OPEN_IN_VERGIL_FULL_SCREEN = 2;
    private transient int _openOnFiringValue = _DO_NOT_OPEN;
    private static int _DO_NOTHING = 0;
    private static int _CLOSE_VERGIL_GRAPH = 1;
    private transient int _closeOnPostfireValue = _DO_NOTHING;
    private Exception _exception = null;
    private Tableau _tableau;

    public VisualModelReference(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.openOnFiring = new StringParameter((NamedObj)this, "openOnFiring");
        this.openOnFiring.setExpression("do not open");
        this.openOnFiring.addChoice("doNotOpen");
        this.openOnFiring.addChoice("open in Vergil");
        this.openOnFiring.addChoice("open in Vergil (full screen)");
        this.closeOnPostfire = new StringParameter((NamedObj)this, "closeOnPostfire");
        this.closeOnPostfire.setExpression("do nothing");
        this.closeOnPostfire.addChoice("do nothing");
        this.closeOnPostfire.addChoice("close Vergil graph");
        new LookInside((NamedObj)this, "_lookInsideOverride");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.openOnFiring) {
            String openOnFiringValue = this.openOnFiring.stringValue();
            if (openOnFiringValue.equals("do not open")) {
                this._openOnFiringValue = _DO_NOT_OPEN;
                return;
            } else if (openOnFiringValue.equals("open in Vergil")) {
                this._openOnFiringValue = _OPEN_IN_VERGIL;
                return;
            } else {
                if (!openOnFiringValue.equals("open in Vergil (full screen)")) throw new IllegalActionException((Nameable)this, "Unrecognized option for openOnFiring: " + openOnFiringValue);
                this._openOnFiringValue = _OPEN_IN_VERGIL_FULL_SCREEN;
            }
            return;
        } else if (attribute == this.closeOnPostfire) {
            String closeOnPostfireValue = this.closeOnPostfire.stringValue();
            if (closeOnPostfireValue.equals("do nothing")) {
                this._closeOnPostfireValue = _DO_NOTHING;
                return;
            } else {
                if (!closeOnPostfireValue.equals("close Vergil graph")) throw new IllegalActionException((Nameable)this, "Unrecognized option for closeOnPostfire: " + closeOnPostfireValue);
                this._closeOnPostfireValue = _CLOSE_VERGIL_GRAPH;
            }
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        VisualModelReference newActor = (VisualModelReference)((Object)super.clone(workspace));
        newActor._tableau = null;
        return newActor;
    }

    public void fire() throws IllegalActionException {
        block8: {
            NamedObj toplevel;
            Effigy myEffigy;
            this._readInputsAndValidateSettables();
            this._alreadyReadInputs = true;
            if (this._model instanceof CompositeActor && (myEffigy = Configuration.findEffigy(toplevel = this.toplevel())) != null) {
                try {
                    if (this._openOnFiringValue == _OPEN_IN_VERGIL || this._openOnFiringValue == _OPEN_IN_VERGIL_FULL_SCREEN) {
                        Runnable doOpen = new Runnable(){

                            public void run() {
                                Configuration configuration = (Configuration)myEffigy.toplevel();
                                if (VisualModelReference.this._debugging) {
                                    VisualModelReference.this._debug("** Using the configuration to open a tableau.");
                                }
                                try {
                                    VisualModelReference.this._exception = null;
                                    VisualModelReference.this._tableau = configuration.openModel(VisualModelReference.this._model, myEffigy);
                                    VisualModelReference.this._tableau.setMaster(true);
                                }
                                catch (KernelException e) {
                                    VisualModelReference.this._exception = (Exception)((Object)e);
                                }
                                VisualModelReference.this._tableau.show();
                                JFrame frame = VisualModelReference.this._tableau.getFrame();
                                if (frame != null) {
                                    if (VisualModelReference.this._openOnFiringValue == _OPEN_IN_VERGIL_FULL_SCREEN && frame instanceof ExtendedGraphFrame) {
                                        ((ExtendedGraphFrame)frame).fullScreen();
                                    }
                                    frame.toFront();
                                }
                            }
                        };
                        try {
                            SwingUtilities.invokeAndWait(doOpen);
                        }
                        catch (Exception ex) {
                            throw new IllegalActionException((Nameable)this, null, (Throwable)ex, "Open failed.");
                        }
                        if (this._exception != null) {
                            throw new IllegalActionException((Nameable)this, null, (Throwable)this._exception, "Failed to open.");
                        }
                        break block8;
                    }
                    PtolemyEffigy newEffigy = new PtolemyEffigy(myEffigy, myEffigy.uniqueName(this._model.getName()));
                    newEffigy.setModel(this._model);
                    newEffigy.setModifiable(false);
                    if (this._debugging) {
                        this._debug("** Created new effigy for referenced model.");
                    }
                }
                catch (NameDuplicationException ex) {
                    throw new InternalErrorException((Throwable)ex);
                }
            }
        }
        super.fire();
    }

    public boolean postfire() throws IllegalActionException {
        boolean result = super.postfire();
        if (this._tableau != null) {
            final JFrame frame = this._tableau.getFrame();
            if (this._closeOnPostfireValue == _CLOSE_VERGIL_GRAPH) {
                if (this._debugging) {
                    this._debug("** Closing Vergil graph.");
                }
                if (frame instanceof TableauFrame) {
                    Runnable doClose = new Runnable(){

                        public void run() {
                            if (frame instanceof ExtendedGraphFrame) {
                                ((ExtendedGraphFrame)frame).cancelFullScreen();
                            }
                            ((TableauFrame)frame).close();
                        }
                    };
                    Top.deferIfNecessary(doClose);
                } else if (frame != null) {
                    Runnable doClose = new Runnable(){

                        public void run() {
                            if (frame instanceof ExtendedGraphFrame) {
                                ((ExtendedGraphFrame)frame).cancelFullScreen();
                            }
                            frame.setVisible(true);
                        }
                    };
                    Top.deferIfNecessary(doClose);
                }
            }
        }
        return result;
    }

    public class LookInside
    extends TableauFactory {
        public LookInside(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (VisualModelReference.this._model == null) {
                throw new IllegalActionException((Nameable)VisualModelReference.this, "No model referenced.");
            }
            Configuration configuration = (Configuration)effigy.toplevel();
            return configuration.openInstance(VisualModelReference.this._model, effigy);
        }
    }
}

