/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import ptolemy.util.ExecuteCommands;

public class FindPackages {
    public static String findPackages(File ptII, ExecuteCommands executeCommands) {
        StringBuffer results = new StringBuffer();
        HashSet directoriesSeen = new HashSet();
        HashSet classFilesSeen = new HashSet();
        String ptIIPath = ptII.getPath().replace('\\', '/');
        if (executeCommands == null) {
            System.out.println("Searching for .class files in " + ptIIPath);
        } else {
            executeCommands.stdout("Searching for .class files in " + ptIIPath);
        }
        FindPackages._getDirectories(ptII, directoriesSeen, classFilesSeen);
        HashSet<String> packages = new HashSet<String>();
        for (File[] files : classFilesSeen) {
            int i = 0;
            while (i < files.length) {
                String packageName;
                String fullPath = files[i].toString().replace('\\', '/');
                String shortPath = fullPath.substring(0, files[i].toString().length() - 6);
                if (shortPath.startsWith(ptIIPath)) {
                    shortPath = shortPath.substring(ptIIPath.length() + 1);
                }
                if (!packages.contains(packageName = (shortPath = shortPath.substring(0, shortPath.lastIndexOf(47))).replace('/', '.'))) {
                    packages.add(packageName);
                    results.append(" " + packageName);
                }
                ++i;
            }
        }
        if (executeCommands == null) {
            System.out.println(results.toString());
        } else {
            executeCommands.stdout(results.toString());
        }
        return results.toString();
    }

    public static void main(String[] args) {
        FindPackages.findPackages(new File(args[0]), null);
    }

    private static void _getDirectories(File directory, Set directoriesSeen, Set classFilesSeen) {
        File[] directories = directory.listFiles(new DirectoryFileFilter());
        int i = 0;
        while (i < directories.length) {
            if (!(directoriesSeen.contains(directories[i]) || directories[i].getName().endsWith("adm") || directories[i].getName().endsWith("CVS") || directories[i].getName().endsWith("vendors"))) {
                File[] classFiles = directories[i].listFiles(new ClassFileFilter());
                classFilesSeen.add(classFiles);
                directoriesSeen.add(directories[i]);
                FindPackages._getDirectories(directories[i], directoriesSeen, classFilesSeen);
            }
            ++i;
        }
    }

    private static class ClassFileFilter
    implements FileFilter {
        private ClassFileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".class");
        }
    }

    private static class DirectoryFileFilter
    implements FileFilter {
        private DirectoryFileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

