/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.JCanvas;
import diva.canvas.toolbox.LabelFigure;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.GraphViewEvent;
import diva.graph.JGraph;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.HTMLViewer;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.InstantiableNamedObj;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Instantiable;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.ActorEditorGraphController;
import ptolemy.vergil.actor.ActorGraphModel;
import ptolemy.vergil.actor.DocBuilderTableau;
import ptolemy.vergil.actor.DocEffigy;
import ptolemy.vergil.actor.DocManager;
import ptolemy.vergil.actor.DocTableau;
import ptolemy.vergil.basic.BasicGraphFrame;
import ptolemy.vergil.basic.DocAttribute;

public class DocViewer
extends HTMLViewer {
    private String _applicationName = "";
    private static int _AUTHOR_WINDOW_WIDTH = 350;
    private Configuration _configuration;
    private static int _BOTTOM_HEIGHT = 150;
    private static int _DESCRIPTION_WIDTH = 500;
    private Font _font = new Font("SansSerif", 0, 14);
    private GraphPane _graphPane;
    private static String _HTML_HEADER = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title>Ptolemy II Documentation</title><STYLE TYPE=\"text/css\">\n<!--\nh1, h2, h3, td, tr, body, p {font-family: Arial, Helvetica, sans-serif;}\n-->\n</STYLE></head><body>";
    private static String _HTML_TAIL = "</body></html>";
    private CompositeEntity _iconContainer;
    private static int _ICON_WINDOW_HEIGHT = 200;
    private static int _ICON_WINDOW_WIDTH = 200;
    private JGraph _jgraph;
    private static int _MAIN_WINDOW_HEIGHT = 250;
    private static int _MAIN_WINDOW_WIDTH = 700;
    private static int _PADDING = 10;
    private static int _SEE_ALSO_WIDTH = 350;
    private static int _SPACING = 5;
    private NamedObj _target;
    private static String _tr = "<tr valign=top>\n";
    private static String _tre = "</tr>\n";
    private static String _td = "<td>";
    private static String _td20 = "<td width=20%>";
    private static String _tdColSpan = "<td colspan=2>";
    private static String _tde = "</td>";
    private static String _tableOpening = "<table cellspacing=2 cellpadding=2>\n";
    private static String _tableClosing = "</table>";

    public DocViewer(NamedObj target, Configuration configuration) {
        try {
            this._init(target, configuration, target.getClassName(), null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalErrorException("Unexpected exception");
        }
    }

    public DocViewer(String className, Configuration configuration) throws ClassNotFoundException {
        this._init(null, configuration, className, null);
    }

    public DocViewer(URL url, Configuration configuration) {
        try {
            this._init(null, configuration, null, url);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalErrorException("Unexpected exception");
        }
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("#parentClass")) {
            try {
                NamedObj parent = (NamedObj)((Instantiable)this._target).getParent();
                List docAttributes = parent.attributeList(DocAttribute.class);
                DocAttribute attribute = (DocAttribute)((Object)docAttributes.get(docAttributes.size() - 1));
                Effigy effigy = this.getEffigy();
                DocEffigy newEffigy = new DocEffigy((CompositeEntity)effigy.getContainer(), effigy.getContainer().uniqueName("parentClass"));
                newEffigy.setDocAttribute(attribute);
                DocTableau tableau = new DocTableau(newEffigy, "docTableau");
                tableau.show();
            }
            catch (Exception e) {
                MessageHandler.error((String)"Error following hyperlink", (Throwable)e);
            }
        } else {
            super.hyperlinkUpdate(event);
        }
    }

    protected void _addMainPane() {
    }

    protected void _help() {
        try {
            Configuration configuration = this.getConfiguration();
            FileParameter helpAttribute = (FileParameter)configuration.getAttribute("_helpDocViewer", FileParameter.class);
            URL doc = helpAttribute != null ? helpAttribute.asURL() : this.getClass().getClassLoader().getResource(this.helpFile);
            configuration.openModel(null, doc, doc.toExternalForm());
        }
        catch (Exception exception) {
            super._help();
        }
    }

    protected void _setScrollerSize(int width, int height) {
    }

    private void _adjustIconDisplay(NamedObj sample, CompositeEntity container, final GraphPane graphPane, final JGraph jgraph) throws IllegalActionException, NameDuplicationException {
        if (sample instanceof Entity) {
            for (Port port : ((Entity)sample).portList()) {
                SingletonParameter show = new SingletonParameter((NamedObj)port, "_showName");
                show.setExpression("true");
            }
        }
        StringParameter show = new StringParameter((NamedObj)container, "_showParameters");
        show.setExpression("All");
        Runnable defer = new Runnable(){

            public void run() {
                Rectangle2D bounds = graphPane.getForegroundLayer().getLayerBounds();
                if (!bounds.isEmpty()) {
                    Dimension size = jgraph.getSize();
                    Rectangle2D.Double viewSize = new Rectangle2D.Double(_PADDING, _PADDING, size.getWidth() - (double)(2 * _PADDING), size.getHeight() - (double)(2 * _PADDING));
                    AffineTransform newTransform = CanvasUtilities.computeFitTransform((RectangularShape)bounds, (RectangularShape)viewSize);
                    JCanvas canvas = graphPane.getCanvas();
                    canvas.getCanvasPane().setTransform(newTransform);
                }
            }
        };
        SwingUtilities.invokeLater(defer);
    }

    private String _colorizeRating(String rating) {
        String color = "#FFFFFF";
        if (rating.startsWith("Red")) {
            color = "#FF0000";
        } else if (rating.startsWith("Yellow")) {
            color = "#AAAA00";
        } else if (rating.startsWith("Green")) {
            color = "#00FF00";
        } else if (rating.startsWith("Blue")) {
            color = "#0000FF";
        }
        return "<td><font color=\"" + color + "\">" + rating + "</font></td>";
    }

    private String _getParameterEntries(NamedObj target, DocManager manager) {
        Configuration config = this.getConfiguration();
        Iterator itt = config.attributeList(StringAttribute.class).iterator();
        Vector<String> exclusions = new Vector<String>();
        while (itt.hasNext()) {
            NamedObj att = (NamedObj)itt.next();
            if (att.getName().indexOf("docViewerExclude") == -1) continue;
            String value = ((StringAttribute)att).getExpression();
            exclusions.addElement(value);
        }
        StringBuffer parameters = new StringBuffer();
        parameters.append(_tr);
        parameters.append(_tdColSpan);
        parameters.append("<h2>Parameters</h2>");
        parameters.append(_tde);
        parameters.append(_tre);
        boolean foundOne = false;
        for (Settable parameter : target.attributeList(Settable.class)) {
            if (parameter instanceof PortParameter) continue;
            String parameterName = parameter.getName();
            int i = 0;
            while (i < exclusions.size()) {
                String exclusion = (String)exclusions.elementAt(i);
                String type = exclusion.substring(0, exclusion.indexOf(":"));
                exclusion = exclusion.substring(exclusion.indexOf(":") + 1, exclusion.length());
                if (type.equals("contains")) {
                    if (parameterName.indexOf(exclusion) != -1) {
                        parameter.setVisibility(Settable.NONE);
                    }
                } else if (type.equals("exact") && parameterName.equals(exclusion)) {
                    parameter.setVisibility(Settable.NONE);
                }
                ++i;
            }
            String doc = manager.getPropertyDoc(parameter.getName());
            if (doc == null) {
                String nextDoc;
                doc = "No description.";
                DocManager nextTier = manager.getNextTier();
                if (nextTier != null && (nextDoc = nextTier.getPropertyDoc(parameter.getName())) != null) {
                    doc = nextDoc;
                }
            }
            if (parameter.getVisibility() != Settable.FULL) continue;
            parameters.append(_tr);
            parameters.append(_td);
            parameters.append("<i>" + parameter.getDisplayName() + "</i>");
            parameters.append(_tde);
            parameters.append(_td);
            parameters.append(doc);
            parameters.append(_tde);
            parameters.append(_tre);
            foundOne = true;
        }
        if (foundOne) {
            return parameters.toString();
        }
        return null;
    }

    private String _getPortEntries(NamedObj target, DocManager manager) {
        if (!(target instanceof Entity)) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean foundOne = false;
        boolean foundInput = false;
        boolean foundOutput = false;
        boolean foundInputOutput = false;
        boolean foundNeither = false;
        StringBuffer inputPorts = new StringBuffer();
        StringBuffer outputPorts = new StringBuffer();
        StringBuffer inputOutputPorts = new StringBuffer();
        StringBuffer neitherPorts = new StringBuffer();
        for (Port port : ((Entity)target).portList()) {
            if (port instanceof ParameterPort) continue;
            String portName = "<i>" + port.getDisplayName() + "</i>";
            String doc = manager.getPortDoc(port.getName());
            if (doc == null) {
                String nextDoc;
                doc = "No port description.";
                DocManager nextTier = manager.getNextTier();
                if (nextTier != null && (nextDoc = nextTier.getPortDoc(port.getName())) != null) {
                    doc = nextDoc;
                }
            }
            if (port instanceof IOPort) {
                if (((IOPort)port).isInput() && !((IOPort)port).isOutput()) {
                    inputPorts.append(_tr);
                    inputPorts.append(_td);
                    inputPorts.append(portName);
                    inputPorts.append(_tde);
                    inputPorts.append(_td);
                    inputPorts.append(doc);
                    inputPorts.append(_tde);
                    inputPorts.append(_tre);
                    foundInput = true;
                    foundOne = true;
                    continue;
                }
                if (((IOPort)port).isOutput() && !((IOPort)port).isInput()) {
                    outputPorts.append(_tr);
                    outputPorts.append(_td);
                    outputPorts.append(portName);
                    outputPorts.append(_tde);
                    outputPorts.append(_td);
                    outputPorts.append(doc);
                    outputPorts.append(_tde);
                    outputPorts.append(_tre);
                    foundOutput = true;
                    foundOne = true;
                    continue;
                }
                if (((IOPort)port).isOutput() && ((IOPort)port).isInput()) {
                    inputOutputPorts.append(_tr);
                    inputOutputPorts.append(_td);
                    inputOutputPorts.append(portName);
                    inputOutputPorts.append(_tde);
                    inputOutputPorts.append(_td);
                    inputOutputPorts.append(doc);
                    inputOutputPorts.append(_tde);
                    inputOutputPorts.append(_tre);
                    foundInputOutput = true;
                    foundOne = true;
                    continue;
                }
                neitherPorts.append(_tr);
                neitherPorts.append(_td);
                neitherPorts.append(portName);
                neitherPorts.append(_tde);
                neitherPorts.append(_td);
                neitherPorts.append(doc);
                neitherPorts.append(_tde);
                neitherPorts.append(_tre);
                foundNeither = true;
                foundOne = true;
                continue;
            }
            neitherPorts.append(_tr);
            neitherPorts.append(_td);
            neitherPorts.append(portName);
            neitherPorts.append(_tde);
            neitherPorts.append(_td);
            neitherPorts.append(doc);
            neitherPorts.append(_tde);
            neitherPorts.append(_tre);
            foundNeither = true;
            foundOne = true;
        }
        if (foundInput) {
            result.append(_tr);
            result.append(_tdColSpan);
            result.append("<h2>Input Ports</h2>");
            result.append(_tde);
            result.append(_tre);
            result.append(inputPorts);
        }
        if (foundOutput) {
            result.append(_tr);
            result.append(_tdColSpan);
            result.append("<h2>Output Ports</h2>");
            result.append(_tde);
            result.append(_tre);
            result.append(outputPorts);
        }
        if (foundInputOutput) {
            result.append(_tr);
            result.append(_tdColSpan);
            result.append("<h2>Input/Output Ports</h2>");
            result.append(_tde);
            result.append(_tre);
            result.append(inputOutputPorts);
        }
        if (foundNeither) {
            result.append(_tr);
            result.append(_tdColSpan);
            result.append("<h2>Ports (Neither Input nor Output)</h2>");
            result.append(_tde);
            result.append(_tre);
            result.append(neitherPorts);
        }
        if (foundOne) {
            return result.toString();
        }
        return null;
    }

    private String _getPortParameterEntries(NamedObj target, DocManager manager) {
        StringBuffer parameters = new StringBuffer();
        parameters.append(_tr);
        parameters.append(_tdColSpan);
        parameters.append("<h2>Port-Parameters</h2>");
        parameters.append(_tde);
        parameters.append(_tre);
        boolean foundOne = false;
        for (Settable parameter : target.attributeList(PortParameter.class)) {
            String doc = manager.getPropertyDoc(parameter.getName());
            if (doc == null) {
                String nextDoc;
                doc = "No description.";
                DocManager nextTier = manager.getNextTier();
                if (nextTier != null && (nextDoc = nextTier.getPropertyDoc(parameter.getName())) != null) {
                    doc = nextDoc;
                }
            }
            if (parameter.getVisibility() != Settable.FULL) continue;
            parameters.append(_tr);
            parameters.append(_td);
            parameters.append("<i>" + parameter.getDisplayName() + "</i>");
            parameters.append(_tde);
            parameters.append(_td);
            parameters.append(doc);
            parameters.append(_tde);
            parameters.append(_tre);
            foundOne = true;
        }
        if (foundOne) {
            return parameters.toString();
        }
        return null;
    }

    private void _includeClassDefinitions(NamedObj target, StringBuffer buffer) {
        NamedObj parent;
        if (target instanceof Instantiable && (parent = (NamedObj)((Instantiable)target).getParent()) != null && target.toplevel().deepContains(parent)) {
            NamedObj parentsParent;
            if (parent instanceof Instantiable && (parentsParent = (NamedObj)((Instantiable)parent).getParent()) != null && parent.toplevel().deepContains(parentsParent)) {
                this._includeClassDefinitions(parent, buffer);
            }
            buffer.append(parent.exportMoML());
            buffer.append("<");
            buffer.append(parent.getElementName());
            buffer.append(" name=\"");
            buffer.append(parent.getName());
            buffer.append("\"><property name=\"_hide\" class=\"ptolemy.data.expr.ExpertParameter\" value=\"true\"/></");
            buffer.append(parent.getElementName());
            buffer.append(">");
        }
    }

    private void _init(final NamedObj target, Configuration configuration, String className, URL url) throws ClassNotFoundException {
        String rating;
        String since;
        String nextTierAuthor;
        DocManager nextTier;
        DocManager manager;
        this._configuration = configuration;
        this._target = target;
        this.helpFile = "ptolemy/vergil/actor/docViewerHelp.htm";
        try {
            StringAttribute applicationNameAttribute = (StringAttribute)configuration.getAttribute("_applicationName", StringAttribute.class);
            if (applicationNameAttribute != null) {
                this._applicationName = applicationNameAttribute.getExpression();
            }
        }
        catch (Throwable throwable) {}
        if (target != null) {
            manager = new DocManager(this._configuration, target);
        } else if (className != null) {
            manager = new DocManager(this._configuration, Class.forName(className));
        } else if (url != null) {
            manager = new DocManager(this._configuration, url);
        } else {
            throw new InternalErrorException("Need to specify one of target, className, or url!");
        }
        className = manager.getClassName();
        int lastPeriod = className.lastIndexOf(".");
        final String rootName = lastPeriod >= 0 ? className.substring(lastPeriod + 1) : className;
        if (url != null) {
            this.setBase(url);
        } else {
            String javaDocDirectory = "doc.codeDoc" + this._applicationName + "." + className;
            int lastDot = javaDocDirectory.lastIndexOf(".");
            javaDocDirectory = javaDocDirectory.substring(0, lastDot);
            URL base = this.getClass().getClassLoader().getResource(String.valueOf(javaDocDirectory.replace('.', '/')) + "/");
            this.setBase(base);
        }
        Container contentPane = this.getContentPane();
        Dimension horizontalSpace = new Dimension(_SPACING, 0);
        Dimension verticalSpace = new Dimension(0, _SPACING);
        contentPane.add(Box.createRigidArea(verticalSpace));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        contentPane.add(titlePanel);
        String title = className;
        title = target instanceof InstantiableNamedObj && ((InstantiableNamedObj)target).isClassDefinition() ? String.valueOf(target.getName()) + "&nbsp; &nbsp; &nbsp; (" + target.getFullName() + ")" : (manager.isInstanceDoc() ? String.valueOf(target.getName()) + "&nbsp; &nbsp; &nbsp; (Instance of " + className + ")" : String.valueOf(rootName) + "&nbsp; &nbsp; &nbsp; (" + className + ")");
        JEditorPane titlePane = new JEditorPane();
        titlePane.setContentType("text/html");
        titlePane.setEditable(false);
        titlePane.setText(String.valueOf(_HTML_HEADER) + "<H2>&nbsp; " + title + "</H2>" + _HTML_TAIL);
        titlePane.getCaret().setDot(0);
        Dimension titleSize = new Dimension(_DESCRIPTION_WIDTH + _ICON_WINDOW_WIDTH + _SPACING, 40);
        titlePane.setPreferredSize(titleSize);
        titlePane.setSize(titleSize);
        titlePane.setBorder(BorderFactory.createEtchedBorder(0));
        titlePanel.add(Box.createRigidArea(horizontalSpace));
        titlePanel.add(titlePane);
        titlePanel.add(Box.createRigidArea(horizontalSpace));
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new BoxLayout(descriptionPanel, 0));
        contentPane.add(Box.createRigidArea(verticalSpace));
        contentPane.add(descriptionPanel);
        descriptionPanel.add(Box.createRigidArea(horizontalSpace));
        this._iconContainer = new CompositeEntity();
        final ActorEditorGraphController controller = new ActorEditorGraphController();
        controller.setConfiguration(this.getConfiguration());
        ActorGraphModel graphModel = new ActorGraphModel((NamedObj)this._iconContainer){

            public void changeFailed(ChangeRequest change, Exception exception) {
                if (DocViewer.this._graphPane == null) {
                    super.changeFailed(change, exception);
                    return;
                }
                LabelFigure newFigure = new LabelFigure("No icon available", DocViewer.this._font);
                DocViewer.this._graphPane.getForegroundLayer().add((Figure)newFigure);
                CanvasUtilities.translateTo((Figure)newFigure, (double)100.0, (double)100.0);
                controller.dispatch(new GraphViewEvent((Object)this, 20, (Object)newFigure));
            }
        };
        this._graphPane = new GraphPane((GraphController)controller, (GraphModel)graphModel);
        this._jgraph = new JGraph(this._graphPane);
        this._jgraph.setBorder(BorderFactory.createEtchedBorder(0));
        this._jgraph.setMinimumSize(new Dimension(_ICON_WINDOW_WIDTH, _ICON_WINDOW_HEIGHT));
        this._jgraph.setMaximumSize(new Dimension(_ICON_WINDOW_WIDTH, _ICON_WINDOW_HEIGHT));
        this._jgraph.setPreferredSize(new Dimension(_ICON_WINDOW_WIDTH, _ICON_WINDOW_HEIGHT));
        this._jgraph.setSize(_ICON_WINDOW_WIDTH, _ICON_WINDOW_HEIGHT);
        this._jgraph.setBackground(BasicGraphFrame.BACKGROUND_COLOR);
        descriptionPanel.add((Component)this._jgraph);
        descriptionPanel.add(Box.createRigidArea(horizontalSpace));
        JEditorPane descriptionPane = new JEditorPane();
        descriptionPane.addHyperlinkListener(this);
        descriptionPane.setContentType("text/html");
        descriptionPane.setEditable(false);
        JScrollPane scroller = new JScrollPane(descriptionPane);
        scroller.setPreferredSize(new Dimension(_DESCRIPTION_WIDTH, _ICON_WINDOW_HEIGHT));
        scroller.setBorder(BorderFactory.createEtchedBorder(0));
        descriptionPanel.add(scroller);
        descriptionPanel.add(Box.createRigidArea(horizontalSpace));
        JPanel middle = new JPanel();
        middle.setLayout(new BoxLayout(middle, 0));
        contentPane.add(Box.createRigidArea(verticalSpace));
        contentPane.add(middle);
        this._scroller = new JScrollPane(this.pane);
        this._scroller.setPreferredSize(new Dimension(_MAIN_WINDOW_WIDTH, _MAIN_WINDOW_HEIGHT));
        this._scroller.setBorder(BorderFactory.createEtchedBorder(0));
        middle.add(Box.createRigidArea(horizontalSpace));
        middle.add(this._scroller);
        middle.add(Box.createRigidArea(horizontalSpace));
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        contentPane.add(Box.createRigidArea(verticalSpace));
        contentPane.add(bottom);
        contentPane.add(Box.createRigidArea(verticalSpace));
        bottom.add(Box.createRigidArea(horizontalSpace));
        JEditorPane authorPane = new JEditorPane();
        authorPane.addHyperlinkListener(this);
        authorPane.setContentType("text/html");
        authorPane.setEditable(false);
        JScrollPane authorScroller = new JScrollPane(authorPane);
        Dimension authorSize = new Dimension(_AUTHOR_WINDOW_WIDTH, _BOTTOM_HEIGHT);
        authorScroller.setPreferredSize(authorSize);
        authorScroller.setSize(authorSize);
        authorScroller.setBorder(BorderFactory.createEtchedBorder(0));
        bottom.add(authorScroller);
        bottom.add(Box.createRigidArea(horizontalSpace));
        JEditorPane seeAlsoPane = new JEditorPane();
        seeAlsoPane.addHyperlinkListener(this);
        seeAlsoPane.setContentType("text/html");
        seeAlsoPane.setEditable(false);
        JScrollPane seeAlsoScroller = new JScrollPane(seeAlsoPane);
        Dimension seeAlsoSize = new Dimension(_SEE_ALSO_WIDTH, _BOTTOM_HEIGHT);
        seeAlsoScroller.setPreferredSize(seeAlsoSize);
        seeAlsoScroller.setSize(seeAlsoSize);
        seeAlsoScroller.setBorder(BorderFactory.createEtchedBorder(0));
        bottom.add(seeAlsoScroller);
        bottom.add(Box.createRigidArea(horizontalSpace));
        StringBuffer html = new StringBuffer();
        html.append(_HTML_HEADER);
        String description = manager.getDescription();
        html.append(description);
        html.append(_HTML_TAIL);
        descriptionPane.setText(html.toString());
        descriptionPane.getCaret().setDot(0);
        String moml = null;
        if (target != null) {
            StringBuffer buffer = new StringBuffer("<group>");
            this._includeClassDefinitions(target, buffer);
            buffer.append(target.exportMoMLPlain());
            buffer.append("<");
            buffer.append(target.getElementName());
            buffer.append(" name=\"");
            buffer.append(target.getName());
            buffer.append("\"><property name=\"_hide\" class=\"ptolemy.data.expr.ExpertParameter\" value=\"false\"/></");
            buffer.append(target.getElementName());
            buffer.append(">");
            buffer.append("</group>");
            moml = buffer.toString();
        } else if (!manager.hadException()) {
            if (manager.isTargetInstantiableAttribute()) {
                moml = "<property name=\"" + rootName + "\" class=\"" + className + "\">" + "<property name=\"_location\" class=\"ptolemy.kernel.util.Location\" value=\"{50, 50}\"/>" + "</property>";
            } else if (manager.isTargetInstantiableEntity()) {
                moml = "<entity name=\"" + rootName + "\" class=\"" + className + "\"/>";
            } else if (manager.isTargetInstantiablePort()) {
                moml = "<port name=\"" + rootName + "\" class=\"" + className + "\">" + "<property name=\"input\"/></port>";
            }
        }
        if (moml != null) {
            MoMLChangeRequest request = new MoMLChangeRequest(this, (NamedObj)this._iconContainer, moml){

                protected void _execute() throws Exception {
                    super._execute();
                    Attribute sample = null;
                    String name = rootName;
                    if (target != null) {
                        name = target.getName();
                    }
                    if (manager.isTargetInstantiableAttribute()) {
                        sample = DocViewer.this._iconContainer.getAttribute(name);
                    } else if (manager.isTargetInstantiableEntity()) {
                        sample = DocViewer.this._iconContainer.getEntity(name);
                    } else if (manager.isTargetInstantiablePort()) {
                        sample = DocViewer.this._iconContainer.getPort(name);
                    }
                    if (sample != null) {
                        DocViewer.this._populatePortsAndParametersTable((NamedObj)sample, manager);
                        DocViewer.this._adjustIconDisplay((NamedObj)sample, DocViewer.this._iconContainer, DocViewer.this._graphPane, DocViewer.this._jgraph);
                    }
                }
            };
            this._iconContainer.requestChange((ChangeRequest)request);
        }
        if (target != null) {
            this._populatePortsAndParametersTable(target, manager);
        }
        StringBuffer info = new StringBuffer();
        info.append(_HTML_HEADER);
        info.append(_tableOpening);
        info.append(_tr);
        info.append(_td20);
        info.append("<i>Author:</i> ");
        info.append(_tde);
        info.append(_td);
        info.append(manager.getAuthor());
        if (manager.isInstanceDoc() && (nextTier = manager.getNextTier()) != null && !(nextTierAuthor = nextTier.getAuthor()).equals("No author given")) {
            info.append(" (<i>Class author:</i> ");
            info.append(nextTierAuthor);
        }
        info.append(_tde);
        info.append(_tre);
        String version = manager.getVersion();
        if (version != null) {
            info.append(_tr);
            info.append(_td20);
            info.append("<i>Version:</i> ");
            info.append(_tde);
            info.append(_td);
            info.append(version);
            info.append(_tde);
            info.append(_tre);
        }
        if ((since = manager.getSince()) != null) {
            info.append(_tr);
            info.append(_td20);
            info.append("<i>Since:</i> ");
            info.append(_tde);
            info.append(_td);
            info.append(since);
            info.append(_tde);
            info.append(_tre);
        }
        if ((rating = manager.getAcceptedRating()) != null) {
            info.append(_tr);
            info.append(_td20);
            info.append("<i>Rating:</i> ");
            info.append(_tde);
            info.append(this._colorizeRating(rating));
            info.append(_tre);
        }
        info.append(_tableClosing);
        info.append(_HTML_TAIL);
        authorPane.setText(info.toString());
        authorPane.getCaret().setDot(0);
        seeAlsoPane.setText(String.valueOf(_HTML_HEADER) + manager.getSeeAlso() + _HTML_TAIL);
        seeAlsoPane.getCaret().setDot(0);
    }

    protected void _addMenus() {
        Effigy tableauContainer;
        super._addMenus();
        Tableau tableau = this.getTableau();
        if (tableau != null && (tableauContainer = (Effigy)tableau.getContainer()) != null) {
            JMenu buildMenu = new JMenu("Build");
            buildMenu.setMnemonic(66);
            this._menubar.add(buildMenu);
            BuildMenuListener buildMenuListener = new BuildMenuListener();
            String name = "Build docs";
            JMenuItem item = new JMenuItem(name);
            item.setActionCommand(name);
            item.setMnemonic(name.charAt(0));
            item.addActionListener(buildMenuListener);
            buildMenu.add(item);
        }
    }

    private void _populatePortsAndParametersTable(NamedObj target, DocManager manager) {
        String portTableEntries;
        String portParameterTableEntries;
        boolean foundOne = false;
        StringBuffer table = new StringBuffer();
        String parameterTableEntries = this._getParameterEntries(target, manager);
        if (parameterTableEntries != null) {
            foundOne = true;
            table.append(parameterTableEntries);
        }
        if ((portParameterTableEntries = this._getPortParameterEntries(target, manager)) != null) {
            foundOne = true;
            table.append(portParameterTableEntries);
        }
        if ((portTableEntries = this._getPortEntries(target, manager)) != null) {
            foundOne = true;
            table.append(portTableEntries);
        }
        StringBuffer info = new StringBuffer();
        info.append(_HTML_HEADER);
        if (foundOne) {
            info.append(_tableOpening);
            info.append(table);
            info.append(_tableClosing);
        } else {
            info.append("No ports or parameters.");
        }
        info.append(_HTML_TAIL);
        this.setText(info.toString());
        this.pane.getCaret().setDot(0);
    }

    private class BuildMenuListener
    implements ActionListener {
        private BuildMenuListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Effigy effigy = (Effigy)DocViewer.this.getTableau().getContainer();
                DocBuilderTableau tableau = new DocBuilderTableau(effigy, "DocBuilderTableau");
                tableau.show();
            }
            catch (Throwable throwable) {
                MessageHandler.error((String)"Cannot create build", (Throwable)throwable);
            }
        }
    }
}

