/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Configurer;
import ptolemy.actor.gui.PtolemyFrame;
import ptolemy.actor.gui.Tableau;
import ptolemy.gui.JTextAreaExec;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.DocBuilder;

public class DocBuilderGUI
extends PtolemyFrame {
    private String _applicationName;

    public DocBuilderGUI(final DocBuilder docBuilder, Tableau tableau) throws IllegalActionException, NameDuplicationException {
        super((NamedObj)docBuilder, tableau);
        this.setTitle("Ptolemy II Java and Actor Documentation Builder");
        if (this.getEffigy() == null) {
            throw new InternalErrorException("Cannot get an effigy!");
        }
        JPanel caveatsPanel = new JPanel();
        caveatsPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        caveatsPanel.setLayout(new BoxLayout(caveatsPanel, 0));
        Configuration configuration = this.getConfiguration();
        try {
            StringAttribute applicationNameAttribute = (StringAttribute)configuration.getAttribute("_applicationName", StringAttribute.class);
            if (applicationNameAttribute != null) {
                this._applicationName = applicationNameAttribute.getExpression();
            }
        }
        catch (Throwable throwable) {}
        JTextArea messageArea = new JTextArea("NOTE: Use this tool to build the Java and Actor Documentation" + (this._applicationName != null ? "for " + this._applicationName : "") + ".");
        messageArea.setEditable(false);
        messageArea.setBorder(BorderFactory.createEtchedBorder());
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        caveatsPanel.add(messageArea);
        JButton moreInfoButton = new JButton("More Info");
        moreInfoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String infoFile = "ptolemy/vergil/actor/docViewerHelp.htm";
                try {
                    Configuration configuration = DocBuilderGUI.this.getConfiguration();
                    URL infoURL = Thread.currentThread().getContextClassLoader().getResource(infoFile);
                    configuration.openModel(null, infoURL, infoURL.toExternalForm());
                }
                catch (Exception ex) {
                    throw new InternalErrorException((Nameable)docBuilder, (Throwable)ex, "Failed to open " + infoFile);
                }
            }
        });
        caveatsPanel.add(moreInfoButton);
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        caveatsPanel.setMaximumSize(new Dimension(500, 100));
        left.add(caveatsPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 4));
        JButton goButton = new JButton("Generate");
        goButton.setToolTipText("Generate documentation");
        buttonPanel.add(goButton);
        JButton stopButton = new JButton("Cancel");
        stopButton.setToolTipText("Terminate executing processes");
        buttonPanel.add(stopButton);
        JButton clearButton = new JButton("Clear");
        clearButton.setToolTipText("Clear Log");
        buttonPanel.add(clearButton);
        buttonPanel.setMaximumSize(new Dimension(500, 50));
        left.add(buttonPanel);
        Configurer configurer = new Configurer((NamedObj)docBuilder);
        JPanel controlPanel = new JPanel();
        controlPanel.add(configurer);
        JScrollPane scrollPane = new JScrollPane(controlPanel);
        left.add((Component)scrollPane, "Center");
        final JTextAreaExec exec = new JTextAreaExec("Documentation BuilderCommands", false);
        docBuilder.setConfiguration(configuration);
        docBuilder.setExecuteCommands(exec);
        JSplitPane splitPane = new JSplitPane(1, left, exec);
        splitPane.setOneTouchExpandable(true);
        Dimension preferred = left.getPreferredSize();
        splitPane.setDividerLocation(preferred.width + 20);
        this.getContentPane().add((Component)splitPane, "Center");
        stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                exec.cancel();
            }
        });
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                exec.clear();
            }
        });
        goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    exec.updateStatusBar("// Starting Doc Building" + (DocBuilderGUI.this._applicationName != null ? " for " + DocBuilderGUI.this._applicationName : ""));
                    docBuilder.buildDocs();
                    exec.updateStatusBar(" ");
                }
                catch (Exception ex) {
                    MessageHandler.error((String)"Doc Building failed.", (Throwable)ex);
                }
            }
        });
    }
}

