/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.canvas.Figure;
import diva.canvas.GraphicsPane;
import diva.canvas.interactor.SelectionDragger;
import diva.graph.EdgeController;
import diva.graph.GraphController;
import diva.graph.GraphPane;
import diva.graph.NodeController;
import diva.gui.GUIUtilities;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import ptolemy.actor.Actor;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.gui.Configuration;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.DebugEvent;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Vertex;
import ptolemy.vergil.actor.ActorController;
import ptolemy.vergil.actor.ActorInstanceController;
import ptolemy.vergil.actor.ClassDefinitionController;
import ptolemy.vergil.actor.IOPortController;
import ptolemy.vergil.actor.LinkController;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.LocatableNodeController;
import ptolemy.vergil.basic.NamedObjController;
import ptolemy.vergil.basic.RunnableGraphController;
import ptolemy.vergil.kernel.AnimationRenderer;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.kernel.RelationController;

public class ActorViewerGraphController
extends RunnableGraphController {
    protected NamedObjController _attributeController;
    protected ActorController _classDefinitionController;
    protected ActorController _entityController;
    protected NamedObjController _entityPortController;
    protected LinkController _linkController;
    protected NamedObjController _relationController;
    private LocatableNodeController _locatableController;
    private SelectionDragger _selectionDragger;

    public ActorViewerGraphController() {
        this._createControllers();
        this._locatableController = new LocatableNodeController((GraphController)this);
    }

    public void addToMenuAndToolbar(JMenu menu, JToolBar toolbar) {
        super.addToMenuAndToolbar(menu, toolbar);
        GUIUtilities.addHotKey((JComponent)this.getFrame().getJGraph(), (Action)this._entityController._lookInsideAction);
        GUIUtilities.addHotKey((JComponent)this.getFrame().getJGraph(), (Action)this._classDefinitionController._lookInsideAction);
    }

    public void event(DebugEvent event) {
        Actor actor;
        if (event instanceof FiringEvent && (actor = ((FiringEvent)event).getActor()) instanceof NamedObj) {
            Figure figure;
            NamedObj objToHighlight = (NamedObj)actor;
            AbstractBasicGraphModel graphModel = (AbstractBasicGraphModel)this.getGraphModel();
            NamedObj toplevel = graphModel.getPtolemyModel();
            while (objToHighlight != null && objToHighlight.getContainer() != toplevel) {
                objToHighlight = objToHighlight.getContainer();
            }
            if (objToHighlight == null) {
                return;
            }
            Attribute location = objToHighlight.getAttribute("_location");
            if (location != null && (figure = this.getFigure(location)) != null) {
                FiringEvent.FiringEventType type;
                if (this._animationRenderer == null) {
                    this._animationRenderer = new AnimationRenderer();
                }
                if ((type = ((FiringEvent)event).getType()) == FiringEvent.BEFORE_ITERATE || type == FiringEvent.BEFORE_FIRE) {
                    this._animationRenderer.renderSelected(figure);
                    this._animated = figure;
                    long animationDelay = this.getAnimationDelay();
                    if (animationDelay > 0L) {
                        try {
                            Thread.sleep(animationDelay);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else if ((type == FiringEvent.AFTER_ITERATE || type == FiringEvent.AFTER_POSTFIRE) && this._animated != null) {
                    this._animationRenderer.renderDeselected(this._animated);
                }
            }
        }
    }

    public EdgeController getEdgeController(Object edge) {
        return this._linkController;
    }

    public ActorController getEntityController() {
        return this._entityController;
    }

    public NodeController getNodeController(Object object) {
        NodeController result = super.getNodeController(object);
        if (result != null) {
            return result;
        }
        if (object instanceof Vertex) {
            return this._relationController;
        }
        if (object instanceof Locatable) {
            Object semanticObject = this.getGraphModel().getSemanticObject(object);
            if (semanticObject instanceof Entity) {
                if (this._classDefinitionController != null && ((Entity)semanticObject).isClassDefinition()) {
                    return this._classDefinitionController;
                }
                return this._entityController;
            }
            if (semanticObject instanceof Attribute) {
                return this._attributeController;
            }
            if (semanticObject instanceof Port) {
                return this._portController;
            }
            return this._locatableController;
        }
        if (object instanceof Port) {
            return this._entityPortController;
        }
        throw new RuntimeException("Node with unknown semantic object: " + object);
    }

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._attributeController.setConfiguration(configuration);
        this._classDefinitionController.setConfiguration(configuration);
        this._entityController.setConfiguration(configuration);
        this._entityPortController.setConfiguration(configuration);
        this._relationController.setConfiguration(configuration);
        this._linkController.setConfiguration(configuration);
    }

    protected void _createControllers() {
        super._createControllers();
        this._attributeController = new AttributeController((GraphController)this, AttributeController.PARTIAL);
        this._classDefinitionController = new ClassDefinitionController((GraphController)this, AttributeController.PARTIAL);
        this._entityController = new ActorInstanceController((GraphController)this, AttributeController.PARTIAL);
        this._entityPortController = new IOPortController((GraphController)this, AttributeController.PARTIAL);
        this._relationController = new RelationController((GraphController)this);
        this._linkController = new LinkController((GraphController)this);
    }

    protected void initializeInteraction() {
        GraphPane pane = this.getGraphPane();
        this._selectionDragger = new SelectionDragger((GraphicsPane)pane);
        this._selectionDragger.addSelectionModel(this.getSelectionModel());
        this._selectionDragger.setConsuming(false);
        super.initializeInteraction();
    }
}

