/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.graph.GraphEvent;
import diva.graph.GraphModel;
import diva.graph.GraphUtilities;
import diva.graph.modular.CompositeModel;
import diva.graph.modular.CompositeNodeModel;
import diva.graph.modular.EdgeModel;
import diva.graph.modular.MutableEdgeModel;
import diva.graph.modular.NodeModel;
import diva.util.NullIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.moml.Vertex;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.NamedObjNodeModel;
import ptolemy.vergil.kernel.Link;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActorGraphModel
extends AbstractBasicGraphModel {
    private Set _linkSet;
    private ExternalPortModel _externalPortModel = new ExternalPortModel();
    private IconModel _iconModel = new IconModel();
    private LinkModel _linkModel = new LinkModel();
    private PortModel _portModel = new PortModel();
    private VertexModel _vertexModel = new VertexModel();

    public ActorGraphModel(NamedObj composite) {
        super(composite);
        this._linkSet = new HashSet();
        this._update();
    }

    @Override
    public void disconnectEdge(Object eventSource, Object edge) {
        GraphEvent e;
        if (!(this.getEdgeModel(edge) instanceof MutableEdgeModel)) {
            return;
        }
        MutableEdgeModel model = (MutableEdgeModel)this.getEdgeModel(edge);
        Object head = model.getHead(edge);
        Object tail = model.getTail(edge);
        model.setTail(edge, null);
        model.setHead(edge, null);
        if (head != null) {
            e = new GraphEvent(eventSource, 11, edge, head);
            this.dispatchGraphEvent(e);
        }
        if (tail != null) {
            e = new GraphEvent(eventSource, 12, edge, tail);
            this.dispatchGraphEvent(e);
        }
    }

    @Override
    public String getDeleteEdgeMoML(Object edge) {
        if (!(this.getEdgeModel(edge) instanceof LinkModel)) {
            return "";
        }
        LinkModel model = (LinkModel)this.getEdgeModel(edge);
        return model.getDeleteEdgeMoML(edge);
    }

    @Override
    public String getDeleteNodeMoML(Object node) {
        if (!(this.getNodeModel(node) instanceof NamedObjNodeModel)) {
            return "";
        }
        NamedObjNodeModel model = (NamedObjNodeModel)this.getNodeModel(node);
        return model.getDeleteNodeMoML(node);
    }

    @Override
    public CompositeModel getCompositeModel(Object composite) {
        CompositeModel result = super.getCompositeModel(composite);
        if (result == null && composite instanceof Locatable && ((Locatable)composite).getContainer() instanceof Entity) {
            return this._iconModel;
        }
        return result;
    }

    public EdgeModel getEdgeModel(Object edge) {
        if (edge instanceof Link) {
            return this._linkModel;
        }
        return null;
    }

    public LinkModel getLinkModel() {
        return this._linkModel;
    }

    @Override
    public NodeModel getNodeModel(Object node) {
        if (node instanceof Port) {
            return this._portModel;
        }
        if (node instanceof Vertex) {
            return this._vertexModel;
        }
        if (node instanceof Locatable) {
            NamedObj container = ((Locatable)node).getContainer();
            if (container instanceof Port) {
                return this._externalPortModel;
            }
            if (container instanceof Entity) {
                return this._iconModel;
            }
        }
        return super.getNodeModel(node);
    }

    @Override
    public Object getSemanticObject(Object element) {
        if (element instanceof Vertex) {
            return ((Vertex)element).getContainer();
        }
        if (element instanceof Link) {
            return ((Link)element).getRelation();
        }
        return super.getSemanticObject(element);
    }

    @Override
    public void removeNode(Object eventSource, Object node) {
        if (!(this.getNodeModel(node) instanceof NamedObjNodeModel)) {
            return;
        }
        NamedObjNodeModel model = (NamedObjNodeModel)this.getNodeModel(node);
        model.removeNode(eventSource, node);
    }

    public IconModel getIconModel() {
        return this._iconModel;
    }

    public PortModel getPortModel() {
        return this._portModel;
    }

    public ExternalPortModel getExternalPortModel() {
        return this._externalPortModel;
    }

    public VertexModel getVertexModel() {
        return this._vertexModel;
    }

    protected Set<?> _getLinkSet() {
        return Collections.unmodifiableSet(this._linkSet);
    }

    protected void _removeLink(Link link) {
        this._linkSet.remove(link);
    }

    @Override
    protected boolean _update() {
        Iterator links = this._linkSet.iterator();
        while (links.hasNext()) {
            Link link = (Link)links.next();
            ComponentRelation relation = link.getRelation();
            if (relation == null || relation.getContainer() == null || this._isHidden((Relation)relation)) {
                link.setHead(null);
                link.setTail(null);
                links.remove();
                continue;
            }
            boolean headOK = GraphUtilities.isContainedNode((Object)link.getHead(), (Object)this.getRoot(), (GraphModel)this);
            boolean tailOK = GraphUtilities.isContainedNode((Object)link.getTail(), (Object)this.getRoot(), (GraphModel)this);
            if (headOK && tailOK) continue;
            Object headObj = this.getSemanticObject(link.getHead());
            Object tailObj = this.getSemanticObject(link.getTail());
            link.setHead(null);
            link.setTail(null);
            links.remove();
            if (!(headObj instanceof Port) || !(tailObj instanceof Port) || relation.getContainer() == null) continue;
            NamedObj container = this.getPtolemyModel();
            MoMLChangeRequest request = new MoMLChangeRequest((Object)container, container, "<deleteRelation name=\"" + relation.getName(container) + "\"/>\n");
            request.setUndoable(true);
            request.setMergeWithPreviousUndo(true);
            container.requestChange((ChangeRequest)request);
            return false;
        }
        NamedObj ptolemyModel = this.getPtolemyModel();
        if (ptolemyModel instanceof CompositeEntity) {
            Iterator relations = ((CompositeEntity)ptolemyModel).relationList().iterator();
            while (relations.hasNext()) {
                this._updateLinks((ComponentRelation)relations.next());
            }
        }
        return super._update();
    }

    private void _updateLinks(ComponentRelation relation) {
        if (this._isHidden((Relation)relation)) {
            return;
        }
        List linkedObjects = relation.linkedObjectsList();
        int linkedObjectsCount = linkedObjects.size();
        for (Link link : new LinkedList(this._linkSet)) {
            Object tail = link.getTail();
            Object tailObj = this.getSemanticObject(tail);
            Object head = link.getHead();
            Object headObj = this.getSemanticObject(head);
            if (tailObj != relation && headObj != relation && link.getRelation() != relation) continue;
            if (tailObj != null && linkedObjects.contains(tailObj)) {
                linkedObjects.remove(tailObj);
            } else if (tailObj != relation) {
                link.setHead(null);
                link.setTail(null);
                this._linkSet.remove(link);
            }
            if (headObj != null && linkedObjects.contains(headObj)) {
                linkedObjects.remove(headObj);
                continue;
            }
            if (headObj == relation) continue;
            link.setHead(null);
            link.setTail(null);
            this._linkSet.remove(link);
        }
        int unlinkedPortCount = linkedObjects.size();
        if (unlinkedPortCount == 0) {
            return;
        }
        Vertex rootVertex = null;
        for (Vertex v : relation.attributeList(Vertex.class)) {
            if (v.getLinkedVertex() != null) continue;
            rootVertex = v;
        }
        if (rootVertex == null && linkedObjectsCount == 2 && unlinkedPortCount == 2 && linkedObjects.get(0) instanceof Port && linkedObjects.get(1) instanceof Port) {
            Link link;
            Port port1 = (Port)linkedObjects.get(0);
            Port port2 = (Port)linkedObjects.get(1);
            Object head = null;
            Object tail = null;
            head = port1.getContainer().equals(this.getRoot()) ? this._getLocation((NamedObj)port1) : port1;
            tail = port2.getContainer().equals(this.getRoot()) ? this._getLocation((NamedObj)port2) : port2;
            try {
                link = new Link();
                this._linkSet.add(link);
            }
            catch (Exception e) {
                throw new InternalErrorException("Failed to create new link, even though one does not already exist:" + e.getMessage());
            }
            link.setRelation(relation);
            link.setHead(head);
            link.setTail(tail);
        } else {
            if (rootVertex == null) {
                try {
                    String name = relation.uniqueName("vertex");
                    rootVertex = new Vertex((Relation)relation, name);
                    rootVertex.propagateExistence();
                }
                catch (Throwable throwable) {
                    throw new InternalErrorException(null, throwable, "Failed to create new vertex, even though one does not already exist:" + throwable.getMessage());
                }
            }
            for (Object portOrRelation : linkedObjects) {
                Link link;
                Object head = null;
                if (portOrRelation instanceof Port) {
                    Port port = (Port)portOrRelation;
                    head = port.getContainer().equals(this.getRoot()) ? this._getLocation((NamedObj)port) : port;
                } else {
                    for (Vertex v : ((Relation)portOrRelation).attributeList(Vertex.class)) {
                        if (v.getLinkedVertex() != null) continue;
                        head = v;
                    }
                }
                try {
                    link = new Link();
                    this._linkSet.add(link);
                }
                catch (Exception e) {
                    throw new InternalErrorException("Failed to create new link, even though one does not already exist:" + e.getMessage());
                }
                link.setRelation(relation);
                link.setHead(head);
                link.setTail(rootVertex);
            }
        }
    }

    private boolean _isHidden(Relation relation) {
        block5: {
            Attribute hide = relation.getAttribute("_hide");
            if (hide != null) {
                if (hide instanceof Parameter) {
                    try {
                        Token token = ((Parameter)hide).getToken();
                        if (token instanceof BooleanToken && ((BooleanToken)token).booleanValue()) {
                            return true;
                        }
                        break block5;
                    }
                    catch (IllegalActionException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public class ExternalPortModel
    extends NamedObjNodeModel {
        public String getDeleteNodeMoML(Object node) {
            Locatable location = (Locatable)node;
            ComponentPort port = (ComponentPort)location.getContainer();
            StringBuffer moml = new StringBuffer();
            moml.append("<deletePort name=\"" + port.getName() + "\"/>\n");
            return moml.toString();
        }

        public Object getParent(Object node) {
            return ((Locatable)node).getContainer().getContainer();
        }

        public Iterator inEdges(Object node) {
            Locatable location = (Locatable)node;
            LinkedList<Link> portLinkList = new LinkedList<Link>();
            for (Link link : ActorGraphModel.this._linkSet) {
                Object head = link.getHead();
                if (head == null || !head.equals(location)) continue;
                portLinkList.add(link);
            }
            return portLinkList.iterator();
        }

        public Iterator outEdges(Object node) {
            Locatable location = (Locatable)node;
            LinkedList<Link> portLinkList = new LinkedList<Link>();
            for (Link link : ActorGraphModel.this._linkSet) {
                Object tail = link.getTail();
                if (tail == null || !tail.equals(location)) continue;
                portLinkList.add(link);
            }
            return portLinkList.iterator();
        }

        public void removeNode(Object eventSource, Object node) {
            Locatable location = (Locatable)node;
            ComponentPort port = (ComponentPort)location.getContainer();
            NamedObj container = port.getContainer();
            StringBuffer moml = new StringBuffer();
            moml.append("<deletePort name=\"" + port.getName(container) + "\"/>\n");
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, container, moml.toString());
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }
    }

    public static class IconModel
    extends NamedObjNodeModel
    implements CompositeNodeModel {
        public String getDeleteNodeMoML(Object node) {
            NamedObj deleteObj = ((Locatable)node).getContainer();
            String moml = "<deleteEntity name=\"" + deleteObj.getName() + "\"/>\n";
            return moml;
        }

        public int getNodeCount(Object composite) {
            Locatable location = (Locatable)composite;
            return ((ComponentEntity)location.getContainer()).portList().size();
        }

        public Object getParent(Object node) {
            return ((Locatable)node).getContainer().getContainer();
        }

        public Iterator inEdges(Object node) {
            return new NullIterator();
        }

        public Iterator nodes(Object composite) {
            Locatable location = (Locatable)composite;
            NamedObj container = location.getContainer();
            if (container instanceof ComponentEntity) {
                ComponentEntity entity = (ComponentEntity)container;
                return entity.portList().iterator();
            }
            return new NullIterator();
        }

        public Iterator nodesBeforeEdges(Object composite) {
            return this.nodes(composite);
        }

        public Iterator nodesAfterEdges(Object composite) {
            return new NullIterator();
        }

        public Iterator outEdges(Object node) {
            return new NullIterator();
        }

        public void removeNode(Object eventSource, Object node) {
            NamedObj deleteObj = ((Locatable)node).getContainer();
            if (!(deleteObj instanceof ComponentEntity)) {
                throw new InternalErrorException("Attempt to remove a node that is not an Entity. node = " + node);
            }
            NamedObj container = deleteObj.getContainer();
            String moml = "<deleteEntity name=\"" + deleteObj.getName() + "\"/>\n";
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, container, moml);
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }
    }

    public class LinkModel
    implements MutableEdgeModel {
        public boolean acceptHead(Object edge, Object node) {
            return node instanceof Port || node instanceof Vertex || node instanceof Locatable && ((Locatable)node).getContainer() instanceof Port;
        }

        public boolean acceptTail(Object edge, Object node) {
            return node instanceof Port || node instanceof Vertex || node instanceof Locatable && ((Locatable)node).getContainer() instanceof Port;
        }

        public String getDeleteEdgeMoML(Object edge) {
            Link link = (Link)edge;
            NamedObj linkHead = (NamedObj)link.getHead();
            NamedObj linkTail = (NamedObj)link.getTail();
            ComponentRelation linkRelation = link.getRelation();
            StringBuffer moml = new StringBuffer();
            NamedObj container = ActorGraphModel.this.getPtolemyModel();
            try {
                this._unlinkMoML(container, moml, linkHead, linkTail, (Relation)linkRelation);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
            return moml.toString();
        }

        public Object getHead(Object edge) {
            return ((Link)edge).getHead();
        }

        public Object getTail(Object edge) {
            return ((Link)edge).getTail();
        }

        public boolean isDirected(Object edge) {
            return false;
        }

        private boolean _unlinkMoML(NamedObj container, StringBuffer moml, NamedObj linkHead, NamedObj linkTail, Relation relation) throws Exception {
            if (linkHead != null && linkTail != null) {
                NamedObj head = (NamedObj)ActorGraphModel.this.getSemanticObject(linkHead);
                NamedObj tail = (NamedObj)ActorGraphModel.this.getSemanticObject(linkTail);
                if (head instanceof ComponentPort && tail instanceof ComponentPort) {
                    ComponentPort headPort = (ComponentPort)head;
                    ComponentPort tailPort = (ComponentPort)tail;
                    moml.append("<unlink port=\"" + headPort.getName(container) + "\" relation=\"" + relation.getName(container) + "\"/>\n");
                    moml.append("<unlink port=\"" + tailPort.getName(container) + "\" relation=\"" + relation.getName(container) + "\"/>\n");
                    moml.append("<deleteRelation name=\"" + relation.getName(container) + "\"/>\n");
                } else if (head instanceof ComponentPort && linkTail instanceof Vertex) {
                    moml.append("<unlink port=\"" + head.getName(container) + "\" relation=\"" + tail.getName(container) + "\"/>\n");
                } else if (tail instanceof ComponentPort && linkHead instanceof Vertex) {
                    moml.append("<unlink port=\"" + tail.getName(container) + "\" relation=\"" + head.getName(container) + "\"/>\n");
                } else if (linkHead instanceof Vertex && linkTail instanceof Vertex) {
                    moml.append("<unlink relation1=\"" + tail.getName(container) + "\" relation2=\"" + head.getName(container) + "\"/>\n");
                } else {
                    throw new RuntimeException("Unlink failed: Head = " + head + ", Tail = " + tail);
                }
                return true;
            }
            return false;
        }

        private String _linkMoML(NamedObj container, StringBuffer moml, StringBuffer failmoml, NamedObj linkHead, NamedObj linkTail) throws Exception {
            if (linkHead != null && linkTail != null) {
                NamedObj head = (NamedObj)ActorGraphModel.this.getSemanticObject(linkHead);
                NamedObj tail = (NamedObj)ActorGraphModel.this.getSemanticObject(linkTail);
                if (head instanceof ComponentPort && tail instanceof ComponentPort) {
                    ComponentPort headPort = (ComponentPort)head;
                    ComponentPort tailPort = (ComponentPort)tail;
                    NamedObj ptolemyModel = ActorGraphModel.this.getPtolemyModel();
                    String relationName = ptolemyModel.uniqueName("relation");
                    if (ptolemyModel != container) {
                        String contextString = "<entity name=\"" + ptolemyModel.getName(container) + "\">\n";
                        moml.append(contextString);
                        failmoml.append(contextString);
                    }
                    moml.append("<relation name=\"" + relationName + "\"/>\n");
                    moml.append("<link port=\"" + headPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                    moml.append("<link port=\"" + tailPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                    failmoml.append("<unlink port=\"" + headPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                    failmoml.append("<unlink port=\"" + tailPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                    failmoml.append("<deleteRelation name=\"" + relationName + "\"/>\n");
                    if (ptolemyModel != container) {
                        moml.append("</entity>");
                        failmoml.append("</entity>");
                    }
                    if (ptolemyModel != container) {
                        return String.valueOf(ptolemyModel.getName(container)) + "." + relationName;
                    }
                    return relationName;
                }
                if (head instanceof ComponentPort && linkTail instanceof Vertex) {
                    moml.append("<link port=\"" + head.getName(container) + "\" relation=\"" + tail.getName(container) + "\"/>\n");
                    return tail.getName(container);
                }
                if (tail instanceof ComponentPort && linkHead instanceof Vertex) {
                    moml.append("<link port=\"" + tail.getName(container) + "\" relation=\"" + head.getName(container) + "\"/>\n");
                    return head.getName(container);
                }
                if (linkHead instanceof Vertex && linkTail instanceof Vertex) {
                    moml.append("<link relation1=\"" + tail.getName(container) + "\" relation2=\"" + head.getName(container) + "\"/>\n");
                    return head.getName(container);
                }
                throw new RuntimeException("Link failed: Head = " + head + ", Tail = " + tail);
            }
            return null;
        }

        public void setHead(Object edge, final Object newLinkHead) {
            final Link link = (Link)edge;
            NamedObj linkHead = (NamedObj)link.getHead();
            NamedObj linkTail = (NamedObj)link.getTail();
            ComponentRelation linkRelation = link.getRelation();
            StringBuffer moml = new StringBuffer();
            StringBuffer failmoml = new StringBuffer();
            moml.append("<group>\n");
            failmoml.append("<group>\n");
            final CompositeEntity container = (CompositeEntity)ActorGraphModel.this.getPtolemyModel();
            String relationName = "";
            boolean appendedMoML = false;
            try {
                appendedMoML = this._unlinkMoML((NamedObj)container, moml, linkHead, linkTail, (Relation)linkRelation);
                relationName = this._linkMoML((NamedObj)container, moml, failmoml, (NamedObj)newLinkHead, linkTail);
                appendedMoML = appendedMoML || relationName != null;
            }
            catch (Exception exception) {
                ActorGraphModel.this._linkSet.remove(link);
                link.setHead(null);
                link.setTail(null);
                ActorGraphModel.this.dispatchGraphEvent(new GraphEvent((Object)ActorGraphModel.this, 30, ActorGraphModel.this.getRoot()));
            }
            moml.append("</group>\n");
            failmoml.append("</group>\n");
            final String relationNameToAdd = relationName;
            final boolean nonEmptyMoML = appendedMoML;
            MoMLChangeRequest request = new MoMLChangeRequest((Object)ActorGraphModel.this, (NamedObj)container, moml.toString()){

                protected void _execute() throws Exception {
                    if (nonEmptyMoML) {
                        super._execute();
                    }
                    link.setHead(newLinkHead);
                    if (relationNameToAdd != null) {
                        ComponentRelation relation = container.getRelation(relationNameToAdd);
                        if (relation == null) {
                            throw new InternalErrorException("Tried to find relation with name " + relationNameToAdd + " in context " + container);
                        }
                        link.setRelation(relation);
                    } else {
                        link.setRelation(null);
                    }
                }
            };
            request.addChangeListener((ChangeListener)new LinkChangeListener(link, container, failmoml));
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }

        public void setTail(Object edge, final Object newLinkTail) {
            final Link link = (Link)edge;
            NamedObj linkHead = (NamedObj)link.getHead();
            NamedObj linkTail = (NamedObj)link.getTail();
            ComponentRelation linkRelation = link.getRelation();
            StringBuffer moml = new StringBuffer();
            StringBuffer failmoml = new StringBuffer();
            moml.append("<group>\n");
            failmoml.append("<group>\n");
            final CompositeEntity container = (CompositeEntity)ActorGraphModel.this.getPtolemyModel();
            String relationName = "";
            boolean appendedMoML = false;
            try {
                appendedMoML = this._unlinkMoML((NamedObj)container, moml, linkHead, linkTail, (Relation)linkRelation);
                relationName = this._linkMoML((NamedObj)container, moml, failmoml, linkHead, (NamedObj)newLinkTail);
                appendedMoML = appendedMoML || relationName != null;
            }
            catch (Exception exception) {
                ActorGraphModel.this._linkSet.remove(link);
                link.setHead(null);
                link.setTail(null);
                ActorGraphModel.this.dispatchGraphEvent(new GraphEvent((Object)ActorGraphModel.this, 30, ActorGraphModel.this.getRoot()));
            }
            moml.append("</group>\n");
            failmoml.append("</group>\n");
            final String relationNameToAdd = relationName;
            final boolean nonEmptyMoML = appendedMoML;
            MoMLChangeRequest request = new MoMLChangeRequest((Object)ActorGraphModel.this, (NamedObj)container, moml.toString()){

                protected void _execute() throws Exception {
                    if (nonEmptyMoML) {
                        super._execute();
                    }
                    link.setTail(newLinkTail);
                    if (relationNameToAdd != null) {
                        ComponentRelation relation = container.getRelation(relationNameToAdd);
                        if (relation == null) {
                            throw new InternalErrorException("Tried to find relation with name " + relationNameToAdd + " in context " + container);
                        }
                        link.setRelation(relation);
                    } else {
                        link.setRelation(null);
                    }
                }
            };
            request.addChangeListener((ChangeListener)new LinkChangeListener(link, container, failmoml));
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }

        public class LinkChangeListener
        implements ChangeListener {
            private Link _link;
            private CompositeEntity _container;
            private StringBuffer _failMoML;

            public LinkChangeListener(Link link, CompositeEntity container, StringBuffer failMoML) {
                this._link = link;
                this._container = container;
                this._failMoML = failMoML;
            }

            public void changeFailed(ChangeRequest change, Exception exception) {
                ActorGraphModel.this._linkSet.remove(this._link);
                this._link.setHead(null);
                this._link.setTail(null);
                this._link.setRelation(null);
                MoMLChangeRequest changeRequest = new MoMLChangeRequest((Object)this, (NamedObj)this._container, this._failMoML.toString());
                this._container.requestChange((ChangeRequest)changeRequest);
            }

            public void changeExecuted(ChangeRequest change) {
                if (GraphUtilities.isPartiallyContainedEdge((Object)this._link, (Object)ActorGraphModel.this.getRoot(), (GraphModel)ActorGraphModel.this)) {
                    ActorGraphModel.this._linkSet.add(this._link);
                } else {
                    ActorGraphModel.this._linkSet.remove(this._link);
                }
                if (this._link.getHead() != null && this._link.getTail() != null) {
                    ActorGraphModel.this.dispatchGraphEvent(new GraphEvent((Object)ActorGraphModel.this, 30, ActorGraphModel.this.getRoot()));
                }
            }
        }
    }

    public class PortModel
    extends NamedObjNodeModel {
        public String getDeleteNodeMoML(Object node) {
            NamedObj deleteObj = ((Locatable)node).getContainer();
            NamedObj container = deleteObj.getContainer();
            String moml = "<deletePort name=\"" + deleteObj.getName(container) + "\"/>\n";
            return moml;
        }

        public Object getParent(Object node) {
            ComponentPort port = (ComponentPort)node;
            Entity entity = (Entity)port.getContainer();
            if (entity == null) {
                return null;
            }
            List locationList = entity.attributeList(Locatable.class);
            if (locationList.size() > 0) {
                return locationList.get(0);
            }
            try {
                Location location = new Location((NamedObj)entity, "_location");
                location.propagateExistence();
                return location;
            }
            catch (Exception e) {
                throw new InternalErrorException("Failed to create location, even though one does not exist:" + e.getMessage());
            }
        }

        public Iterator inEdges(Object node) {
            ComponentPort port = (ComponentPort)node;
            LinkedList<Link> portLinkList = new LinkedList<Link>();
            for (Link link : ActorGraphModel.this._linkSet) {
                Object head = link.getHead();
                if (head == null || !head.equals(port)) continue;
                portLinkList.add(link);
            }
            return portLinkList.iterator();
        }

        public Iterator outEdges(Object node) {
            ComponentPort port = (ComponentPort)node;
            LinkedList<Link> portLinkList = new LinkedList<Link>();
            for (Link link : ActorGraphModel.this._linkSet) {
                Object tail = link.getTail();
                if (tail == null || !tail.equals(port)) continue;
                portLinkList.add(link);
            }
            return portLinkList.iterator();
        }

        public void removeNode(Object eventSource, Object node) {
            ComponentPort port = (ComponentPort)node;
            NamedObj container = port.getContainer();
            String moml = "<deletePort name=\"" + port.getName() + "\"/>\n";
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, container, moml);
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }
    }

    public class VertexModel
    extends NamedObjNodeModel {
        public String getDeleteNodeMoML(Object node) {
            ComponentRelation deleteObj = (ComponentRelation)((Vertex)node).getContainer();
            String moml = "<deleteRelation name=\"" + deleteObj.getName() + "\"/>\n";
            return moml;
        }

        public Object getParent(Object node) {
            if (((Vertex)node).getContainer() == null) {
                return null;
            }
            return ((Vertex)node).getContainer().getContainer();
        }

        public Iterator inEdges(Object node) {
            Vertex vertex = (Vertex)node;
            LinkedList<Link> vertexLinkList = new LinkedList<Link>();
            for (Link link : ActorGraphModel.this._linkSet) {
                Object head = link.getHead();
                if (head == null || !head.equals(vertex)) continue;
                vertexLinkList.add(link);
            }
            return vertexLinkList.iterator();
        }

        public Iterator outEdges(Object node) {
            Vertex vertex = (Vertex)node;
            LinkedList<Link> vertexLinkList = new LinkedList<Link>();
            for (Link link : ActorGraphModel.this._linkSet) {
                Object tail = link.getTail();
                if (tail == null || !tail.equals(vertex)) continue;
                vertexLinkList.add(link);
            }
            return vertexLinkList.iterator();
        }

        public void removeNode(Object eventSource, Object node) {
            ComponentRelation relation = (ComponentRelation)((Vertex)node).getContainer();
            NamedObj container = relation.getContainer();
            String moml = "<deleteRelation name=\"" + relation.getName() + "\"/>\n";
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, container, moml);
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }
    }
}

