/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.canvas.CanvasLayer;
import diva.canvas.Figure;
import diva.canvas.FigureLayer;
import diva.canvas.Site;
import diva.canvas.connector.AutonomousSite;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorManipulator;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.AbstractInteractor;
import diva.canvas.interactor.ActionInteractor;
import diva.canvas.interactor.CompositeInteractor;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.interactor.Interactor;
import diva.graph.GraphController;
import diva.graph.GraphPane;
import diva.graph.NodeRenderer;
import diva.gui.GUIUtilities;
import diva.gui.toolbox.FigureIcon;
import diva.gui.toolbox.JContextMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import ptolemy.actor.gui.Configuration;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.ActorController;
import ptolemy.vergil.actor.ActorGraphModel;
import ptolemy.vergil.actor.ActorInstanceController;
import ptolemy.vergil.actor.ActorViewerGraphController;
import ptolemy.vergil.actor.ClassDefinitionController;
import ptolemy.vergil.actor.ExternalIOPortController;
import ptolemy.vergil.actor.IOPortController;
import ptolemy.vergil.actor.LinkController;
import ptolemy.vergil.basic.BasicGraphFrame;
import ptolemy.vergil.basic.NamedObjController;
import ptolemy.vergil.basic.WithIconGraphController;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.kernel.ConfigureUnitsAction;
import ptolemy.vergil.kernel.Link;
import ptolemy.vergil.kernel.PortDialogAction;
import ptolemy.vergil.kernel.RelationController;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuItemFactory;
import ptolemy.vergil.toolbox.SnapConstraint;

public class ActorEditorGraphController
extends ActorViewerGraphController {
    private ConfigureUnitsAction _configureUnitsAction;
    private LinkCreator _linkCreator;
    private ListenToActorFactory _listenToActorFactory;
    private Action _newInputPortAction = new WithIconGraphController.NewPortAction(this, ExternalIOPortController._GENERIC_INPUT, "New input port", 73, new String[][]{{"/ptolemy/vergil/actor/img/single_in.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/single_in_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/single_in_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/single_in_on.gif", "selectedIcon"}});
    private Action _newOutputPortAction = new WithIconGraphController.NewPortAction(this, ExternalIOPortController._GENERIC_OUTPUT, "New output port", 79, new String[][]{{"/ptolemy/vergil/actor/img/single_out.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/single_out_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/single_out_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/single_out_on.gif", "selectedIcon"}});
    private Action _newInoutPortAction = new WithIconGraphController.NewPortAction(this, ExternalIOPortController._GENERIC_INOUT, "New input/output port", 80, new String[][]{{"/ptolemy/vergil/actor/img/single_inout.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/single_inout_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/single_inout_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/single_inout_on.gif", "selectedIcon"}});
    private Action _newInputMultiportAction = new WithIconGraphController.NewPortAction(this, ExternalIOPortController._GENERIC_INPUT_MULTIPORT, "New input multiport", 78, new String[][]{{"/ptolemy/vergil/actor/img/multi_in.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/multi_in_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/multi_in_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/multi_in_on.gif", "selectedIcon"}});
    private Action _newOutputMultiportAction = new WithIconGraphController.NewPortAction(this, ExternalIOPortController._GENERIC_OUTPUT_MULTIPORT, "New output multiport", 85, new String[][]{{"/ptolemy/vergil/actor/img/multi_out.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/multi_out_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/multi_out_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/multi_out_on.gif", "selectedIcon"}});
    private Action _newInoutMultiportAction = new WithIconGraphController.NewPortAction(this, ExternalIOPortController._GENERIC_INOUT_MULTIPORT, "New input/output multiport", 84, new String[][]{{"/ptolemy/vergil/actor/img/multi_inout.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/multi_inout_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/multi_inout_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/multi_inout_on.gif", "selectedIcon"}});
    protected Action _newRelationAction = new NewRelationAction(new String[][]{{"/ptolemy/vergil/actor/img/relation.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/relation_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/relation_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/relation_on.gif", "selectedIcon"}});
    private PortDialogAction _portDialogAction;
    private RelationCreator _relationCreator;
    private MouseFilter _shortcutFilter = new MouseFilter(16, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());

    public void addToMenuAndToolbar(JMenu menu, JToolBar toolbar) {
        super.addToMenuAndToolbar(menu, toolbar);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newInputPortAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newInputPortAction);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newOutputPortAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newOutputPortAction);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newInoutPortAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newInoutPortAction);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newInputMultiportAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newInputMultiportAction);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newOutputMultiportAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newOutputMultiportAction);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newInoutMultiportAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newInoutMultiportAction);
        menu.addSeparator();
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newRelationAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newRelationAction);
        GUIUtilities.addHotKey((JComponent)this.getFrame().getJGraph(), (Action)((ClassDefinitionController)this._classDefinitionController)._createInstanceAction);
        GUIUtilities.addHotKey((JComponent)this.getFrame().getJGraph(), (Action)((ClassDefinitionController)this._classDefinitionController)._createSubclassAction);
    }

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        if (this._portDialogAction != null) {
            this._portDialogAction.setConfiguration(configuration);
        }
        if (this._configureUnitsAction != null) {
            this._configureUnitsAction.setConfiguration(configuration);
        }
        if (this._listenToActorFactory != null) {
            this._listenToActorFactory.setConfiguration(configuration);
        }
    }

    protected void _createControllers() {
        this._attributeController = new AttributeController((GraphController)this, AttributeController.FULL);
        this._classDefinitionController = new ClassDefinitionController((GraphController)this);
        this._entityController = new ActorInstanceController((GraphController)this);
        this._entityPortController = new IOPortController((GraphController)this, AttributeController.FULL);
        this._portController = new ExternalIOPortController((GraphController)this, AttributeController.FULL);
        this._relationController = new RelationController((GraphController)this);
        this._linkController = new LinkController((GraphController)this);
    }

    protected void initializeInteraction() {
        super.initializeInteraction();
        GraphPane pane = this.getGraphPane();
        this._portDialogAction = new PortDialogAction("Ports");
        this._portDialogAction.setConfiguration(this.getConfiguration());
        _configureMenuFactory.addAction(this._portDialogAction, "Customize");
        this._configureUnitsAction = new ConfigureUnitsAction("Units Constraints");
        _configureMenuFactory.addAction(this._configureUnitsAction, "Customize");
        this._configureUnitsAction.setConfiguration(this.getConfiguration());
        this._listenToActorFactory = new ListenToActorFactory();
        this._menuFactory.addMenuItemFactory(this._listenToActorFactory);
        this._listenToActorFactory.setConfiguration(this.getConfiguration());
        this._relationCreator = new RelationCreator();
        this._relationCreator.setMouseFilter(this._shortcutFilter);
        pane.getBackgroundEventLayer().addInteractor((Interactor)this._relationCreator);
        this._linkCreator = new LinkCreator();
        this._linkCreator.setMouseFilter(this._shortcutFilter);
        ((CompositeInteractor)this._portController.getNodeInteractor()).addInteractor((Interactor)this._linkCreator);
        ((CompositeInteractor)this._entityPortController.getNodeInteractor()).addInteractor((Interactor)this._linkCreator);
        ((CompositeInteractor)this._relationController.getNodeInteractor()).addInteractor((Interactor)this._linkCreator);
        LinkCreator linkCreator2 = new LinkCreator();
        linkCreator2.setMouseFilter(new MouseFilter(16, 0));
        ((CompositeInteractor)this._entityPortController.getNodeInteractor()).addInteractor((Interactor)linkCreator2);
    }

    protected void _initializeInteraction(NamedObjController controller) {
        Interactor interactor;
        super._initializeInteraction(controller);
        if ((controller instanceof ExternalIOPortController || controller instanceof IOPortController || controller instanceof RelationController) && (interactor = controller.getNodeInteractor()) instanceof CompositeInteractor) {
            ((CompositeInteractor)interactor).addInteractor((Interactor)this._linkCreator);
        }
    }

    protected class LinkCreator
    extends AbstractInteractor {
        protected LinkCreator() {
        }

        public void mousePressed(LayerEvent event) {
            Figure source = event.getFigureSource();
            NamedObj sourceObject = (NamedObj)source.getUserObject();
            Link link = new Link();
            ActorGraphModel model = (ActorGraphModel)ActorEditorGraphController.this.getGraphModel();
            model.getLinkModel().setTail(link, sourceObject);
            try {
                FigureLayer layer = ActorEditorGraphController.this.getGraphPane().getForegroundLayer();
                AutonomousSite headSite = new AutonomousSite((CanvasLayer)layer, event.getLayerX(), event.getLayerY());
                AutonomousSite tailSite = new AutonomousSite((CanvasLayer)layer, event.getLayerX(), event.getLayerY());
                Connector c = ActorEditorGraphController.this.getEdgeController(link).render((Object)link, layer, (Site)tailSite, (Site)headSite);
                tailSite = ActorEditorGraphController.this.getEdgeController(link).getConnectorTarget().getTailSite(c, source, event.getLayerX(), event.getLayerY());
                if (tailSite == null) {
                    throw new RuntimeException("Invalid connector target: no valid site found for tail of new connector.");
                }
                c.setTailSite((Site)tailSite);
                ActorEditorGraphController.this.getSelectionModel().addSelection((Object)c);
                ConnectorManipulator cm = (ConnectorManipulator)c.getParent();
                GrabHandle gh = cm.getHeadHandle();
                layer.grabPointer(event, (Figure)gh);
            }
            catch (Exception ex) {
                MessageHandler.error((String)"Drag connection failed:", (Throwable)ex);
            }
        }
    }

    private class ListenToActorFactory
    implements MenuItemFactory {
        private ActorController.ListenToActorAction _action;
        private Configuration _configuration;

        private ListenToActorFactory() {
        }

        public JMenuItem create(JContextMenu menu, NamedObj object) {
            String name = "Listen to Actor";
            NamedObj target = object;
            this._action = new ActorController.ListenToActorAction(target, ActorEditorGraphController.this);
            this._action.setConfiguration(this._configuration);
            return menu.add((Action)this._action, name);
        }

        public void setConfiguration(Configuration configuration) {
            this._configuration = configuration;
            if (this._action != null) {
                this._action.setConfiguration(this._configuration);
            }
        }
    }

    public class NewRelationAction
    extends FigureAction {
        public NewRelationAction() {
            this(null);
        }

        public NewRelationAction(String[][] iconRoles) {
            super("New Relation");
            if (iconRoles != null) {
                GUIUtilities.addIcons((Action)this, (String[][])iconRoles);
            } else {
                NodeRenderer renderer = ActorEditorGraphController.this._relationController.getNodeRenderer();
                Figure figure = renderer.render(null);
                FigureIcon icon = new FigureIcon(figure, 25, 25, 1, true);
                this.putValue("LargeIcon", icon);
            }
            this.putValue("tooltip", "Control-click to create a new relation");
            this.putValue("MnemonicKey", 82);
        }

        public void actionPerformed(ActionEvent e) {
            double y;
            double x;
            super.actionPerformed(e);
            if (this.getSourceType() == TOOLBAR_TYPE || this.getSourceType() == MENUBAR_TYPE) {
                Point2D center;
                BasicGraphFrame frame = ActorEditorGraphController.this.getFrame();
                if (frame != null) {
                    center = frame.getCenter();
                    x = center.getX();
                    y = center.getY();
                } else {
                    GraphPane pane = ActorEditorGraphController.this.getGraphPane();
                    center = pane.getSize();
                    x = center.getX() / 2.0;
                    y = center.getY() / 2.0;
                }
            } else {
                AffineTransform inverse;
                AffineTransform current = ActorEditorGraphController.this.getGraphPane().getTransformContext().getTransform();
                try {
                    inverse = current.createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex.toString());
                }
                Point2D.Double point = new Point2D.Double(this.getX(), this.getY());
                inverse.transform(point, point);
                x = ((Point2D)point).getX();
                y = ((Point2D)point).getY();
            }
            ActorGraphModel graphModel = (ActorGraphModel)ActorEditorGraphController.this.getGraphModel();
            double[] point = SnapConstraint.constrainPoint(x, y);
            NamedObj toplevel = graphModel.getPtolemyModel();
            if (!(toplevel instanceof CompositeEntity)) {
                throw new InternalErrorException("Cannot invoke NewRelationAction on an object that is not a CompositeEntity.");
            }
            String relationName = toplevel.uniqueName("relation");
            StringBuffer moml = new StringBuffer();
            moml.append("<relation name=\"" + relationName + "\">\n");
            moml.append("<vertex name=\"vertex1\" value=\"{");
            moml.append(String.valueOf(point[0]) + ", " + point[1]);
            moml.append("}\"/>\n");
            moml.append("</relation>");
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, toplevel, moml.toString());
            request.setUndoable(true);
            toplevel.requestChange((ChangeRequest)request);
        }
    }

    protected class RelationCreator
    extends ActionInteractor {
        public RelationCreator() {
            this.setAction(ActorEditorGraphController.this._newRelationAction);
        }
    }
}

