/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.toolbox.LabelFigure;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.basic.BasicLayoutTarget;
import diva.graph.layout.AbstractGlobalLayout;
import diva.graph.layout.LayoutTarget;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.KeyStroke;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DebugListenerTableau;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.OpenInstanceDialog;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.actor.gui.UserActorLibrary;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.Debuggable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.IOPortController;
import ptolemy.vergil.basic.BasicGraphController;
import ptolemy.vergil.basic.BasicGraphFrame;
import ptolemy.vergil.debugger.BreakpointDialogFactory;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.kernel.ConfigureUnitsAction;
import ptolemy.vergil.kernel.PortDialogAction;
import ptolemy.vergil.toolbox.EditIconAction;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;
import ptolemy.vergil.toolbox.MenuItemFactory;
import ptolemy.vergil.toolbox.PortSite;
import ptolemy.vergil.toolbox.RemoveIconAction;
import ptolemy.vergil.toolbox.RotateOrFlipPorts;

public abstract class ActorController
extends AttributeController {
    protected AttributeController.Access _access;
    protected EditIconAction _editIconAction = new EditIconAction();
    protected RotateOrFlipPorts _flipPortsHorizontal = new RotateOrFlipPorts(2, "Flip Ports Horizontally");
    protected RotateOrFlipPorts _flipPortsVertical = new RotateOrFlipPorts(3, "Flip Ports Vertically");
    protected LookInsideAction _lookInsideAction = new LookInsideAction();
    protected OpenInstanceAction _openInstanceAction = new OpenInstanceAction();
    protected RemoveIconAction _removeIconAction = new RemoveIconAction();
    protected RotateOrFlipPorts _rotatePortsClockwise = new RotateOrFlipPorts(0, "Rotate Ports Clockwise");
    protected RotateOrFlipPorts _rotatePortsCounterclockwise = new RotateOrFlipPorts(1, "Rotate Ports Counterclockwise");
    private BreakpointDialogFactory _breakpointDialogFactory;
    private ConfigureUnitsAction _configureUnitsAction;
    private ListenToActorAction _listenToActorAction;
    private PortDialogAction _portDialogAction;
    private static Font _portLabelFont = new Font("SansSerif", 0, 8);

    public ActorController(GraphController controller) {
        this(controller, FULL);
    }

    public ActorController(GraphController controller, AttributeController.Access access) {
        super(controller, access);
        this._access = access;
        if (access == FULL) {
            this._portDialogAction = new PortDialogAction("Ports");
            this._configureMenuFactory.addAction(this._portDialogAction, "Customize");
            this._configureUnitsAction = new ConfigureUnitsAction("Units Constraints");
            this._configureMenuFactory.addAction(this._configureUnitsAction, "Customize");
        }
        if (this._configuration != null) {
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._lookInsideAction));
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._openInstanceAction));
            if (access == FULL) {
                this._createAppearanceSubmenu();
            }
        }
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(new SaveInLibraryAction()));
        this._listenToActorAction = new ListenToActorAction((BasicGraphController)this.getController());
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._listenToActorAction));
        this._listenToActorAction.setConfiguration(this._configuration);
        if (access == FULL) {
            this._breakpointDialogFactory = new BreakpointDialogFactory((BasicGraphController)this.getController());
            this._menuFactory.addMenuItemFactory(this._breakpointDialogFactory);
        }
    }

    public void addMenuItemFactory(MenuItemFactory menuItemFactory) {
        if (this._access == FULL) {
            this._menuFactory.addMenuItemFactory(menuItemFactory);
        }
    }

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        if (this._portDialogAction != null) {
            this._portDialogAction.setConfiguration(configuration);
        }
        if (this._configureUnitsAction != null) {
            this._configureUnitsAction.setConfiguration(configuration);
        }
        if (this._listenToActorAction != null) {
            this._listenToActorAction.setConfiguration(this._configuration);
        }
        if (this._configuration != null) {
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._lookInsideAction));
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._openInstanceAction));
            if (this._access == FULL) {
                this._createAppearanceSubmenu();
            }
        }
    }

    private LabelFigure _createPortLabelFigure(String string, Font font, double x, double y, int direction) {
        LabelFigure label;
        if (direction == 5) {
            label = new LabelFigure(string, font, 1.0, 6);
            label.translateTo(x, y + 5.0);
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966, x, y + 5.0);
            label.transform(rotate);
        } else if (direction == 3) {
            label = new LabelFigure(string, font, 1.0, 6);
            label.translateTo(x + 5.0, y);
        } else if (direction == 7) {
            label = new LabelFigure(string, font, 1.0, 4);
            label.translateTo(x - 5.0, y);
        } else {
            label = new LabelFigure(string, font, 1.0, 6);
            label.translateTo(x, y - 5.0);
            AffineTransform rotate = AffineTransform.getRotateInstance(-1.5707963267948966, x, y - 5.0);
            label.transform(rotate);
        }
        return label;
    }

    private void _createAppearanceSubmenu() {
        this._editIconAction.setConfiguration(this._configuration);
        this._removeIconAction.setConfiguration(this._configuration);
        Action[] actions = new Action[]{this._editIconAction, this._removeIconAction, this._flipPortsHorizontal, this._flipPortsVertical, this._rotatePortsClockwise, this._rotatePortsCounterclockwise};
        this._appearanceMenuActionFactory.addActions(actions, "Appearance");
    }

    public class EntityLayout
    extends AbstractGlobalLayout {
        public EntityLayout() {
            super((LayoutTarget)new BasicLayoutTarget(ActorController.this.getController()));
        }

        public void layout(Object node) {
            GraphModel model = ActorController.this.getController().getGraphModel();
            Iterator nodes = model.nodes(node);
            Vector<Port> westPorts = new Vector<Port>();
            Vector<Port> eastPorts = new Vector<Port>();
            Vector<Port> southPorts = new Vector<Port>();
            Vector<Port> northPorts = new Vector<Port>();
            while (nodes.hasNext()) {
                Port port = (Port)nodes.next();
                int portRotation = IOPortController._getCardinality(port);
                int direction = IOPortController._getDirection(portRotation);
                if (direction == 7) {
                    westPorts.add(port);
                    continue;
                }
                if (direction == 1) {
                    northPorts.add(port);
                    continue;
                }
                if (direction == 3) {
                    eastPorts.add(port);
                    continue;
                }
                southPorts.add(port);
            }
            CompositeFigure figure = (CompositeFigure)this.getLayoutTarget().getVisualObject(node);
            this._reOrderPorts(westPorts);
            this._placePortFigures(figure, westPorts, 7);
            this._reOrderPorts(eastPorts);
            this._placePortFigures(figure, eastPorts, 3);
            this._reOrderPorts(southPorts);
            this._placePortFigures(figure, southPorts, 5);
            this._reOrderPorts(northPorts);
            this._placePortFigures(figure, northPorts, 1);
        }

        private void _reOrderPorts(Vector ports) {
            int size = ports.size();
            Enumeration enumeration = ports.elements();
            StringAttribute ordinal = null;
            int number = 0;
            int index = 0;
            while (enumeration.hasMoreElements()) {
                Port port = (Port)enumeration.nextElement();
                ordinal = (StringAttribute)port.getAttribute("_ordinal");
                if (ordinal != null) {
                    number = Integer.parseInt(ordinal.getExpression());
                    if (number >= size) {
                        ports.remove(index);
                        try {
                            ordinal.setExpression(Integer.toString(size - 1));
                        }
                        catch (Exception e) {
                            MessageHandler.error((String)"Error setting ordinal property", (Throwable)e);
                        }
                        ports.add(port);
                    } else if (number < 0) {
                        ports.remove(index);
                        try {
                            ordinal.setExpression(Integer.toString(0));
                        }
                        catch (Exception e) {
                            MessageHandler.error((String)"Error setting ordinal property", (Throwable)e);
                        }
                        ports.add(0, port);
                    } else if (number != index) {
                        ports.remove(index);
                        ports.add(number, port);
                    }
                }
                ++index;
            }
        }

        private void _placePortFigures(CompositeFigure figure, List portList, int direction) {
            Iterator ports = portList.iterator();
            int number = 0;
            int count = portList.size();
            Figure background = figure.getBackgroundFigure();
            if (background == null) {
                background = figure;
            }
            while (ports.hasNext()) {
                LabelFigure labelFigure;
                Port port = (Port)ports.next();
                Figure portFigure = ActorController.this.getController().getFigure((Object)port);
                if (portFigure == null) continue;
                Rectangle2D portBounds = portFigure.getShape().getBounds2D();
                PortSite site = new PortSite(background, port, number, count, direction);
                ++number;
                double x = site.getX() - portBounds.getCenterX();
                double y = site.getY() - portBounds.getCenterY();
                portFigure.translate(x, y);
                Attribute showRateAttribute = port.getAttribute("_showRate");
                if (port instanceof IOPort && showRateAttribute instanceof Variable) {
                    boolean showRate = false;
                    try {
                        showRate = ((Variable)showRateAttribute).getToken().equals(BooleanToken.TRUE);
                    }
                    catch (Exception exception) {}
                    if (showRate) {
                        String altName;
                        String rateString = "";
                        Variable rateParameter = null;
                        if (((IOPort)port).isInput()) {
                            rateParameter = (Variable)port.getAttribute("tokenConsumptionRate");
                            if (rateParameter == null) {
                                altName = "_tokenConsumptionRate";
                                rateParameter = (Variable)port.getAttribute(altName);
                            }
                        } else if (((IOPort)port).isOutput() && (rateParameter = (Variable)port.getAttribute("tokenProductionRate")) == null) {
                            altName = "_tokenProductionRate";
                            rateParameter = (Variable)port.getAttribute(altName);
                        }
                        if (rateParameter != null) {
                            try {
                                rateString = rateParameter.getToken().toString();
                            }
                            catch (KernelException kernelException) {}
                        }
                        labelFigure = ActorController.this._createPortLabelFigure(rateString, _portLabelFont, x, y, direction);
                        labelFigure.setFillPaint((Paint)Color.BLUE);
                        figure.add((Figure)labelFigure);
                    }
                }
                Attribute showAttribute = port.getAttribute("_showName");
                String toShow = null;
                if (showAttribute != null) {
                    boolean show = true;
                    if (showAttribute instanceof Parameter) {
                        try {
                            Token token = ((Parameter)showAttribute).getToken();
                            if (token instanceof BooleanToken) {
                                show = ((BooleanToken)token).booleanValue();
                            }
                        }
                        catch (IllegalActionException illegalActionException) {}
                    }
                    if (show) {
                        toShow = port.getDisplayName();
                    }
                }
                Attribute showInfo = port.getAttribute("_showInfo");
                try {
                    if (showInfo instanceof Variable && !((Variable)showInfo).isStringMode()) {
                        String value = ((Variable)showInfo).getToken().toString();
                        toShow = toShow != null ? String.valueOf(toShow) + " (" + value + ")" : value;
                    } else if (showInfo instanceof Settable) {
                        toShow = toShow != null ? String.valueOf(toShow) + " (" + ((Settable)showInfo).getExpression() + ")" : ((Settable)showInfo).getExpression();
                    }
                }
                catch (IllegalActionException e) {
                    toShow = String.valueOf(toShow) + e.getMessage();
                }
                if (toShow == null) continue;
                labelFigure = ActorController.this._createPortLabelFigure(toShow, _portLabelFont, x, y, direction);
                figure.add((Figure)labelFigure);
            }
        }
    }

    public static class ListenToActorAction
    extends FigureAction {
        private Configuration _configuration;
        private BasicGraphController _controller;
        private NamedObj _target;

        public ListenToActorAction(BasicGraphController controller) {
            super("Listen to Actor");
            this._controller = controller;
        }

        public ListenToActorAction(NamedObj target, BasicGraphController controller) {
            super("Listen to Actor");
            this._target = target;
            this._controller = controller;
        }

        public void actionPerformed(ActionEvent event) {
            if (this._configuration == null) {
                MessageHandler.error((String)"Cannot listen to actor without a configuration.");
                return;
            }
            super.actionPerformed(event);
            NamedObj object = this._target;
            if (object == null) {
                object = this.getTarget();
            }
            try {
                BasicGraphFrame frame = this._controller.getFrame();
                Tableau tableau = frame.getTableau();
                Effigy effigy = (Effigy)tableau.getContainer();
                TextEffigy textEffigy = new TextEffigy(effigy, effigy.uniqueName("debugListener" + object.getName()));
                DebugListenerTableau debugTableau = new DebugListenerTableau(textEffigy, textEffigy.uniqueName("debugListener" + object.getName()));
                debugTableau.setDebuggable((Debuggable)object);
            }
            catch (KernelException ex) {
                MessageHandler.error((String)"Failed to create debug listener.", (Throwable)ex);
            }
        }

        public void setConfiguration(Configuration configuration) {
            this._configuration = configuration;
        }
    }

    private class LookInsideAction
    extends FigureAction {
        public LookInsideAction() {
            super("Open Actor");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent event) {
            if (ActorController.this._configuration == null) {
                MessageHandler.error((String)"Cannot open an actor without a configuration.");
                return;
            }
            super.actionPerformed(event);
            NamedObj object = this.getTarget();
            try {
                ActorController.this._configuration.openModel(object);
            }
            catch (Exception ex) {
                MessageHandler.error((String)"Open actor failed.", (Throwable)ex);
            }
        }
    }

    private class OpenInstanceAction
    extends FigureAction {
        public OpenInstanceAction() {
            super("Open Instance");
        }

        public void actionPerformed(ActionEvent event) {
            Frame parent;
            DialogTableau dialogTableau;
            if (ActorController.this._configuration == null) {
                MessageHandler.error((String)"Cannot open an instance without a configuration.");
                return;
            }
            super.actionPerformed(event);
            NamedObj object = this.getTarget();
            if (object instanceof CompositeEntity) {
                try {
                    ActorController.this._configuration.openInstance(object);
                }
                catch (Exception ex) {
                    MessageHandler.error((String)"Open instance failed.", (Throwable)ex);
                }
            } else if (object instanceof Entity && (dialogTableau = DialogTableau.createDialog(parent = this.getFrame(), ActorController.this._configuration, ((TableauFrame)parent).getEffigy(), OpenInstanceDialog.class, (Entity)object)) != null) {
                dialogTableau.show();
            }
        }
    }

    private class SaveInLibraryAction
    extends FigureAction {
        public SaveInLibraryAction() {
            super("Save Actor In Library");
            this.putValue("tooltip", "Save the actor as a component in the user library");
        }

        public void actionPerformed(ActionEvent event) {
            super.actionPerformed(event);
            NamedObj object = this.getTarget();
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                try {
                    UserActorLibrary.saveComponentInLibrary(ActorController.this._configuration, entity);
                }
                catch (Exception exception) {
                    MessageHandler.error((String)("Failed to save \"" + entity.getName() + "\"."));
                }
            }
        }
    }
}

