/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.ErrorHandler;
import ptolemy.util.StringUtilities;

public class VergilErrorHandler
implements ErrorHandler {
    private boolean _skippingEnabled = false;
    private boolean _skipping = false;

    public void enableErrorSkipping(boolean enable) {
        this._skippingEnabled = enable;
        if (!enable) {
            this._skipping = false;
        }
    }

    public int handleError(String element, NamedObj context, Throwable exception) {
        if (this._skipping) {
            return 0;
        }
        Component parentWindow = GraphicalMessageHandler.getContext();
        String message = "Error encountered in:\n" + StringUtilities.split((String)element) + "\n" + exception.getMessage();
        Object[] messageArray = new Object[]{StringUtilities.ellipsis((String)message, (int)2000)};
        if (context == null) {
            messageArray[0] = messageArray[0] + "\nThis is a top-level element, so cannot continue.";
            Object[] options = new Object[]{"Display stack trace", "Cancel"};
            int selected = JOptionPane.showOptionDialog(parentWindow, messageArray, "Error", 0, 0, null, options, options[0]);
            if (selected == 0) {
                return this._showStackTrace(parentWindow, false, false, exception, message);
            }
            return 1;
        }
        if (this._skippingEnabled) {
            Object[] options = new Object[]{"Skip element", "Skip remaining errors", "Display stack trace", "Cancel"};
            int selected = JOptionPane.showOptionDialog(parentWindow, messageArray, "Error", 0, 0, null, options, options[0]);
            if (selected == 3) {
                return 1;
            }
            if (selected == 2) {
                return this._showStackTrace(parentWindow, true, this._skippingEnabled, exception, message);
            }
            if (selected == 1) {
                this._skipping = true;
            }
            return 0;
        }
        Object[] options = new Object[]{"Skip element", "Display stack trace", "Cancel"};
        int selected = JOptionPane.showOptionDialog(parentWindow, messageArray, "Error", 0, 0, null, options, options[0]);
        if (selected == 1) {
            return this._showStackTrace(parentWindow, false, this._skippingEnabled, exception, message);
        }
        if (selected == 2) {
            return 1;
        }
        return 0;
    }

    private int _showStackTrace(Component context, boolean skipElement, boolean skippingEnabled, Throwable exception, String info) {
        JTextArea text = new JTextArea(KernelException.stackTraceToString((Throwable)exception), 60, 80);
        JScrollPane scrollPane = new JScrollPane(text);
        scrollPane.setPreferredSize(new Dimension(600, 300));
        text.setCaretPosition(0);
        text.setEditable(false);
        Object[] message = new Object[2];
        String string = info != null ? String.valueOf(info) + "\n" + exception.getMessage() : exception.getMessage();
        message[0] = StringUtilities.ellipsis((String)string, (int)400);
        message[1] = scrollPane;
        Object[] options = null;
        options = skippingEnabled ? new Object[]{"Skip element", "Skip remaining errors", "Cancel"} : (skipElement ? new Object[]{"Skip element", "Cancel"} : new Object[]{"Cancel"});
        int selected = JOptionPane.showOptionDialog(context, message, "Stack trace", 0, 0, null, options, options[0]);
        if (selected == options.length - 1) {
            return 1;
        }
        if (skippingEnabled && selected == 1) {
            this._skipping = true;
        }
        return 0;
    }
}

