/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui.demo;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ptolemy.gui.BasicJApplet;

public class ShowRawDocumentApplet
extends BasicJApplet {
    private BufferedReader _bufferedReader;
    private JTextArea _jTextArea;
    private JScrollPane _scrollPane;

    public void init() {
        block23: {
            super.init();
            String rowsString = this.getParameter("rows");
            int rows = rowsString != null ? Integer.parseInt(rowsString) : 10;
            String columnsString = this.getParameter("columns");
            int columns = columnsString != null ? Integer.parseInt(columnsString) : 40;
            String sourceURLString = this.getParameter("source");
            URL sourceURL = null;
            if (sourceURLString != null) {
                try {
                    this.showStatus("Reading data . . .");
                    sourceURL = new URL(this.getDocumentBase(), sourceURLString);
                }
                catch (MalformedURLException e) {
                    System.err.println(e.toString());
                }
            }
            new JFrame();
            this._jTextArea = new JTextArea(rows, columns);
            this._jTextArea.setEditable(false);
            this._scrollPane = new JScrollPane(this._jTextArea);
            this.getContentPane().add(this._scrollPane);
            String newline = System.getProperty("line.separator");
            if (sourceURL == null) {
                this.showStatus("Failed to open " + sourceURLString);
                System.err.println("Failed to open " + sourceURLString);
            } else {
                InputStream in = null;
                try {
                    in = sourceURL.openStream();
                    this._bufferedReader = new BufferedReader(new InputStreamReader(in));
                    String line = this._bufferedReader.readLine();
                    while (line != null) {
                        this._jTextArea.append(String.valueOf(line) + newline);
                        line = this._bufferedReader.readLine();
                    }
                    this.showStatus("Done");
                }
                catch (FileNotFoundException e) {
                    System.err.println("File not found: " + e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception ex) {
                            System.err.println("Failed to close " + sourceURLString + ":" + ex);
                        }
                    }
                    break block23;
                }
                catch (IOException e) {
                    try {
                        System.err.println("Error reading input file: " + e);
                        break block23;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception ex) {
                                System.err.println("Failed to close " + sourceURLString + ":" + ex);
                            }
                        }
                    }
                }
                if (in == null) break block23;
                try {
                    in.close();
                }
                catch (Exception ex) {
                    System.err.println("Failed to close " + sourceURLString + ":" + ex);
                }
            }
        }
        this.validate();
        this.repaint();
    }

    public String[][] getParameterInfo() {
        String[][] newinfo = new String[][]{{"columns", "integer", "40"}, {"rows", "integer", "10"}, {"source", "", "URL of the file to be displayed"}};
        return this._concatStringArrays(super.getParameterInfo(), newinfo);
    }
}

