/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import ptolemy.gui.ShellInterpreter;
import ptolemy.util.MessageHandler;

public class ShellTextArea
extends JPanel {
    public String mainPrompt = ">> ";
    public String contPrompt = "";
    public int historyLength = 20;
    private StringBuffer _commandBuffer = new StringBuffer();
    private JTextArea _jTextArea;
    private int _promptCursor = 0;
    private int _historyCursor = 0;
    private Vector _historyCommands = new Vector();
    private String _initialMessage = null;
    private ShellInterpreter _interpreter;

    public ShellTextArea() {
        this((String)null);
    }

    public ShellTextArea(String initialMessage) {
        super(new BorderLayout());
        this._initialMessage = initialMessage;
        this._jTextArea = new JTextArea("", 20, 80);
        JScrollPane jScrollPane = new JScrollPane(this._jTextArea);
        this.add(jScrollPane);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), ""));
        this._jTextArea.addKeyListener(new ShellKeyListener());
    }

    public void addNotify() {
        super.addNotify();
        this.initialize(this._initialMessage);
    }

    public void appendJTextArea(final String text) {
        Runnable doAppendJTextArea = new Runnable(){

            public void run() {
                ShellTextArea.this._jTextArea.append(text);
                ShellTextArea.this._jTextArea.setCaretPosition(ShellTextArea.this._jTextArea.getText().length());
                ShellTextArea shellTextArea = ShellTextArea.this;
                shellTextArea._promptCursor = shellTextArea._promptCursor + text.length();
            }
        };
        SwingUtilities.invokeLater(doAppendJTextArea);
    }

    public void clearJTextArea() {
        Runnable doClearJTextArea = new Runnable(){

            public void run() {
                ShellTextArea.this._jTextArea.setText("");
                ShellTextArea.this._jTextArea.setCaretPosition(0);
                ShellTextArea.this._promptCursor = 0;
            }
        };
        SwingUtilities.invokeLater(doClearJTextArea);
    }

    public ShellInterpreter getInterpreter() {
        return this._interpreter;
    }

    public void initialize(String initialMessage) {
        if (this._jTextArea == null) {
            this._initialMessage = initialMessage;
        } else {
            this._initialMessage = null;
            this.clearJTextArea();
            if (initialMessage != null && !initialMessage.equals("")) {
                this.appendJTextArea(String.valueOf(initialMessage) + "\n" + this.mainPrompt);
            } else {
                this.appendJTextArea(this.mainPrompt);
            }
        }
    }

    public static void main(String[] args) {
        try {
            Runnable doActions = new Runnable(){

                public void run() {
                    try {
                        JFrame jFrame = new JFrame("ShellTextArea Example");
                        WindowAdapter windowListener = new WindowAdapter(){

                            public void windowClosing(WindowEvent e) {
                                System.exit(0);
                            }
                        };
                        jFrame.addWindowListener(windowListener);
                        ShellTextArea exec = new ShellTextArea();
                        jFrame.getContentPane().add(exec);
                        jFrame.pack();
                        jFrame.setVisible(true);
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                        ex.printStackTrace();
                    }
                }
            };
            SwingUtilities.invokeAndWait(doActions);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
    }

    public void replaceRangeJTextArea(final String text, final int start, final int end) {
        Runnable doReplaceRangeJTextArea = new Runnable(){

            public void run() {
                ShellTextArea.this._jTextArea.replaceRange(text, start, end);
            }
        };
        SwingUtilities.invokeLater(doReplaceRangeJTextArea);
    }

    public void returnResult(final String result) {
        Runnable doMakeEditable = new Runnable(){

            public void run() {
                ShellTextArea.this.setEditable(true);
                String toPrint = String.valueOf(result) + "\n" + ShellTextArea.this.mainPrompt;
                ShellTextArea.this.appendJTextArea(toPrint);
            }
        };
        SwingUtilities.invokeLater(doMakeEditable);
    }

    public void setEditable(boolean editable) {
        this._jTextArea.setEditable(editable);
    }

    public void setInterpreter(ShellInterpreter interpreter) {
        this._interpreter = interpreter;
    }

    private void _evalCommand() {
        String newtext = this._jTextArea.getText().substring(this._promptCursor);
        this._promptCursor += newtext.length();
        if (this._commandBuffer.length() > 0) {
            this._commandBuffer.append("\n");
        }
        this._commandBuffer.append(newtext);
        String command = this._commandBuffer.toString();
        if (this._interpreter == null) {
            this.appendJTextArea("\n" + this.mainPrompt);
        } else if (this._interpreter.isCommandComplete(command)) {
            String result;
            this.appendJTextArea("\n");
            Cursor oldCursor = this._jTextArea.getCursor();
            this._jTextArea.setCursor(new Cursor(3));
            try {
                result = this._interpreter.evaluateCommand(command);
            }
            catch (RuntimeException e) {
                MessageHandler.error((String)"Failed to evaluate expression", (Throwable)e);
                String result2 = "Internal error evaluating expression.";
                throw e;
            }
            catch (Exception e) {
                result = e.getMessage();
            }
            if (result != null) {
                if (result.trim().equals("")) {
                    this.appendJTextArea(this.mainPrompt);
                } else {
                    this.appendJTextArea(String.valueOf(result) + "\n" + this.mainPrompt);
                }
            } else {
                this.setEditable(false);
            }
            this._commandBuffer.setLength(0);
            this._jTextArea.setCursor(oldCursor);
            this._updateHistory(command);
        } else {
            this.appendJTextArea("\n" + this.contPrompt);
        }
    }

    private void _nextCommand() {
        String text;
        if (this._historyCursor == 0) {
            text = "";
        } else {
            --this._historyCursor;
            text = (String)this._historyCommands.elementAt(this._historyCommands.size() - this._historyCursor - 1);
        }
        this.replaceRangeJTextArea(text, this._promptCursor, this._jTextArea.getText().length());
    }

    private void _previousCommand() {
        if (this._historyCursor == this._historyCommands.size()) {
            return;
        }
        ++this._historyCursor;
        String text = (String)this._historyCommands.elementAt(this._historyCommands.size() - this._historyCursor);
        this.replaceRangeJTextArea(text, this._promptCursor, this._jTextArea.getText().length());
    }

    private void _updateHistory(String command) {
        this._historyCursor = 0;
        if (this._historyCommands.size() == this.historyLength) {
            this._historyCommands.removeElementAt(0);
        }
        this._historyCommands.addElement(command);
    }

    private class ShellKeyListener
    extends KeyAdapter {
        private ShellKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 0: {
                    if (keyEvent.getKeyChar() != '\b' || ShellTextArea.this._jTextArea.getCaretPosition() != ShellTextArea.this._promptCursor) break;
                    keyEvent.consume();
                    break;
                }
                case 8: {
                    if (ShellTextArea.this._jTextArea.getCaretPosition() != ShellTextArea.this._promptCursor) break;
                    keyEvent.consume();
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 8: {
                    if (ShellTextArea.this._jTextArea.getCaretPosition() != ShellTextArea.this._promptCursor) break;
                    keyEvent.consume();
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!ShellTextArea.this._jTextArea.isEditable()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            block0 : switch (keyEvent.getKeyCode()) {
                case 10: {
                    keyEvent.consume();
                    ShellTextArea.this._evalCommand();
                    break;
                }
                case 8: {
                    if (ShellTextArea.this._jTextArea.getCaretPosition() > ShellTextArea.this._promptCursor) break;
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    if (ShellTextArea.this._jTextArea.getCaretPosition() != ShellTextArea.this._promptCursor) break;
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    ShellTextArea.this._previousCommand();
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    ShellTextArea.this._nextCommand();
                    keyEvent.consume();
                    break;
                }
                case 36: {
                    ShellTextArea.this._jTextArea.setCaretPosition(ShellTextArea.this._promptCursor);
                    keyEvent.consume();
                    break;
                }
                default: {
                    switch (keyEvent.getModifiers()) {
                        case 2: {
                            switch (keyEvent.getKeyCode()) {
                                case 65: {
                                    ShellTextArea.this._jTextArea.setCaretPosition(ShellTextArea.this._promptCursor);
                                    keyEvent.consume();
                                    break block0;
                                }
                                case 78: {
                                    ShellTextArea.this._nextCommand();
                                    keyEvent.consume();
                                    break block0;
                                }
                                case 80: {
                                    ShellTextArea.this._previousCommand();
                                    keyEvent.consume();
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

