/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import ptolemy.gui.SwingWorker;
import ptolemy.util.ExecuteCommands;
import ptolemy.util.StreamExec;
import ptolemy.util.StringUtilities;

public class JTextAreaExec
extends JPanel
implements ExecuteCommands {
    private ActionListener _clearListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            Runnable doAppendJTextArea = new Runnable(){

                public void run() {
                    JTextAreaExec.this._jTextArea.setText(null);
                }
            };
            SwingUtilities.invokeLater(doAppendJTextArea);
        }
    };
    private ActionListener _interruptListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            JTextAreaExec.this._cancelButton.setEnabled(false);
            JTextAreaExec.this.appendJTextArea("Cancel button was pressed");
            JTextAreaExec.this._worker.interrupt();
            JTextAreaExec.this._process.destroy();
            JTextAreaExec.this._enableStartButton();
        }
    };
    private ActionListener _startListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            JTextAreaExec.this._startButton.setEnabled(false);
            JTextAreaExec.this._cancelButton.setEnabled(true);
            JTextAreaExec.this._statusBar.setText("Working...");
            JTextAreaExec.this._worker = new SwingWorker(){

                public Object construct() {
                    return JTextAreaExec.this._executeCommands();
                }

                public void finished() {
                    JTextAreaExec.this._enableStartButton();
                    JTextAreaExec.this._cancelButton.setEnabled(false);
                    JTextAreaExec.this._updateProgressBar(0);
                    JTextAreaExec.this._statusBar.setText(this.get().toString());
                }
            };
            JTextAreaExec.this._worker.start();
        }
    };
    private JButton _cancelButton;
    private JButton _clearButton;
    private List _commands = null;
    private final boolean _debug = false;
    private String[] _envp;
    private JTextArea _jTextArea;
    private Process _process;
    private int _subprocessReturnCode;
    private JProgressBar _progressBar;
    private JLabel _statusBar;
    private JButton _startButton;
    private SwingWorker _worker;
    private File _workingDirectory;

    public JTextAreaExec(String name, boolean showButtons) {
        this.setLayout(new BoxLayout(this, 1));
        this._jTextArea = new JTextArea("", 20, 100);
        this._jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this._jTextArea);
        this.add(jScrollPane);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), name));
        this._progressBar = new JProgressBar();
        this._startButton = new JButton("Start");
        this._startButton.addActionListener(this._startListener);
        this._enableStartButton();
        this._cancelButton = new JButton("Cancel");
        this._cancelButton.addActionListener(this._interruptListener);
        this._cancelButton.setEnabled(false);
        this._clearButton = new JButton("Clear");
        this._clearButton.addActionListener(this._clearListener);
        this._clearButton.setEnabled(true);
        Border spaceBelow = BorderFactory.createEmptyBorder(0, 0, 5, 0);
        if (showButtons) {
            JPanel buttonBox = new JPanel();
            buttonBox.add(this._startButton);
            buttonBox.add(this._cancelButton);
            buttonBox.add(this._clearButton);
            this.setLayout(new BoxLayout(this, 1));
            this.add(buttonBox);
            buttonBox.setBorder(spaceBelow);
            this._statusBar = new JLabel("Click Start to begin", 0);
        } else {
            this._statusBar = new JLabel("", 0);
        }
        this.add(this._progressBar);
        this.add(this._statusBar);
        this._statusBar.setAlignmentX(0.5f);
        Border progressBarBorder = this._progressBar.getBorder();
        this._progressBar.setBorder(BorderFactory.createCompoundBorder(spaceBelow, progressBarBorder));
    }

    public void appendJTextArea(final String text) {
        Runnable doAppendJTextArea = new Runnable(){

            public void run() {
                JTextAreaExec.this._jTextArea.append(String.valueOf(text) + '\n');
                JTextAreaExec.this._jTextArea.setCaretPosition(JTextAreaExec.this._jTextArea.getText().length());
            }
        };
        SwingUtilities.invokeLater(doAppendJTextArea);
    }

    public void appendToPath(String directoryName) {
        String keyPath = "PATH";
        String path = this.getenv(keyPath);
        if (path == null && (path = this.getenv("Path")) != null) {
            keyPath = "Path";
        }
        if (path == null || path.indexOf(String.valueOf(File.pathSeparatorChar) + directoryName + File.pathSeparatorChar) == -1) {
            this._envp = StreamExec.updateEnvironment((String)keyPath, (String)(String.valueOf(File.pathSeparatorChar) + directoryName + File.pathSeparatorChar));
        }
    }

    public void cancel() {
        this._cancelButton.doClick();
    }

    public void clear() {
        this._clearButton.doClick();
        this.updateStatusBar("");
        this._updateProgressBar(0);
    }

    public String getenv(String key) {
        if (this._envp == null) {
            Map<String, String> environmentMap = System.getenv();
            return environmentMap.get(key);
        }
        int i = 0;
        while (i < this._envp.length) {
            String envpKey = this._envp[i].substring(0, this._envp[i].indexOf("="));
            if (key.length() == envpKey.length() && key.regionMatches(false, 0, envpKey, 0, envpKey.length())) {
                return this._envp[i].substring(key.length() + 1, this._envp[i].length());
            }
            ++i;
        }
        return null;
    }

    public int getLastSubprocessReturnCode() {
        return this._subprocessReturnCode;
    }

    public JButton getStartButton() {
        return this._startButton;
    }

    public static void main(String[] args) {
        try {
            Runnable doActions = new Runnable(){

                public void run() {
                    try {
                        JFrame jFrame = new JFrame("JTextAreaExec Example");
                        WindowAdapter windowListener = new WindowAdapter(){

                            public void windowClosing(WindowEvent e) {
                                System.exit(0);
                            }
                        };
                        jFrame.addWindowListener(windowListener);
                        LinkedList<String> execCommands = new LinkedList<String>();
                        execCommands.add("date");
                        execCommands.add("sleep 5");
                        execCommands.add("date");
                        execCommands.add("javac");
                        JTextAreaExec exec = new JTextAreaExec("JTextAreaExec Tester", true);
                        exec.setCommands(execCommands);
                        jFrame.getContentPane().add(exec);
                        jFrame.pack();
                        jFrame.setVisible(true);
                        exec.getStartButton().requestFocus();
                        exec.start();
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                        ex.printStackTrace();
                    }
                }
            };
            SwingUtilities.invokeAndWait(doActions);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
    }

    public void setCommands(List commands) {
        this._commands = commands;
        this._enableStartButton();
    }

    public void setWorkingDirectory(File workingDirectory) {
        this._workingDirectory = workingDirectory;
    }

    public void start() {
        this._startButton.doClick();
    }

    public void stderr(String text) {
        this.appendJTextArea(text);
    }

    public void stdout(String text) {
        this.appendJTextArea(text);
    }

    public void updateStatusBar(final String text) {
        Runnable doUpdateStatusBar = new Runnable(){

            public void run() {
                JTextAreaExec.this._statusBar.setText(text);
                JTextAreaExec.this._jTextArea.append(String.valueOf(text) + '\n');
            }
        };
        SwingUtilities.invokeLater(doUpdateStatusBar);
    }

    private void _enableStartButton() {
        if (this._commands != null && this._commands.size() > 0) {
            this._startButton.setEnabled(true);
        } else {
            this._startButton.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _executeCommands() {
        try {
            Runtime runtime = Runtime.getRuntime();
            try {
                if (this._process != null) {
                    this._process.destroy();
                }
                this._progressBar.setMaximum(this._commands.size());
                int commandCount = 0;
                Iterator commands = this._commands.iterator();
                while (commands.hasNext()) {
                    this._updateProgressBar(++commandCount);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    String[] commandTokens = StringUtilities.tokenizeForExec((String)((String)commands.next()));
                    this.stdout("In \"" + this._workingDirectory + "\", about to execute:\n");
                    StringBuffer statusCommand = new StringBuffer();
                    int i = 0;
                    while (i < commandTokens.length) {
                        this.appendJTextArea("        " + commandTokens[i]);
                        if (statusCommand.length() < 50) {
                            if (statusCommand.length() > 0) {
                                statusCommand.append(" ");
                            }
                            statusCommand.append(commandTokens[i]);
                        }
                        ++i;
                    }
                    if (statusCommand.length() >= 50) {
                        statusCommand.append(" . . .");
                    }
                    this._statusBar.setText("Executing: " + statusCommand.toString());
                    this._process = runtime.exec(commandTokens, this._envp, this._workingDirectory);
                    _StreamReaderThread errorGobbler = new _StreamReaderThread(this._process.getErrorStream(), this);
                    _StreamReaderThread outputGobbler = new _StreamReaderThread(this._process.getInputStream(), this);
                    errorGobbler.start();
                    outputGobbler.start();
                    try {
                        this._subprocessReturnCode = this._process.waitFor();
                        JTextAreaExec jTextAreaExec = this;
                        synchronized (jTextAreaExec) {
                            this._process = null;
                        }
                        if (this._subprocessReturnCode == 0) continue;
                        break;
                    }
                    catch (InterruptedException interrupted) {
                        this.appendJTextArea("InterruptedException: " + interrupted);
                        throw interrupted;
                    }
                }
                this.appendJTextArea("All Done.");
            }
            catch (IOException io) {
                this.appendJTextArea("IOException: " + io);
            }
        }
        catch (InterruptedException interruptedException) {
            this._process.destroy();
            this._updateProgressBar(0);
            return "Interrupted";
        }
        return "All Done";
    }

    private void _updateProgressBar(final int i) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                JTextAreaExec.this._progressBar.setValue(i);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    private static class _StreamReaderThread
    extends Thread {
        private InputStream _inputStream;
        private JTextAreaExec _jTextAreaExec;

        _StreamReaderThread(InputStream inputStream, JTextAreaExec jTextAreaExec) {
            this._inputStream = inputStream;
            this._jTextAreaExec = jTextAreaExec;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this._inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    this._jTextAreaExec.appendJTextArea(line);
                }
            }
            catch (IOException ioe) {
                this._jTextAreaExec.appendJTextArea("IOException: " + ioe);
            }
        }
    }
}

