/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoxLayout;
import ptolemy.actor.gui.Configurer;
import ptolemy.actor.gui.style.CheckBoxStyle;
import ptolemy.actor.gui.style.ChoiceStyle;
import ptolemy.actor.gui.style.EditableChoiceStyle;
import ptolemy.actor.gui.style.FileChooserStyle;
import ptolemy.actor.gui.style.LineStyle;
import ptolemy.actor.gui.style.NotEditableLineStyle;
import ptolemy.actor.gui.style.ParameterEditorStyle;
import ptolemy.actor.gui.style.TextStyle;
import ptolemy.data.expr.Parameter;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.gui.Top;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.MoMLChangeRequest;

public class StyleConfigurer
extends Query
implements QueryListener {
    private NamedObj _object;
    private boolean _originalExpertMode = false;
    private Map _originalValues = new HashMap();
    private ParameterEditorStyle[] _parameterStyles;

    public StyleConfigurer(NamedObj object) throws IllegalActionException {
        this.addQueryListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this._object = object;
        this.setTextWidth(25);
        try {
            Parameter container = new Parameter();
            this._parameterStyles = new ParameterEditorStyle[7];
            this._parameterStyles[0] = new LineStyle((NamedObj)container, "Line");
            this._parameterStyles[1] = new CheckBoxStyle(container, "Check Box");
            this._parameterStyles[2] = new ChoiceStyle((NamedObj)container, "Choice");
            this._parameterStyles[3] = new EditableChoiceStyle((NamedObj)container, "EditableChoice");
            this._parameterStyles[4] = new TextStyle((NamedObj)container, "Text");
            this._parameterStyles[5] = new FileChooserStyle((NamedObj)container, "FileChooser");
            this._parameterStyles[6] = new NotEditableLineStyle((NamedObj)container, "Fixed");
        }
        catch (NameDuplicationException ex) {
            throw new InternalErrorException(ex.getMessage());
        }
        for (Settable param : object.attributeList(Settable.class)) {
            if (!Configurer.isVisible(this._object, param)) continue;
            boolean foundOne = false;
            Iterator styles = ((NamedObj)param).attributeList(ParameterEditorStyle.class).iterator();
            ParameterEditorStyle foundStyle = null;
            while (styles.hasNext()) {
                foundOne = true;
                foundStyle = (ParameterEditorStyle)((Object)styles.next());
            }
            ArrayList<String> styleList = new ArrayList<String>();
            int defaultIndex = 0;
            if (param.getVisibility() == Settable.NOT_EDITABLE) {
                styleList.add("Fixed");
                defaultIndex = 0;
            } else {
                int count = 0;
                int i = 0;
                while (i < this._parameterStyles.length && this._parameterStyles[i] != null) {
                    if (foundOne && ((Object)((Object)this._parameterStyles[i])).getClass() == ((Object)((Object)foundStyle)).getClass()) {
                        defaultIndex = count++;
                        if (foundStyle.acceptable(param)) {
                            styleList.add(this._parameterStyles[i].getName());
                        }
                    } else if (this._parameterStyles[i].acceptable(param)) {
                        styleList.add(this._parameterStyles[i].getName());
                        ++count;
                    }
                    ++i;
                }
            }
            String[] styleArray = styleList.toArray(new String[styleList.size()]);
            this.addChoice(param.getName(), param.getName(), styleArray, styleArray[defaultIndex]);
        }
        this._originalExpertMode = this._object.getAttribute("_expertMode") != null;
        this.addCheckBox("expertMode", "expert mode", this._originalExpertMode);
    }

    public void changed(String name) {
        StringBuffer moml = new StringBuffer();
        if (name.equals("expertMode")) {
            boolean toExpert;
            Attribute previousExpert = this._object.getAttribute("_expertMode");
            boolean isExpert = previousExpert != null;
            if (isExpert != (toExpert = this.getBooleanValue("expertMode"))) {
                if (isExpert) {
                    moml.append("<deleteProperty name=\"_expertMode\"/>");
                } else {
                    moml.append("<property name=\"_expertMode\" class=\"ptolemy.kernel.util.SingletonAttribute\"/>");
                }
            }
        } else {
            ParameterEditorStyle found = null;
            int i = 0;
            while (i < this._parameterStyles.length && found == null) {
                if (this.getStringValue(name).equals(this._parameterStyles[i].getName())) {
                    found = this._parameterStyles[i];
                }
                ++i;
            }
            moml.append("<group>");
            Attribute param = this._object.getAttribute(name);
            moml.append("<property name=\"" + param.getName() + "\">");
            Iterator styles = param.attributeList(ParameterEditorStyle.class).iterator();
            boolean foundOne = false;
            while (styles.hasNext()) {
                foundOne = true;
                ParameterEditorStyle style = (ParameterEditorStyle)((Object)styles.next());
                moml.append("<deleteProperty name=\"" + style.getName() + "\"/>\n");
            }
            if (foundOne) {
                moml.append("</property>");
                moml.append("<property name=\"" + param.getName() + "\">");
            }
            moml.append("<group name=\"auto\">");
            moml.append(found.exportMoML("style"));
            moml.append("</group></property></group>");
        }
        MoMLChangeRequest change = new MoMLChangeRequest((Object)this, this._object, moml.toString());
        this._object.requestChange((ChangeRequest)change);
    }

    public void restore() {
        Top.deferIfNecessary(new Runnable(){

            public void run() {
                boolean isExpert;
                Attribute currentExpert = StyleConfigurer.this._object.getAttribute("_expertMode");
                boolean bl = isExpert = currentExpert != null;
                if (isExpert != StyleConfigurer.this._originalExpertMode) {
                    try {
                        if (isExpert) {
                            currentExpert.setContainer(null);
                        } else {
                            new Attribute(StyleConfigurer.this._object, "_expertMode");
                        }
                    }
                    catch (KernelException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                for (Map.Entry entry : StyleConfigurer.this._originalValues.entrySet()) {
                    Settable param = (Settable)StyleConfigurer.this._object.getAttribute((String)entry.getKey());
                    try {
                        param.setExpression((String)entry.getValue());
                    }
                    catch (IllegalActionException illegalActionException) {
                        throw new InternalErrorException("Cannot restore style value!");
                    }
                }
            }
        });
    }
}

