/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui.exec;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.exec.ExecShellEffigy;
import ptolemy.gui.ShellInterpreter;
import ptolemy.gui.ShellTextArea;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.StringUtilities;

public class ExecShellTableau
extends Tableau
implements ShellInterpreter {
    public ExecShellFrame _frame = new ExecShellFrame(this);
    private Process _interpreter;

    public ExecShellTableau(ExecShellEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setFrame(this._frame);
        try {
            this._interpreter = Runtime.getRuntime().exec("bash -i");
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, (Throwable)ex, "Failed to create Process");
        }
    }

    public String evaluateCommand(String command) throws Exception {
        this._executeCommand(command);
        return "";
    }

    public boolean isCommandComplete(String command) {
        return true;
    }

    public void stderr(String text) {
        this._frame._shellTextArea.appendJTextArea(String.valueOf(text) + "\n");
    }

    public void stdout(String text) {
        this._frame._shellTextArea.appendJTextArea(String.valueOf(text) + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _executeCommand(String command) {
        if (command == null || command.length() == 0) {
            return "";
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            try {
                String[] commandTokens = StringUtilities.tokenizeForExec((String)command);
                StringBuffer statusCommand = new StringBuffer();
                int i = 0;
                while (i < commandTokens.length) {
                    if (statusCommand.length() < 50) {
                        if (statusCommand.length() > 0) {
                            statusCommand.append(" ");
                        }
                        statusCommand.append(commandTokens[i]);
                    }
                    ++i;
                }
                if (statusCommand.length() >= 50) {
                    statusCommand.append(" . . .");
                }
                this._interpreter = runtime.exec(commandTokens);
                _StreamReaderThread errorGobbler = new _StreamReaderThread(this._interpreter.getErrorStream(), this);
                _StreamReaderThread outputGobbler = new _StreamReaderThread(this._interpreter.getInputStream(), this);
                errorGobbler.start();
                outputGobbler.start();
                try {
                    this._interpreter.waitFor();
                    ExecShellTableau execShellTableau = this;
                    synchronized (execShellTableau) {
                        this._interpreter = null;
                    }
                }
                catch (InterruptedException interrupted) {
                    this.stderr("InterruptedException: " + interrupted);
                    throw interrupted;
                }
            }
            catch (IOException io) {
                this.stderr("IOException: " + KernelException.stackTraceToString((Throwable)io));
            }
        }
        catch (InterruptedException interruptedException) {
            return "Interrupted";
        }
        return "All Done";
    }

    public class ExecShellFrame
    extends TableauFrame {
        public ShellTextArea _shellTextArea;

        public ExecShellFrame(Tableau tableau) throws IllegalActionException, NameDuplicationException {
            super(tableau);
            JPanel component = new JPanel();
            component.setLayout(new BoxLayout(component, 1));
            this._shellTextArea = new ShellTextArea();
            this._shellTextArea.setInterpreter(ExecShellTableau.this);
            this._shellTextArea.mainPrompt = "% ";
            component.add(this._shellTextArea);
            this.getContentPane().add((Component)component, "Center");
        }

        protected void _help() {
            try {
                URL doc = this.getClass().getClassLoader().getResource("ptolemy/actor/gui/ptjacl/help.htm");
                this.getConfiguration().openModel(null, doc, doc.toExternalForm());
            }
            catch (Exception ex) {
                System.out.println("ExecShellTableau._help(): " + ex);
                this._about();
            }
        }
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof ExecShellEffigy) {
                return new ExecShellTableau((ExecShellEffigy)effigy, "ExecShellTableau");
            }
            return null;
        }
    }

    private static class _StreamReaderThread
    extends Thread {
        private InputStream _inputStream;
        private ExecShellTableau _execShellTableau;

        _StreamReaderThread(InputStream inputStream, ExecShellTableau execShellTableau) {
            this._inputStream = inputStream;
            this._execShellTableau = execShellTableau;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this._inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    this._execShellTableau.stdout(line);
                }
            }
            catch (IOException ioe) {
                this._execShellTableau.stderr("IOException: " + ioe);
            }
        }
    }
}

