/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.HTMLViewer;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;

public class WelcomeWindow
extends HTMLViewer {
    private JPanel _closePanel;
    private BooleanToken _showWelcomeWindowAtStartup;
    private JCheckBox _startupCheck;
    private JButton _closeButton;

    public WelcomeWindow() {
        this.setResizable(false);
        this._statusBar = null;
        this._closePanel = new JPanel();
        this._closePanel.setBackground(new Color(227, 231, 236));
        this._closePanel.setSize(401, 100);
        this._closePanel.setLayout(new BorderLayout());
        this._startupCheck = new JCheckBox("<html><table cellpadding=0><tr><td width=9/><td><font size=3>Show this dialog upon startup </font></td></tr></table></html>", true);
        this._startupCheck.setBackground(new Color(227, 231, 236));
        this._closeButton = new JButton("Close");
        this._closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WelcomeWindow.this.setVisible(false);
                WelcomeWindow.this.close();
            }
        });
        this._closePanel.add((Component)this._startupCheck, "West");
        this._closePanel.add((Component)this._closeButton, "East");
    }

    public void pack() {
        this.hideMenuBar();
        this.getContentPane().add((Component)this._closePanel, "South");
        super.pack();
    }

    public void setTitle(String title) {
        super.setTitle(this._getName());
    }

    public void show() {
        Configuration configuration = this.getConfiguration();
        this._showWelcomeWindowAtStartup = (BooleanToken)PtolemyPreferences.preferenceValue((NamedObj)configuration, "_showWelcomeWindowAtStartup");
        if (this._showWelcomeWindowAtStartup != null && !this._showWelcomeWindowAtStartup.booleanValue()) {
            super._close();
            return;
        }
        super.show();
    }

    protected boolean _close() {
        Configuration configuration = this.getConfiguration();
        if (this._showWelcomeWindowAtStartup == null && !this._startupCheck.isSelected() || this._showWelcomeWindowAtStartup != null && this._showWelcomeWindowAtStartup.booleanValue() != this._startupCheck.isSelected()) {
            try {
                PtolemyPreferences preferences = PtolemyPreferences.getPtolemyPreferencesWithinConfiguration(configuration);
                SingletonParameter showWelcomeWindowAtStartupParameter = new SingletonParameter((NamedObj)preferences, "_showWelcomeWindowAtStartup");
                showWelcomeWindowAtStartupParameter.setToken((Token)(this._startupCheck.isSelected() ? BooleanToken.TRUE : BooleanToken.FALSE));
                preferences.save();
            }
            catch (Exception ex) {
                MessageHandler.error((String)"Failed to update preferences andsave _showWelcomeWindowAtStarupPreferences", (Throwable)ex);
            }
        }
        return super._close();
    }

    protected String _getName() {
        return "Welcome";
    }
}

