/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.util.Iterator;
import java.util.List;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.TextEditor;
import ptolemy.actor.gui.TokenEffigy;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class TokenTableau
extends Tableau {
    private TextEditor _editor;

    public TokenTableau(Effigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.createFrame(null);
    }

    public TokenTableau(Effigy container, String name, TableauFrame frame) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.createFrame(frame);
    }

    public void append(Token token) throws IllegalActionException {
        if (this._editor != null) {
            this._editor.text.append(token.toString());
        }
    }

    public void append(List list) throws IllegalActionException {
        if (this._editor != null) {
            Iterator tokens = list.iterator();
            while (tokens.hasNext()) {
                this._editor.text.append(tokens.next().toString());
            }
        }
    }

    public static boolean canDisplay(Token token) {
        return true;
    }

    public void clear() {
        if (this._editor != null) {
            this._editor.text.setText("");
        }
    }

    public void createFrame(TableauFrame frame) throws IllegalActionException {
        TokenEffigy effigy = (TokenEffigy)this.getContainer();
        if (!(frame instanceof TextEditor)) {
            frame = new TextEditor("Token display");
        }
        this.setFrame(frame);
        frame.setTableau(this);
        ((TextEditor)frame).text.setEditable(false);
        Iterator tokens = effigy.getTokens().iterator();
        while (tokens.hasNext()) {
            ((TextEditor)frame).text.append(tokens.next().toString());
            ((TextEditor)frame).text.append("\n");
        }
        this._editor = (TextEditor)frame;
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof TokenEffigy) {
                TokenTableau tableau = (TokenTableau)effigy.getEntity("tokenTableau");
                if (tableau != null) {
                    return tableau;
                }
                return new TokenTableau(effigy, "tokenTableau");
            }
            return null;
        }
    }
}

