/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.actor.gui.TextEditor;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class TextEditorTableau
extends Tableau {
    public TextEditorTableau(TextEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        this(container, name, null);
    }

    public TextEditorTableau(TextEffigy container, String name, TextEditor editor) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        String title = "Unnamed";
        TextEditor frame = editor;
        if (frame == null) {
            frame = new TextEditor(title, container.getDocument());
        }
        frame.text.setColumns(80);
        frame.text.setRows(40);
        this.setFrame(frame);
        frame.setTableau(this);
    }

    public void setEditable(boolean flag) {
        super.setEditable(flag);
        TextEditor editor = (TextEditor)this.getFrame();
        if (editor.text != null) {
            editor.text.setEditable(flag);
        }
    }

    public static class Factory
    extends TableauFactory {
        private Constructor _tableauConstructor;
        private Method _newTextEffigyText;
        private Method _newTextEffigyURL;

        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            String editorPreference = ".";
            try {
                editorPreference = System.getProperty("ptolemy.user.texteditor", ".");
            }
            catch (SecurityException securityException) {}
            try {
                Class<?> effigyClass;
                Class<?> tableauClass;
                if (editorPreference.equals("emacs")) {
                    tableauClass = Class.forName("ptolemy.actor.gui.ExternalTextTableau");
                    effigyClass = Class.forName("ptolemy.actor.gui.ExternalTextEffigy");
                } else {
                    tableauClass = Class.forName("ptolemy.actor.gui.TextEditorTableau");
                    effigyClass = Class.forName("ptolemy.actor.gui.TextEffigy");
                }
                this._tableauConstructor = tableauClass.getConstructor(TextEffigy.class, String.class);
                this._newTextEffigyText = effigyClass.getMethod("newTextEffigy", CompositeEntity.class, String.class);
                this._newTextEffigyURL = effigyClass.getMethod("newTextEffigy", CompositeEntity.class, URL.class, URL.class);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalActionException(ex.toString());
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalActionException(ex.toString());
            }
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            TextEffigy textEffigy;
            if (effigy instanceof TextEffigy) {
                TextEditorTableau tableau = (TextEditorTableau)effigy.getEntity("textTableau");
                if (tableau == null) {
                    tableau = (TextEditorTableau)((Object)this._tableauConstructor.newInstance(new Object[]{effigy, "textTableau"}));
                }
                tableau.setEditable(effigy.isModifiable());
                return tableau;
            }
            for (TextEffigy textEffigy2 : effigy.entityList(TextEffigy.class)) {
                if (!textEffigy2.getName().equals("textEffigy")) continue;
                return this.createTableau(textEffigy2);
            }
            URL url = effigy.uri.getURL();
            if (effigy instanceof PtolemyEffigy) {
                String moml = ((PtolemyEffigy)effigy).getModel().exportMoML();
                textEffigy = (TextEffigy)((Object)this._newTextEffigyText.invoke(null, new Object[]{effigy, moml}));
                textEffigy.setModifiable(false);
                textEffigy.setName("textEffigy");
            } else {
                textEffigy = (TextEffigy)((Object)this._newTextEffigyURL.invoke(null, new Object[]{effigy, url, url}));
                textEffigy.setName("textEffigy");
            }
            TextEditorTableau textTableau = (TextEditorTableau)this.createTableau(textEffigy);
            if (url != null) {
                textEffigy.identifier.setExpression(url.toExternalForm());
            }
            return textTableau;
        }
    }
}

