/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import ptolemy.actor.gui.Placeable;
import ptolemy.actor.gui.TableauFrame;

public class TextEditor
extends TableauFrame
implements DocumentListener,
Printable {
    public JTextArea text;
    protected JScrollPane _scrollPane;

    public TextEditor() {
        this("Unnamed");
    }

    public TextEditor(String title) {
        this(title, (Document)null);
    }

    public TextEditor(String title, Document document) {
        this(title, document, null);
    }

    public TextEditor(String title, Document document, Placeable placeable) {
        super(null, null, placeable);
        this.setTitle(title);
        this.text = new JTextArea(document);
        document = this.text.getDocument();
        document.addDocumentListener(this);
        this._scrollPane = new JScrollPane(this.text);
        this.getContentPane().add((Component)this._scrollPane, "Center");
        this._initialSaveAsFileName = "data.txt";
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public Color getBackground() {
        return this._scrollPane.getBackground();
    }

    public void insertUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    public int print(Graphics graphics, PageFormat format, int index) throws PrinterException {
        if (graphics == null) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(this.getFont().deriveFont(9.0f));
        double bottomMargin = format.getHeight() - format.getImageableHeight() - format.getImageableY();
        double lineHeight = graphics2D.getFontMetrics().getHeight() - graphics2D.getFontMetrics().getLeading() / 2;
        int linesPerPage = (int)Math.floor((format.getHeight() - format.getImageableY() - bottomMargin) / lineHeight);
        int startLine = linesPerPage * index;
        if (startLine > this.text.getLineCount()) {
            return 1;
        }
        int cfr_ignored_0 = this.text.getLineCount() / linesPerPage;
        int endLine = startLine + linesPerPage;
        int linePosition = (int)Math.ceil(format.getImageableY() + lineHeight);
        int line = startLine;
        while (line < endLine) {
            try {
                String linetext = this.text.getText(this.text.getLineStartOffset(line), this.text.getLineEndOffset(line) - this.text.getLineStartOffset(line));
                graphics2D.drawString(linetext, (int)format.getImageableX(), linePosition);
            }
            catch (BadLocationException badLocationException) {}
            linePosition = (int)((double)linePosition + lineHeight);
            if ((double)linePosition > format.getHeight() - bottomMargin) break;
            ++line;
        }
        return 0;
    }

    public void removeUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    public void scrollToEnd() {
        this.text.scrollRectToVisible(new Rectangle(new Point(0, this.text.getHeight())));
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this._scrollPane != null) {
            this._scrollPane.setBackground(background);
        }
        if (this.text != null) {
            this.text.setBackground(background);
        }
    }

    protected boolean _clear() {
        if (super._clear()) {
            this.text.setText("");
            return true;
        }
        return false;
    }

    protected void _help() {
        this._about();
    }

    protected void _print() {
        super._print();
    }
}

