/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.EffigyFactory;
import ptolemy.actor.gui.HTMLEffigyFactory;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.Placeable;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.SizeAttribute;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.actor.gui.WindowPropertiesAttribute;
import ptolemy.data.expr.FileParameter;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.gui.StatusBar;
import ptolemy.gui.Top;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Instantiable;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLParser;
import ptolemy.util.FileUtilities;
import ptolemy.util.MessageHandler;

public class TableauFrame
extends Top {
    public String aboutFile = "ptolemy/configs/intro.htm";
    public String helpFile = "ptolemy/configs/doc/basicHelp.htm";
    protected String _initialSaveAsFileName = null;
    protected JMenu _viewMenu;
    private TableauFactory _factoryContainer = null;
    private Tableau _tableau = null;
    private static Image _defaultIconImage = null;
    private Placeable _placeable;

    public TableauFrame() {
        this((Tableau)null);
    }

    public TableauFrame(Tableau tableau) {
        this(tableau, new StatusBar());
    }

    public TableauFrame(Tableau tableau, StatusBar statusBar) {
        this(tableau, statusBar, null);
    }

    public TableauFrame(Tableau tableau, StatusBar statusBar, Placeable placeable) {
        super(statusBar);
        this.setTableau(tableau);
        this.setIconImage(this._getDefaultIconImage());
        this._placeable = placeable;
    }

    public Configuration getConfiguration() {
        NamedObj toplevel;
        Tableau tableau = this.getTableau();
        if (tableau != null && (toplevel = tableau.toplevel()) instanceof Configuration) {
            return (Configuration)toplevel;
        }
        return null;
    }

    public ModelDirectory getDirectory() {
        Configuration configuration = this.getConfiguration();
        if (configuration != null) {
            return configuration.getDirectory();
        }
        return null;
    }

    public Effigy getEffigy() {
        if (this._tableau != null) {
            return (Effigy)this._tableau.getContainer();
        }
        return null;
    }

    public PtolemyEffigy getEffigy(NamedObj model) {
        Configuration configuration = this.getConfiguration();
        if (configuration != null) {
            return configuration.getEffigy(model);
        }
        return null;
    }

    public Tableau getTableau() {
        return this._tableau;
    }

    public boolean isModified() {
        Effigy effigy = this.getEffigy();
        if (effigy != null) {
            return effigy.isModified();
        }
        return super.isModified();
    }

    public void setModified(boolean modified) {
        Effigy effigy = this.getEffigy();
        if (effigy != null) {
            effigy.setModified(modified);
        } else {
            super.setModified(modified);
        }
    }

    public void setTableau(Tableau tableau) {
        this._tableau = tableau;
    }

    protected void _about() {
        block8: {
            ModelDirectory directory = this.getDirectory();
            if (directory != null) {
                try {
                    Configuration configuration = this.getConfiguration();
                    FileParameter aboutAttribute = (FileParameter)configuration.getAttribute("_about", FileParameter.class);
                    URL doc = aboutAttribute != null ? aboutAttribute.asURL() : this.getClass().getClassLoader().getResource(this.aboutFile);
                    Effigy effigy = directory.getEffigy(doc.toExternalForm());
                    if (effigy == null) {
                        HTMLEffigyFactory effigyFactory = new HTMLEffigyFactory(directory.workspace());
                        effigy = ((EffigyFactory)effigyFactory).createEffigy(directory, null, doc);
                        effigy.identifier.setExpression(doc.toExternalForm());
                        effigy.uri.setURL(doc);
                        try {
                            TableauFactory factory = (TableauFactory)this.getConfiguration().getAttribute("tableauFactory");
                            if (factory != null) {
                                Tableau tableau = factory.createTableau(effigy);
                                if (tableau == null) {
                                    throw new Exception("Can't create Tableau.");
                                }
                                tableau.setMaster(true);
                                tableau.size.setExpression("[650, 350]");
                                tableau.show();
                                return;
                            }
                            break block8;
                        }
                        catch (Exception exception) {
                            effigy.setContainer(null);
                        }
                        break block8;
                    }
                    effigy.showTableaux();
                    return;
                }
                catch (Exception exception) {}
            }
        }
        super._about();
    }

    protected void _addMenus() {
        super._addMenus();
        if (this._tableau != null) {
            Effigy tableauContainer;
            JMenuItem item;
            final Configuration configuration = this.getConfiguration();
            EffigyFactory effigyFactory = (EffigyFactory)configuration.getEntity("effigyFactory");
            boolean canCreateBlank = false;
            final ModelDirectory directory = this.getDirectory();
            if (effigyFactory != null && directory != null) {
                List factoryList = effigyFactory.entityList(EffigyFactory.class);
                for (final EffigyFactory factory : factoryList) {
                    if (!factory.canCreateBlankEffigy()) continue;
                    canCreateBlank = true;
                    String name = factory.getName();
                    ActionListener menuListener = new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            Effigy effigy = null;
                            try {
                                effigy = factory.createEffigy(directory);
                            }
                            catch (Exception ex) {
                                MessageHandler.error((String)"Could not create new effigy", (Throwable)ex);
                            }
                            configuration.createPrimaryTableau(effigy);
                        }
                    };
                    item = new JMenuItem(name);
                    item.setActionCommand(name);
                    item.setMnemonic(name.charAt(0));
                    item.addActionListener(menuListener);
                    ((JMenu)this._fileMenuItems[2]).add(item);
                }
            }
            if (canCreateBlank) {
                this._fileMenuItems[2].setEnabled(true);
            }
            if ((tableauContainer = (Effigy)this._tableau.getContainer()) != null) {
                this._factoryContainer = tableauContainer.getTableauFactory();
                if (this._factoryContainer != null) {
                    this._viewMenu = new JMenu("View");
                    this._viewMenu.setMnemonic(86);
                    this._menubar.add(this._viewMenu);
                    ViewMenuListener viewMenuListener = new ViewMenuListener();
                    for (TableauFactory factory : this._factoryContainer.attributeList(TableauFactory.class)) {
                        String name = factory.getName();
                        item = new JMenuItem(name);
                        item.setActionCommand(name);
                        item.setMnemonic(name.charAt(0));
                        item.addActionListener(viewMenuListener);
                        this._viewMenu.add(item);
                    }
                }
            }
        }
    }

    protected boolean _close() {
        if (this._placeable instanceof NamedObj) {
            for (WindowPropertiesAttribute windowProperties : ((NamedObj)this._placeable).attributeList(WindowPropertiesAttribute.class)) {
                windowProperties.recordProperties(this);
            }
            for (SizeAttribute size : ((NamedObj)this._placeable).attributeList(SizeAttribute.class)) {
                Component[] components = this.getContentPane().getComponents();
                if (components.length <= 0) continue;
                size.recordSize(components[0]);
            }
        }
        boolean result = true;
        if (this.getEffigy() == null) {
            result = super._close();
        } else {
            Effigy masterEffigy = this.getEffigy().masterEffigy();
            if (!this._tableau.isMaster()) {
                List tableaux = masterEffigy.entityList(Tableau.class);
                for (Tableau tableau : tableaux) {
                    if (tableau instanceof DialogTableau || tableau == this._tableau) continue;
                    this.dispose();
                    if (this._placeable != null) {
                        this._placeable.place(null);
                    }
                    return true;
                }
            }
            if (this.isModified()) {
                int reply = this._queryForSave();
                if (!(reply != 1 && reply != 3 || this._checkForDerivedObjects())) {
                    if (this._placeable != null) {
                        this._placeable.place(null);
                    }
                    return false;
                }
                if (reply == 0) {
                    this.dispose();
                } else if (reply == 1) {
                    this.dispose();
                    this.setModified(false);
                    try {
                        MoMLParser.purgeModelRecord((URL)masterEffigy.uri.getURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    result = false;
                }
            } else {
                this.dispose();
            }
        }
        if (this._placeable != null) {
            this._placeable.place(null);
        }
        return result;
    }

    protected boolean _confirmFile(Entity model, File file) throws MalformedURLException {
        String query;
        int selected;
        URL newURL = file.toURI().toURL();
        String newKey = newURL.toExternalForm();
        Effigy previousOpen = this.getDirectory().getEffigy(newKey);
        if (previousOpen != null && previousOpen != this.getEffigy()) {
            boolean containmentError = false;
            if (model != null) {
                NamedObj possibleContainer;
                if (previousOpen instanceof PtolemyEffigy && (possibleContainer = ((PtolemyEffigy)previousOpen).getModel()) != null && possibleContainer.deepContains((NamedObj)model)) {
                    containmentError = true;
                }
            } else if (previousOpen.deepContains((NamedObj)this.getEffigy())) {
                containmentError = true;
            }
            if (containmentError) {
                MessageHandler.error((String)"Cannot replace a model with a submodel. Please choose a different file name.");
                return false;
            }
            if (previousOpen.isModified()) {
                previousOpen.showTableaux();
                String confirm = "Unsaved changes in " + file.getName() + ". OK to discard changes?";
                int selected2 = JOptionPane.showOptionDialog(this, confirm, "Discard changes?", 0, 3, null, null, null);
                if (selected2 == 1) {
                    return false;
                }
                if (!this._checkForDerivedObjects()) {
                    return false;
                }
                previousOpen.setModified(false);
            }
            previousOpen.closeTableaux();
        }
        return !file.exists() || (selected = JOptionPane.showOptionDialog(this, query = "Overwrite " + file.getName() + "?", "Overwrite file?", 0, 3, null, null, null)) != 1;
    }

    protected void _exit() {
        ModelDirectory directory = this.getDirectory();
        if (directory == null) {
            return;
        }
        for (Effigy effigy : directory.entityList(Effigy.class)) {
            if (!effigy.closeTableaux()) {
                return;
            }
            try {
                effigy.setContainer(null);
            }
            catch (Exception ex) {
                throw new InternalErrorException("Unable to set effigy container to null! " + ex);
            }
        }
        for (Effigy effigy : directory.entityList(Effigy.class)) {
            if (!effigy.closeTableaux()) {
                return;
            }
            try {
                effigy.setContainer(null);
            }
            catch (Exception ex) {
                throw new InternalErrorException("Unable to set effigy container to null! " + ex);
            }
        }
    }

    protected Image _getDefaultIconImage() {
        if (_defaultIconImage == null) {
            URL url = null;
            try {
                Configuration configuration = this.getConfiguration();
                FileParameter iconAttribute = (FileParameter)configuration.getAttribute("_applicationIcon", FileParameter.class);
                if (iconAttribute != null) {
                    url = iconAttribute.asURL();
                }
            }
            catch (Throwable throwable) {}
            if (url == null) {
                try {
                    url = FileUtilities.nameToURL((String)"/ptolemy/actor/gui/PtolemyIISmallIcon.gif", null, null);
                }
                catch (Throwable throwable) {}
            }
            if (url == null) {
                return null;
            }
            Toolkit tk = Toolkit.getDefaultToolkit();
            _defaultIconImage = tk.createImage(url);
        }
        return _defaultIconImage;
    }

    protected String _getName() {
        URI uri;
        Effigy effigy = this.getEffigy();
        if (effigy != null && (uri = effigy.uri.getURI()) != null) {
            return uri.toString();
        }
        return "Unnamed";
    }

    protected void _help() {
        try {
            Configuration configuration = this.getConfiguration();
            FileParameter helpAttribute = (FileParameter)configuration.getAttribute("_help", FileParameter.class);
            URL doc = helpAttribute != null ? helpAttribute.asURL() : this.getClass().getClassLoader().getResource(this.helpFile);
            configuration.openModel(null, doc, doc.toExternalForm());
        }
        catch (Exception exception) {
            this._about();
        }
    }

    protected void _read(URL url) throws Exception {
        if (this._tableau == null) {
            throw new Exception("No associated Tableau! Can't open a file.");
        }
        NamedObj configuration = this._tableau.toplevel();
        if (!(configuration instanceof Configuration)) {
            throw new InternalErrorException("Expected top-level to be a Configuration: " + this._tableau.toplevel().getFullName());
        }
        ((Configuration)configuration).openModel(url, url, url.toExternalForm());
    }

    protected boolean _save() {
        if (this._tableau == null) {
            throw new InternalErrorException("No associated Tableau! Can't save.");
        }
        Effigy effigy = this.getEffigy();
        File file = effigy.getWritableFile();
        if (!effigy.isModifiable() || file == null) {
            return this._saveAs();
        }
        try {
            this._writeFile(file);
            this.setModified(false);
            return true;
        }
        catch (IOException ex) {
            this.report("Error writing file", ex);
            return false;
        }
    }

    protected boolean _saveAs() {
        return this._saveAs(null);
    }

    protected boolean _saveAs(String extension) {
        int returnVal;
        if (this._tableau == null) {
            throw new InternalErrorException("No associated Tableau! Can't save.");
        }
        JFileChooser fileDialog = this._saveAsFileDialog();
        if (this._initialSaveAsFileName != null) {
            fileDialog.setSelectedFile(new File(fileDialog.getCurrentDirectory(), this._initialSaveAsFileName));
        }
        if ((returnVal = fileDialog.showSaveDialog(this)) == 0) {
            String id;
            File file;
            block8: {
                file = fileDialog.getSelectedFile();
                if (extension != null && file.getName().indexOf(".") == -1) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + extension);
                }
                try {
                    if (this._confirmFile(null, file)) break block8;
                    return false;
                }
                catch (Exception ex) {
                    this.report("Error in save as.", ex);
                    return false;
                }
            }
            URL newURL = file.toURI().toURL();
            String newKey = newURL.toExternalForm();
            _directory = fileDialog.getCurrentDirectory();
            this._writeFile(file);
            this.getConfiguration().openModel(newURL, newURL, newKey);
            Effigy effigy = this.getEffigy();
            if (effigy != null && (id = effigy.identifier.getExpression()).equals("Unnamed")) {
                effigy.setContainer(null);
            }
            return true;
        }
        return true;
    }

    protected void _writeFile(File file) throws IOException {
        Effigy effigy;
        Tableau tableau = this.getTableau();
        if (tableau != null && (effigy = (Effigy)tableau.getContainer()) != null) {
            effigy.writeFile(file);
            return;
        }
        throw new IOException("Cannot find an effigy to delegate writing.");
    }

    private boolean _checkForDerivedObjects() {
        List children;
        NamedObj model;
        Effigy effigy = this.getEffigy();
        if (effigy instanceof PtolemyEffigy && (model = ((PtolemyEffigy)effigy).getModel()) instanceof Instantiable && (children = ((Instantiable)model).getChildren()) != null && children.size() > 0) {
            StringBuffer confirm = new StringBuffer("Warning: This model defines a class, and there are open models with instances\nor subclasses the modified version of this model:\n");
            Iterator instances = children.iterator();
            int length = confirm.length();
            while (instances.hasNext()) {
                WeakReference reference = (WeakReference)instances.next();
                Instantiable instance = (Instantiable)reference.get();
                if (instance == null) continue;
                confirm.append(instance.getFullName());
                confirm.append(";");
                int newLength = confirm.length();
                if (newLength - length <= 50) continue;
                confirm.append("\n");
                length = confirm.length();
            }
            confirm.append("\nContinue?");
            int selected = JOptionPane.showOptionDialog(this, confirm, "Warning: Instances or Subclasses", 0, 3, null, null, null);
            if (selected == 1) {
                return false;
            }
        }
        return true;
    }

    static class ExtensionFileFilter
    extends FileFilter {
        private List _extensions;

        public ExtensionFileFilter(List extensions) {
            this._extensions = extensions;
        }

        public boolean accept(File fileOrDirectory) {
            if (fileOrDirectory.isDirectory()) {
                return true;
            }
            String fileOrDirectoryName = fileOrDirectory.getName();
            int dotIndex = fileOrDirectoryName.lastIndexOf(46);
            if (dotIndex == -1) {
                return false;
            }
            String extension = fileOrDirectoryName.substring(dotIndex + 1);
            if (extension != null) {
                for (String matchExtension : this._extensions) {
                    if (!extension.equalsIgnoreCase(matchExtension)) continue;
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            StringBuffer result = new StringBuffer();
            Iterator extensions = this._extensions.iterator();
            int extensionNumber = 1;
            int size = this._extensions.size();
            while (extensions.hasNext()) {
                String extension = (String)extensions.next();
                result.append(".");
                result.append(extension);
                if (extensionNumber < size - 1) {
                    result.append(", ");
                } else if (extensionNumber < size) {
                    result.append(" and ");
                }
                ++extensionNumber;
            }
            result.append(" files");
            return result.toString();
        }
    }

    class ViewMenuListener
    implements ActionListener {
        ViewMenuListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GraphicalMessageHandler.setContext(TableauFrame.this);
            if (TableauFrame.this._factoryContainer != null) {
                JMenuItem originalMenuItem;
                JMenuItem target = (JMenuItem)e.getSource();
                String actionCommand = null;
                Action action = target.getAction();
                actionCommand = action != null ? ((originalMenuItem = (JMenuItem)action.getValue("menuItem")) != null ? originalMenuItem.getActionCommand() : target.getActionCommand()) : target.getActionCommand();
                TableauFactory factory = (TableauFactory)TableauFrame.this._factoryContainer.getAttribute(actionCommand);
                if (factory != null) {
                    Effigy tableauContainer = (Effigy)TableauFrame.this._tableau.getContainer();
                    try {
                        Tableau tableau = factory.createTableau(tableauContainer);
                        tableau.show();
                    }
                    catch (Throwable throwable) {
                        MessageHandler.error((String)"Cannot create view", (Throwable)throwable);
                    }
                }
            }
            TableauFrame.this.repaint();
        }
    }
}

