/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.net.URL;
import java.util.LinkedList;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.MoMLApplication;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.util.MessageHandler;

public class PtExecuteApplication
extends MoMLApplication {
    protected static String[] _localCommandFlags = new String[]{"-exit"};
    protected static String[][] _localCommandOptions = new String[][]{{"-config", "<configuration URL, defaults to ptolemy/configs/runConfiguration.xml>"}};
    private String _configurationSubdirectory;
    private URL _configurationURL;
    private static int _exitValue = 0;
    private boolean _expectingConfiguration = false;

    public PtExecuteApplication(String[] args) throws Exception {
        super(args);
    }

    public synchronized void executionError(Manager manager, Throwable throwable) {
        ++_exitValue;
        MessageHandler.error((String)"Command failed", (Throwable)throwable);
        _test = true;
        System.err.print(KernelException.stackTraceToString((Throwable)throwable));
        super.executionError(manager, throwable);
    }

    public static void main(String[] args) {
        try {
            PtExecuteApplication application = new PtExecuteApplication(args);
            application.runModels();
            application.waitForFinish();
        }
        catch (Throwable throwable) {
            MessageHandler.error((String)"Command failed", (Throwable)throwable);
            System.err.print(KernelException.stackTraceToString((Throwable)throwable));
            ++_exitValue;
            _test = true;
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.exit(_exitValue);
    }

    protected Configuration _createDefaultConfiguration() throws Exception {
        if (this._configurationURL == null) {
            this._configurationURL = PtExecuteApplication.specToURL("ptolemy/configs/runConfiguration.xml");
        }
        this._configuration = PtExecuteApplication.readConfiguration(this._configurationURL);
        super._createDefaultConfiguration();
        PtolemyPreferences.setDefaultPreferences(this._configuration);
        return this._configuration;
    }

    protected Configuration _createEmptyConfiguration() throws Exception {
        throw new Exception("No model specified.");
    }

    protected synchronized void _parseArgs(String[] args) throws Exception {
        this._commandTemplate = "ptexecute [ options ] file ...";
        LinkedList<String> processedArgsList = new LinkedList<String>();
        int i = 0;
        while (i < args.length) {
            if (!this._configurationParseArg(args[i])) {
                processedArgsList.add(args[i]);
            }
            ++i;
        }
        if (this._expectingConfiguration) {
            throw new IllegalActionException("Missing configuration");
        }
        String[] processedArgs = processedArgsList.toArray(new String[processedArgsList.size()]);
        super._parseArgs(processedArgs);
    }

    protected String _usage() {
        return this._configurationUsage(this._commandTemplate, _localCommandOptions, _localCommandFlags);
    }

    private boolean _configurationParseArg(String arg) throws Exception {
        if (arg.startsWith("-conf")) {
            this._expectingConfiguration = true;
        } else if (arg.startsWith("-")) {
            try {
                this._configurationSubdirectory = arg.substring(1);
                String potentialConfiguration = "ptolemy/configs/" + this._configurationSubdirectory + "/configuration.xml";
                this._configurationURL = PtExecuteApplication.specToURL(potentialConfiguration);
            }
            catch (Exception exception) {
                return false;
            }
        } else if (this._expectingConfiguration) {
            this._expectingConfiguration = false;
            this._configurationURL = PtExecuteApplication.specToURL(arg);
        } else {
            return false;
        }
        return true;
    }
}

