/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.PtolemyDialog;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class OpenInstanceDialog
extends PtolemyDialog
implements ChangeListener {
    private ArrayList _columnNames;
    private static Color _EXPERT_COLOR = new Color(1.0f, 0.9f, 0.9f);
    private static Color _INVISIBLE_COLOR = new Color(0.9f, 0.9f, 0.9f);
    private List _parameters;
    JTable _parameterTable;
    ParametersTableModel _parameterTableModel = null;

    public OpenInstanceDialog(DialogTableau tableau, Frame owner, Entity target, Configuration configuration) {
        super("Instance: " + target.getFullName(), tableau, owner, target, configuration);
        this.getTarget().addChangeListener((ChangeListener)this);
        this._parameterTable = new JTable();
        this._initColumnNames();
        this._setupTableModel();
        int height = this._parameterTableModel.getRowCount() * 16;
        if (height < 64) {
            height = 64;
        } else if (height > 256) {
            height = 256;
        }
        this._parameterTable.setPreferredScrollableViewportSize(new Dimension(600, height));
        this._initColumnSizes();
        this.setScrollableContents(this._parameterTable);
        this._parameterTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                int code = event.getKeyCode();
                if (code == 10 || code == 27) {
                    OpenInstanceDialog.this._cancel();
                }
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public void changeExecuted(ChangeRequest change) {
        this._setupTableModel();
        this._initColumnSizes();
    }

    public void changeFailed(ChangeRequest change, Exception exception) {
    }

    protected void _createExtendedButtons(JPanel _buttons) {
    }

    protected URL _getHelpURL() {
        URL doc = this.getClass().getClassLoader().getResource("doc/openInstanceHelp.htm");
        return doc;
    }

    private void _initColumnNames() {
        String[] temp = new String[]{"Name", "Expression", "Value"};
        List<String> columnList = Arrays.asList(temp);
        this._columnNames = new ArrayList<String>(columnList);
    }

    private void _initColumnSizes() {
        TableColumn column = null;
        column = this._parameterTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(150);
        column = this._parameterTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
        column = this._parameterTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(300);
    }

    private void _setupTableModel() {
        this._parameterTableModel = new ParametersTableModel((NamedObj)this.getTarget());
        this._parameterTable.setModel(this._parameterTableModel);
        this._parameterTable.setDefaultRenderer(String.class, new StringCellRenderer());
    }

    private static class ColumnNames {
        public static final String COL_NAME = "Name";
        public static final String COL_EXPRESSION = "Expression";
        public static final String COL_VALUE = "Value";

        private ColumnNames() {
        }
    }

    private class ParametersTableModel
    extends AbstractTableModel {
        public ParametersTableModel(NamedObj target) {
            OpenInstanceDialog.this._parameters = target.attributeList(Settable.class);
        }

        public int getColumnCount() {
            return OpenInstanceDialog.this._columnNames.size();
        }

        public int getRowCount() {
            return OpenInstanceDialog.this._parameters.size();
        }

        public String getColumnName(int col) {
            return (String)OpenInstanceDialog.this._columnNames.get(col);
        }

        public Object getValueAt(int row, int col) {
            Settable parameter = (Settable)OpenInstanceDialog.this._parameters.get(row);
            if ("Name".equals(this.getColumnName(col))) {
                return parameter.getDisplayName();
            }
            if ("Expression".equals(this.getColumnName(col))) {
                return parameter.getExpression();
            }
            return parameter.getValueAsString();
        }

        public void setValueAt(Object value, int row, int col) {
        }

        public Class getColumnClass(int col) {
            return String.class;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class StringCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setOpaque(true);
            this.setText((String)value);
            Settable parameter = (Settable)OpenInstanceDialog.this._parameters.get(row);
            if (parameter.getVisibility() == Settable.EXPERT) {
                this.setBackground(_EXPERT_COLOR);
            } else if (parameter.getVisibility() == Settable.NONE) {
                this.setBackground(_INVISIBLE_COLOR);
            } else {
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }
}

