/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.util.List;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.filter.BackwardCompatibility;
import ptolemy.moml.filter.RemoveGraphicalClasses;

public class MoMLSimpleApplication
implements ChangeListener,
ExecutionListener {
    private Manager _manager = null;
    private Throwable _sawThrowable = null;
    private boolean _executionFinishedOrError = false;

    public MoMLSimpleApplication() throws Exception {
    }

    public MoMLSimpleApplication(String xmlFileName) throws Throwable {
        MoMLParser parser = new MoMLParser();
        MoMLParser.setMoMLFilters((List)BackwardCompatibility.allFilters());
        MoMLParser.addMoMLFilter((MoMLFilter)new RemoveGraphicalClasses());
        CompositeActor toplevel = (CompositeActor)parser.parse(null, new File(xmlFileName).toURI().toURL());
        this._manager = new Manager(toplevel.workspace(), "MoMLSimpleApplication");
        toplevel.setManager(this._manager);
        toplevel.addChangeListener((ChangeListener)this);
        this._manager.addExecutionListener((ExecutionListener)this);
        this._manager.execute();
        while (!this._executionFinishedOrError) {
            Thread.yield();
        }
        if (this._sawThrowable != null) {
            throw this._sawThrowable;
        }
    }

    public void changeExecuted(ChangeRequest change) {
    }

    public void changeFailed(ChangeRequest change, Exception exception) {
        String description = "";
        if (change != null) {
            description = change.getDescription();
        }
        throw new RuntimeException("MoMLSimplApplication.changeFailed(): " + description + " failed: ", exception);
    }

    public void executionError(Manager manager, Throwable throwable) {
        this._executionFinishedOrError = true;
        this._sawThrowable = throwable;
        throw new RuntimeException("Execution error " + Thread.currentThread().getName(), throwable);
    }

    public void executionFinished(Manager manager) {
        this._executionFinishedOrError = true;
    }

    public void managerStateChanged(Manager manager) {
    }

    public static void main(String[] args) {
        try {
            new MoMLSimpleApplication(args[0]);
        }
        catch (Throwable ex) {
            System.err.println("Command failed: " + ex);
            ex.printStackTrace();
        }
    }

    public void rerun() throws Exception {
        this._manager.execute();
    }
}

