/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.HTMLEffigy;
import ptolemy.actor.gui.HTMLViewer;
import ptolemy.actor.gui.JNLPUtilities;
import ptolemy.actor.gui.MoMLApplication;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.ClassUtilities;
import ptolemy.util.FileUtilities;
import ptolemy.util.StringUtilities;

public class HTMLViewerTableau
extends Tableau {
    public StringAttribute url = new StringAttribute((NamedObj)this, "url");

    public HTMLViewerTableau(Effigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        HTMLViewer frame = new HTMLViewer(this);
        this.setFrame(frame);
        frame.setTableau(this);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.url) {
            String urlSpec = ((Settable)attribute).getExpression();
            try {
                URL toRead = MoMLApplication.specToURL(urlSpec);
                ((HTMLViewer)this.getFrame()).setPage(toRead);
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, (Throwable)ex, "Cannot open URL: " + urlSpec);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public static URL _absolutePTIIURLToJarURL(String urlName) throws URISyntaxException, MalformedURLException {
        URL anotherURL;
        String ptsupportPath;
        String ptIIDirAsURLName = StringUtilities.getProperty((String)"ptolemy.ptII.dirAsURL");
        if (ptIIDirAsURLName.endsWith(ptsupportPath = "/ptolemy/ptsupport.jar")) {
            ptIIDirAsURLName = ptIIDirAsURLName.substring(0, ptIIDirAsURLName.length() - ptsupportPath.length());
        }
        String relativePath = null;
        if (urlName.startsWith(ptIIDirAsURLName)) {
            relativePath = urlName.substring(ptIIDirAsURLName.length());
        } else {
            URI ptIIDirAsURI;
            URI uri = new URI(urlName);
            try {
                ptIIDirAsURI = new URI(ptIIDirAsURLName);
            }
            catch (URISyntaxException uRISyntaxException) {
                ptIIDirAsURI = new URI(StringUtilities.substitute((String)ptIIDirAsURLName, (String)" ", (String)"%20"));
            }
            URI relativeURI = uri.relativize(ptIIDirAsURI);
            if (relativeURI.toURL().sameFile(ptIIDirAsURI.toURL())) {
                int offset = 0;
                if (urlName.startsWith("jar:")) {
                    offset = 4;
                }
                relativePath = uri.toString().substring(ptIIDirAsURI.toString().length() + offset);
            }
        }
        if (relativePath == null) {
            return null;
        }
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if ((anotherURL = Thread.currentThread().getContextClassLoader().getResource(relativePath)) == null && relativePath.indexOf(35) != -1) {
            try {
                anotherURL = HTMLViewerTableau._entryResourceWithoutFragment(relativePath);
            }
            catch (IOException iOException) {}
        }
        return anotherURL;
    }

    private static URL _entryResourceWithoutFragment(String urlString) throws IOException, MalformedURLException {
        String urlStringBase = urlString.substring(0, urlString.lastIndexOf("#"));
        URL anotherURL = null;
        anotherURL = urlStringBase.startsWith("jar:") ? ClassUtilities.jarURLEntryResource((String)urlStringBase) : Thread.currentThread().getContextClassLoader().getResource(urlStringBase);
        if (anotherURL != null) {
            anotherURL = new URL(String.valueOf(anotherURL.toString()) + urlString.substring(urlString.lastIndexOf("#")));
        }
        return anotherURL;
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof HTMLEffigy) {
                effigy.setTableauFactory(this);
                HTMLViewerTableau tableau = (HTMLViewerTableau)effigy.getEntity("htmlTableau");
                if (tableau == null) {
                    tableau = new HTMLViewerTableau(effigy, "htmlTableau");
                }
                URL pageURL = new URL(effigy.uri.getURI().toString());
                try {
                    ((HTMLViewer)tableau.getFrame()).setPage(pageURL);
                }
                catch (IOException io) {
                    String urlString = effigy.uri.getURI().toString();
                    URL anotherURL = ClassUtilities.jarURLEntryResource((String)urlString);
                    if (anotherURL == null && urlString.indexOf("#") != -1) {
                        anotherURL = HTMLViewerTableau._entryResourceWithoutFragment(urlString);
                    }
                    if (anotherURL == null) {
                        try {
                            anotherURL = HTMLViewerTableau._absolutePTIIURLToJarURL(urlString);
                        }
                        catch (Throwable throwable) {}
                    }
                    if (anotherURL == null && urlString.indexOf("$CLASSPATH") != -1) {
                        String classpathString = urlString.substring(urlString.indexOf("$CLASSPATH"));
                        anotherURL = FileUtilities.nameToURL((String)classpathString, null, null);
                    }
                    if (anotherURL == null) {
                        IOException io2 = new IOException("---");
                        io2.initCause(io);
                        throw io2;
                    }
                    try {
                        effigy.uri.setURI(new URI(anotherURL.toString()));
                        tableau.setTitle(anotherURL.toString());
                    }
                    catch (Exception ex) {
                        try {
                            URL canonicalizedURL = JNLPUtilities.canonicalizeJarURL(anotherURL);
                            effigy.uri.setURI(new URI(canonicalizedURL.toString()));
                            tableau.setTitle(canonicalizedURL.toString());
                        }
                        catch (Throwable throwable) {
                            throw ex;
                        }
                    }
                    ((HTMLViewer)tableau.getFrame()).setPage(anotherURL);
                }
                return tableau;
            }
            return null;
        }
    }
}

