/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.CheckModelSize;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.GenerateCopyrights;
import ptolemy.actor.gui.MoMLApplication;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.data.ArrayToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.attributes.VersionAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.FileUtilities;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.basic.BasicGraphFrame;

public class HTMLAbout {
    private static List _demosURLs;

    public static String about(Configuration configuration) {
        String version = VersionAttribute.majorCurrentVersion();
        String applicationName = "Ptolemy II";
        try {
            StringAttribute applicationNameAttribute = (StringAttribute)configuration.getAttribute("_applicationName", StringAttribute.class);
            if (applicationNameAttribute != null) {
                applicationName = applicationNameAttribute.getExpression();
            }
        }
        catch (Throwable throwable) {}
        StringBuffer htmlBuffer = new StringBuffer();
        htmlBuffer.append("<html><head><title>About " + applicationName + "</title></head>" + "<body><h1>About " + applicationName + "</h1>\n" + "The HTML Viewer in " + applicationName + " handles the <code>about:</code>\n" + "tag specially.\n" + "<br>The following urls are handled:\n" + "<ul>\n" + "<li><a href=\"about:configuration\">" + "<code>about:configuration</code></a> " + "Expand the configuration (good way to test for " + "missing classes).\n" + "<li><a href=\"about:expandLibrary\">" + "<code>about:expandLibrary</code></a> " + "Open a model and expand library tree (good way to test for " + "missing classes, check standard out).\n" + "<li><a href=\"about:copyright\">" + "<code>about:copyright</code></a> " + " Display information about the copyrights.\n");
        if (HTMLAbout._configurationExists("full")) {
            htmlBuffer.append("<li><a href=\"about:checkCompleteDemos\"><code>about:checkCompleteDemos</code></a> Check that each of the demos listed in the individual files is present in <code>ptolemy/configs/doc/completeDemos.htm</code>.\n");
        }
        htmlBuffer.append("</ul>\n<table>\n");
        _demosURLs = new LinkedList();
        if (HTMLAbout._configurationExists("full")) {
            htmlBuffer.append("<tr rowspan=4><center><b>Full</b></center></tr>\n" + HTMLAbout._aboutHTML("ptolemy/configs/doc/completeDemos.htm") + HTMLAbout._aboutHTML("ptolemy/configs/doc/demos.htm") + HTMLAbout._aboutHTML("ptolemy/configs/doc/whatsNew" + version + ".htm") + HTMLAbout._aboutHTML("ptolemy/configs/doc/whatsNew6.0.htm") + HTMLAbout._aboutHTML("ptolemy/configs/doc/whatsNew5.1.htm") + HTMLAbout._aboutHTML("ptolemy/configs/doc/whatsNew5.0.htm") + HTMLAbout._aboutHTML("ptolemy/configs/doc/whatsNew4.0.htm") + HTMLAbout._aboutHTML("ptolemy/configs/doc/whatsNew3.0.2.htm"));
        }
        if (HTMLAbout._configurationExists("hyvisual")) {
            htmlBuffer.append("<tr rowspan=4><center><b>HyVisual</b></center></tr>\n" + HTMLAbout._aboutHTML("ptolemy/configs/hyvisual/intro.htm"));
        }
        if (HTMLAbout._configurationExists("ptiny")) {
            htmlBuffer.append("<tr rowspan=4><center><b>Ptiny</b></center></tr>\n" + HTMLAbout._aboutHTML("ptolemy/configs/doc/completeDemosPtiny.htm") + HTMLAbout._aboutHTML("ptolemy/configs/doc/demosPtiny.htm") + HTMLAbout._aboutHTML("doc/mainVergilPtiny.htm"));
        }
        if (HTMLAbout._configurationExists("ptinyKepler")) {
            htmlBuffer.append("<tr rowspan=4><center><b>Ptiny for Kepler</b></center></tr>\n" + HTMLAbout._aboutHTML("ptolemy/configs/doc/completeDemosPtinyKepler.htm") + HTMLAbout._aboutHTML("ptolemy/configs/doc/demosPtinyKepler.htm") + HTMLAbout._aboutHTML("ptolemy/configs/kepler/introScientists.htm") + HTMLAbout._aboutHTML("ptolemy/configs/kepler/introProgrammers.htm"));
        }
        if (HTMLAbout._configurationExists("visualsense")) {
            htmlBuffer.append("<tr rowspan=4><center><b>VisualSense</b></center></tr>\n" + HTMLAbout._aboutHTML("ptolemy/configs/visualsense/intro.htm"));
        }
        try {
            Parameter applicationDemos = (Parameter)configuration.getAttribute("_applicationDemos", Parameter.class);
            if (applicationDemos != null) {
                htmlBuffer.append("<tr rowspan=4><center><b>" + applicationName + "</b></center></tr>\n");
                ArrayToken demoTokens = (ArrayToken)applicationDemos.getToken();
                int i = 0;
                while (i < demoTokens.length()) {
                    StringToken demoToken = (StringToken)demoTokens.getElement(i);
                    htmlBuffer.append(HTMLAbout._aboutHTML(demoToken.stringValue()));
                    _demosURLs.add(demoToken.stringValue());
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            throw new InternalErrorException((Nameable)configuration, (Throwable)ex, "Bad configuration for " + applicationName);
        }
        htmlBuffer.append("</table>\n");
        htmlBuffer.append("</body>\n</html>\n");
        return htmlBuffer.toString();
    }

    public static URL generateLinks(String demosFileName, String regexp, Configuration configuration) throws Exception {
        URL demosURL = HTMLAbout._getDemoURL(demosFileName);
        List modelList = HTMLAbout._getURLs(demosURL, regexp);
        for (String model : modelList) {
            URL modelURL = new URL(demosURL, model);
            try {
                configuration.openModel(demosURL, modelURL, modelURL.toExternalForm());
            }
            catch (Throwable throwable) {
                throw new Exception("Failed to open '" + modelURL + "'", throwable);
            }
        }
        return demosURL;
    }

    public static URL hyperlinkUpdate(HyperlinkEvent event, Configuration configuration) throws Throwable {
        URL newURL = null;
        if (event.getDescription().equals("about:allcopyrights")) {
            try {
                newURL = HTMLAbout._temporaryHTMLFile("generatecopyright", ".htm", GenerateCopyrights.generateHTML(configuration));
            }
            catch (SecurityException securityException) {
                newURL = FileUtilities.nameToURL((String)"$CLASSPATH/ptolemy/configs/doc/copyright.htm", null, null);
            }
        } else if (event.getDescription().startsWith("about:checkCompleteDemos")) {
            newURL = HTMLAbout._temporaryHTMLFile("checkCompleteDemos", ".htm", HTMLAbout._checkCompleteDemos("ptolemy/configs/doc/completeDemos.htm", _demosURLs));
        } else if (event.getDescription().startsWith("about:checkModelSizes")) {
            URI aboutURI = new URI(event.getDescription());
            URL demosURL = HTMLAbout._getDemoURL(aboutURI.getFragment());
            List modelList = HTMLAbout._getURLs(demosURL, ".*(.htm|.html|.xml)", true, 2);
            HashSet modelSet = new HashSet(modelList);
            newURL = HTMLAbout._temporaryHTMLFile("checkModelSizes", ".htm", CheckModelSize.checkModelSize(configuration, modelSet.toArray(new String[modelSet.size()])));
        } else if (event.getDescription().equals("about:copyright")) {
            try {
                newURL = HTMLAbout._temporaryHTMLFile("copyright", ".htm", String.valueOf(GenerateCopyrights.generatePrimaryCopyrightHTML(configuration)) + "<p>Other <a href=\"about:allcopyrights\">copyrights</a>\n" + "about this configuration \n" + "(<i>may take a moment to run</i>).\n" + "</body>\n</html>");
            }
            catch (SecurityException securityException) {
                newURL = FileUtilities.nameToURL((String)"$CLASSPATH/ptolemy/configs/doc/copyright.htm", null, null);
            }
        } else if (event.getDescription().equals("about:configuration")) {
            newURL = HTMLAbout._temporaryHTMLFile("configuration", ".txt", String.valueOf(configuration.check()) + configuration.exportMoML());
        } else if (event.getDescription().startsWith("about:demos")) {
            URI aboutURI = new URI(event.getDescription());
            newURL = HTMLAbout.generateLinks(aboutURI.getFragment(), ".*.xml$", configuration);
        } else if (event.getDescription().startsWith("about:links")) {
            URI aboutURI = new URI(event.getDescription());
            newURL = HTMLAbout.generateLinks(aboutURI.getFragment(), ".*(.htm|.html|.pdf|.xml)", configuration);
        } else if (event.getDescription().startsWith("about:runAllDemos")) {
            URI aboutURI = new URI(event.getDescription());
            newURL = HTMLAbout.runAllDemos(aboutURI.getFragment(), configuration);
        } else if (event.getDescription().startsWith("about:expandLibrary")) {
            new URI(event.getDescription());
            newURL = HTMLAbout._expandLibrary(".*.xml", configuration);
        } else {
            newURL = HTMLAbout._temporaryHTMLFile("about", ".htm", HTMLAbout.about(configuration));
        }
        return newURL;
    }

    public static void main(String[] args) throws IOException {
        String demoFileName = "ptolemy/configs/doc/completeDemos.htm";
        String outputFileName = "models.txt";
        if (args.length > 2) {
            System.err.println("Usage: [demoFileName [outputFilename]\ndemoFileName defaults to " + demoFileName + "\n" + "outputFileName defaults to " + outputFileName + "\n");
            System.exit(3);
        }
        if (args.length >= 1) {
            demoFileName = args[0];
        }
        if (args.length == 2) {
            outputFileName = args[1];
        }
        HTMLAbout.writeDemoURLs(demoFileName, outputFileName);
    }

    public static URL runAllDemos(String demosFileName, Configuration configuration) throws Exception {
        URL demosURL = HTMLAbout._getDemoURL(demosFileName);
        List modelList = HTMLAbout._getURLs(demosURL, ".*.xml$");
        for (String model : modelList) {
            URL modelURL = new URL(demosURL, model);
            Tableau tableau = configuration.openModel(demosURL, modelURL, modelURL.toExternalForm());
            if (!((Effigy)tableau.getContainer() instanceof PtolemyEffigy)) continue;
            PtolemyEffigy effigy = (PtolemyEffigy)tableau.getContainer();
            CompositeActor actor = (CompositeActor)effigy.getModel();
            Manager manager = actor.getManager();
            if (manager == null) {
                manager = new Manager(actor.workspace(), "manager");
                actor.setManager(manager);
            }
            manager.execute();
        }
        return demosURL;
    }

    public static void writeDemoURLs(String demosFileName, String outputFileName) throws IOException {
        String ptII = null;
        try {
            ptII = new URI(StringUtilities.getProperty((String)"ptolemy.ptII.dirAsURL")).normalize().getPath();
            ptII = new File(ptII).getCanonicalPath().replace('\\', '/');
        }
        catch (URISyntaxException ex) {
            throw new InternalErrorException(null, (Throwable)ex, "Failed to process PTII " + ptII);
        }
        if (ptII.length() == 0) {
            throw new InternalErrorException("Failed to process ptolemy.ptII.dirAsURL property, ptII = null?");
        }
        URL demoURL = MoMLApplication.specToURL(demosFileName);
        List demosList = HTMLAbout._getURLs(demoURL, ".*.xml", true, 2);
        HashSet demosSet = new HashSet(demosList);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(outputFileName);
            for (String demo : demosSet) {
                fileWriter.write(String.valueOf(StringUtilities.substitute((String)demo, (String)ptII, (String)"$CLASSPATH")) + "\n");
            }
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    private static String _aboutHTML(String fileName) {
        _demosURLs.add(fileName);
        return "  <tr>\n    <code>" + fileName + "</code>\n" + "    <td><a href=\"about:demos#" + fileName + "\">&nbsp;Open the .xml&nbsp;</a></td>\n" + "    <td><a href=\"about:links#" + fileName + "\">&nbsp;Open the .htm, .html, .xml and .pdf&nbsp;</a></td>\n" + "    <td><a href=\"about:checkModelSizes#" + fileName + "\">&nbsp;Check the sizes/centering of the models&nbsp;</a></td>\n" + "  </tr>\n";
    }

    public static URL _expandLibrary(String regexp, Configuration configuration) throws Exception {
        FileParameter aboutAttribute = (FileParameter)configuration.getAttribute("_about", FileParameter.class);
        URL baseURL = null;
        URL modelURL = null;
        if (aboutAttribute != null) {
            baseURL = aboutAttribute.asURL();
            String aboutURLString = baseURL.toExternalForm();
            String base = aboutURLString.substring(0, aboutURLString.lastIndexOf("/"));
            baseURL = MoMLApplication.specToURL(String.valueOf(base) + "/intro.htm");
            System.out.println("HTMLAbout._expandLibrary(): looking in about URL: " + baseURL);
            List modelList = HTMLAbout._getURLs(baseURL, regexp);
            if (modelList.size() > 0) {
                String model = (String)modelList.get(0);
                System.out.println("HTMLAbout._expandLibrary(): looking for model relative to about URL: " + model);
                modelURL = new URL(baseURL, model);
            } else {
                System.out.println("HTMLAbout._expandLibrary(): looking inside " + baseURL + " for .htm files");
                List urlList = HTMLAbout._getURLs(baseURL, ".*.htm");
                Iterator urls = urlList.iterator();
                while (urls.hasNext() && modelURL == null) {
                    String model = (String)urls.next();
                    System.out.println("HTMLAbout._expandLibrary(): looking inside " + model);
                    URL possibleModelURL = new URL(baseURL, model);
                    modelList = HTMLAbout._getURLs(possibleModelURL, regexp);
                    if (modelList.size() <= 0) continue;
                    model = (String)modelList.get(0);
                    System.out.println("HTMLAbout._expandLibrary(): looking for model relative to first URL: " + model);
                    modelURL = new URL(baseURL, model);
                }
            }
        }
        if (modelURL == null) {
            String model;
            baseURL = HTMLAbout._getDemoURL(null);
            System.out.println("HTMLAbout._expandLibrary(): looking in completeDemos URL: " + baseURL);
            List modelList = HTMLAbout._getURLs(baseURL, regexp);
            if (modelList.size() > 0) {
                model = (String)modelList.get(0);
                System.out.println("HTMLAbout._expandLibrary(): looking for model relative to completeDemos URL: " + model);
                modelURL = new URL(baseURL, model);
            } else {
                model = "http://ptolemy.eecs.berkeley.edu/ptolemyII/ptIIlatest/ptII/ptolemy/domains/sdf/demo/Butterfly/Butterfly.xml";
                System.out.println("HTMLAbout._expandLibrary(): looking for model relative to completeDemos URL: " + model);
                modelURL = new URL(model);
            }
        }
        System.out.println("HTMLAbout._expandLibrary(): baseURL: " + baseURL);
        System.out.println("HTMLAbout._expandLibrary(): modelURL: " + modelURL);
        Tableau tableau = configuration.openModel(baseURL, modelURL, modelURL.toExternalForm());
        JFrame jFrame = tableau.getFrame();
        String errorMessage = "Expanding the library <b>should</b> result in expanding everything in the left hand tree pane. <p>If the left hand tree pane expands and then contracts, there is a problem with one of the leaves of the tree such as invoking a change request in an <i>XXX</i>Icon.xml. <p>The quickest way to find this is to restart vergil and expand each branch in the tree by hand.";
        try {
            ((BasicGraphFrame)jFrame).expandAllLibraryRows();
        }
        catch (Throwable throwable) {
            throw new IllegalActionException((Nameable)tableau, throwable, "Failed to expand library.\n" + errorMessage);
        }
        return HTMLAbout._temporaryHTMLFile("expandLibrary", ".htm", errorMessage);
    }

    private static URL _getDemoURL(String demosFileName) throws IOException {
        if (demosFileName == null || demosFileName.length() == 0) {
            demosFileName = "ptolemy/configs/doc/completeDemos.htm";
        }
        return MoMLApplication.specToURL(demosFileName);
    }

    private static String _checkCompleteDemos(String completeDemos, List otherDemos) throws IOException {
        URL demosURL = HTMLAbout._getDemoURL(completeDemos);
        StringBuffer results = new StringBuffer("<h1>Results of checking for demos not listed in full demos</h1>\nFor each of the files below, we list demos that are not included in <a href=\"" + demosURL + "\">" + "<code>" + demosURL + "</code></a>\n");
        List completeDemosList = HTMLAbout._getURLs(demosURL, ".*.xml$", true, 1);
        for (String demosFileName : otherDemos) {
            URL demoURL = HTMLAbout._getDemoURL(demosFileName);
            results.append("<h2><a href=\"" + demoURL + "\"><code>" + demoURL + "</code></a></h2>\n<ul>\n");
            List demosList = HTMLAbout._getURLs(demoURL, ".*.xml$", true, 0);
            for (String demo : demosList) {
                if (completeDemosList.contains(demo)) continue;
                URL missingDemoURL = MoMLApplication.specToURL(demo);
                results.append(" <li><a href=\"" + missingDemoURL + "\">" + missingDemoURL + "</a>\n");
            }
            results.append("</ul>\n");
        }
        return results.toString();
    }

    private static List _getURLs(URL demosURL, String regexp) throws IOException {
        return HTMLAbout._getURLs(demosURL, regexp, false, 0);
    }

    private static List _getURLs(URL demosURL, String regexp, boolean absoluteURLs, int depth) throws IOException {
        StringBuffer demosBuffer = new StringBuffer();
        BufferedReader in = null;
        String demosURLParent = demosURL.toString().substring(0, demosURL.toString().lastIndexOf("/") + 1);
        try {
            try {
                String inputLine;
                in = new BufferedReader(new InputStreamReader(demosURL.openStream()));
                while ((inputLine = in.readLine()) != null) {
                    demosBuffer.append(inputLine);
                }
            }
            catch (Exception ex) {
                System.out.println("HTMLAbout: failed to open " + demosURL + "\n" + ex);
                LinkedList linkedList = new LinkedList();
                if (in != null) {
                    in.close();
                }
                return linkedList;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        String demos = demosBuffer.toString();
        LinkedList<String> modelList = new LinkedList<String>();
        int modelStartIndex = demos.indexOf("href=\"");
        while (modelStartIndex != -1) {
            String modelLink;
            int modelEndIndex = demos.indexOf("\"", modelStartIndex + 6);
            if (modelEndIndex != -1 && !(modelLink = demos.substring(modelStartIndex + 6, modelEndIndex)).startsWith("http://") && modelLink.matches(regexp)) {
                String model = modelLink;
                if (absoluteURLs) {
                    model = String.valueOf(demosURLParent) + modelLink;
                    URISyntaxException ex1 = null;
                    try {
                        model = new URI(String.valueOf(demosURLParent) + modelLink).normalize().getPath();
                        model = new File(model).toString().replace('\\', '/');
                    }
                    catch (URISyntaxException ex) {
                        ex1 = ex;
                    }
                    catch (NullPointerException nullPointerException) {}
                    if (model == null) {
                        try {
                            model = MoMLApplication.specToURL(modelLink).toString();
                        }
                        catch (Exception exception) {
                            if (modelLink.startsWith("/")) {
                                modelLink = modelLink.substring(1);
                                try {
                                    model = MoMLApplication.specToURL(modelLink).toString();
                                }
                                catch (Exception exception2) {}
                            }
                            String absoluteModelLink = String.valueOf(demosURLParent) + modelLink;
                            try {
                                model = MoMLApplication.specToURL(absoluteModelLink).toString();
                            }
                            catch (Exception ex3) {
                                System.out.println("Failed to look up " + demosURLParent + modelLink + " and " + modelLink + " and " + absoluteModelLink + "\n" + ex1 + "\n" + ex3);
                            }
                        }
                    }
                }
                if (model != null) {
                    URL modelURL = null;
                    if (model.startsWith("jar:file:/")) {
                        modelURL = new URL(model);
                    } else {
                        if (model.startsWith("file:/")) {
                            model = model.substring("file:/".length());
                        }
                        modelURL = new File(model).toURI().toURL();
                    }
                    boolean sawModel = modelList.contains(model);
                    if (!sawModel) {
                        modelList.add(model);
                        if (depth > 0 && model.matches(".*(.htm|.html)")) {
                            modelList.addAll(HTMLAbout._getURLs(modelURL, regexp, absoluteURLs, depth - 1));
                        }
                    }
                }
            }
            modelStartIndex = demos.indexOf("href=\"", modelEndIndex);
        }
        return modelList;
    }

    private static boolean _configurationExists(String configurationName) {
        boolean configurationExists = false;
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("ptolemy/configs/" + configurationName + "/configuration.xml");
            if (url != null) {
                configurationExists = true;
            }
        }
        catch (Throwable throwable) {}
        return configurationExists;
    }

    private static URL _temporaryHTMLFile(String prefix, String suffix, String contents) throws IOException {
        File temporaryFile = File.createTempFile(prefix, suffix);
        temporaryFile.deleteOnExit();
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(temporaryFile);
            fileWriter.write(contents, 0, contents.length());
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        return temporaryFile.toURI().toURL();
    }
}

